/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.LongPacker;
import net.kotek.jdbm.Serialization;
import net.kotek.jdbm.Serializer;
import sun.reflect.ReflectionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SerialClassInfo {
    static final Serializer<ArrayList<ClassInfo>> serializer = new Serializer<ArrayList<ClassInfo>>(){

        @Override
        public void serialize(DataOutput out, ArrayList<ClassInfo> obj) throws IOException {
            LongPacker.packInt(out, obj.size());
            for (ClassInfo ci : obj) {
                out.writeUTF(ci.getName());
                LongPacker.packInt(out, ci.fields.size());
                for (FieldInfo fi : ci.fields) {
                    out.writeUTF(fi.getName());
                    out.writeBoolean(fi.isPrimitive());
                    out.writeUTF(fi.getType());
                }
            }
        }

        @Override
        public ArrayList<ClassInfo> deserialize(DataInput in) throws IOException, ClassNotFoundException {
            int size = LongPacker.unpackInt(in);
            ArrayList<ClassInfo> ret = new ArrayList<ClassInfo>(size);
            for (int i = 0; i < size; ++i) {
                String className = in.readUTF();
                int fieldsNum = LongPacker.unpackInt(in);
                FieldInfo[] fields = new FieldInfo[fieldsNum];
                for (int j = 0; j < fieldsNum; ++j) {
                    fields[j] = new FieldInfo(in.readUTF(), in.readBoolean(), in.readUTF());
                }
                ret.add(new ClassInfo(className, fields));
            }
            return ret;
        }
    };
    long serialClassInfoRecid;
    ArrayList<ClassInfo> registered;
    final DBAbstract db;

    public SerialClassInfo(DBAbstract db, long serialClassInfoRecid, ArrayList<ClassInfo> registered) {
        this.db = db;
        this.serialClassInfoRecid = serialClassInfoRecid;
        this.registered = registered;
    }

    public void registerClass(Class clazz) throws IOException {
        this.assertClassSerializable(clazz);
        if (this.containsClass(clazz)) {
            return;
        }
        ObjectStreamField[] streamFields = this.getFields(clazz);
        FieldInfo[] fields = new FieldInfo[streamFields.length];
        for (int i = 0; i < fields.length; ++i) {
            ObjectStreamField sf = streamFields[i];
            fields[i] = new FieldInfo(sf);
        }
        ClassInfo i = new ClassInfo(clazz.getName(), fields);
        this.registered.add(i);
        if (this.db != null) {
            this.db.update(this.serialClassInfoRecid, (Serialization)this, this.db.defaultSerializationSerializer);
        }
    }

    private ObjectStreamField[] getFields(Class clazz) {
        ObjectStreamClass streamClass = ObjectStreamClass.lookup(clazz);
        Serialization.FastArrayList<ObjectStreamField> fieldsList = new Serialization.FastArrayList<ObjectStreamField>();
        while (streamClass != null) {
            for (ObjectStreamField f : streamClass.getFields()) {
                fieldsList.add(f);
            }
            clazz = clazz.getSuperclass();
            streamClass = ObjectStreamClass.lookup(clazz);
        }
        ObjectStreamField[] fields = new ObjectStreamField[fieldsList.size()];
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = (ObjectStreamField)fieldsList.get(i);
        }
        return fields;
    }

    private void assertClassSerializable(Class clazz) throws NotSerializableException, InvalidClassException {
        if (!Serializable.class.isAssignableFrom(clazz)) {
            throw new NotSerializableException(clazz.getName());
        }
    }

    public Object getFieldValue(String fieldName, Object object) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getDeclaredMethod("get" + this.firstCharCap(fieldName), new Class[0]);
                if (m != null) {
                    return m.invoke(object, new Object[0]);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Field f = clazz.getDeclaredField(fieldName);
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                return f.get(object);
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchFieldError(object.getClass() + "." + fieldName);
    }

    public void setFieldValue(String fieldName, Object object, Object value) {
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Method m = clazz.getMethod("set" + this.firstCharCap(fieldName), value.getClass());
                if (m != null) {
                    m.invoke(object, value);
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Field f = clazz.getDeclaredField(fieldName);
                if (!f.isAccessible()) {
                    f.setAccessible(true);
                }
                f.set(object, value);
                return;
            }
            catch (Exception e) {
                continue;
            }
        }
        throw new NoSuchFieldError(object.getClass() + "." + fieldName);
    }

    private String firstCharCap(String s) {
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public boolean containsClass(Class clazz) {
        for (ClassInfo c : this.registered) {
            if (!c.getName().equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public int getClassId(Class clazz) {
        for (int i = 0; i < this.registered.size(); ++i) {
            if (!this.registered.get(i).getName().equals(clazz.getName())) continue;
            return i;
        }
        throw new Error("Class is not registered: " + clazz);
    }

    public void writeObject(DataOutput out, Object obj, Serialization.FastArrayList objectStack) throws IOException {
        this.registerClass(obj.getClass());
        int classId = this.getClassId(obj.getClass());
        LongPacker.packInt(out, classId);
        ClassInfo classInfo = this.registered.get(classId);
        ObjectStreamField[] fields = this.getFields(obj.getClass());
        LongPacker.packInt(out, fields.length);
        for (ObjectStreamField f : fields) {
            int fieldId = classInfo.getFieldId(f.getName());
            if (fieldId == -1) {
                fieldId = classInfo.addFieldInfo(new FieldInfo(f));
                this.db.update(this.serialClassInfoRecid, (Serialization)this, this.db.defaultSerializationSerializer);
            }
            LongPacker.packInt(out, fieldId);
            Object fieldValue = this.getFieldValue(f.getName(), obj);
            this.serialize(out, fieldValue, objectStack);
        }
    }

    public Object readObject(DataInput in, Serialization.FastArrayList objectStack) throws IOException {
        try {
            int classId = LongPacker.unpackInt(in);
            ClassInfo classInfo = this.registered.get(classId);
            Class<?> clazz = Class.forName(classInfo.getName());
            this.assertClassSerializable(clazz);
            Object o = SerialClassInfo.createInstance(clazz, Object.class);
            objectStack.add(o);
            int fieldCount = LongPacker.unpackInt(in);
            for (int i = 0; i < fieldCount; ++i) {
                int fieldId = LongPacker.unpackInt(in);
                FieldInfo f = classInfo.getField(fieldId);
                Object fieldValue = this.deserialize(in, objectStack);
                this.setFieldValue(f.getName(), o, fieldValue);
            }
            return o;
        }
        catch (Exception e) {
            throw new Error("Could not instanciate class", e);
        }
    }

    private static <T> T createInstance(Class<T> clazz, Class<? super T> parent) {
        try {
            ReflectionFactory rf = ReflectionFactory.getReflectionFactory();
            Constructor<? super T> objDef = parent.getDeclaredConstructor(new Class[0]);
            Constructor<?> intConstr = rf.newConstructorForSerialization(clazz, objDef);
            return clazz.cast(intConstr.newInstance(new Object[0]));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot create object", e);
        }
    }

    protected abstract Object deserialize(DataInput var1, Serialization.FastArrayList var2) throws IOException, ClassNotFoundException;

    protected abstract void serialize(DataOutput var1, Object var2, Serialization.FastArrayList var3) throws IOException;

    static class FieldInfo {
        private final String name;
        private final boolean primitive;
        private final String type;

        public FieldInfo(String name, boolean primitive, String type) {
            this.name = name;
            this.primitive = primitive;
            this.type = type;
        }

        public FieldInfo(ObjectStreamField sf) {
            this(sf.getName(), sf.isPrimitive(), sf.getType().getName());
        }

        public String getName() {
            return this.name;
        }

        public boolean isPrimitive() {
            return this.primitive;
        }

        public String getType() {
            return this.type;
        }
    }

    static class ClassInfo {
        private final String name;
        private final List<FieldInfo> fields = new ArrayList<FieldInfo>();

        ClassInfo(String name, FieldInfo[] fields) {
            this.name = name;
            for (FieldInfo f : fields) {
                this.fields.add(f);
            }
        }

        public String getName() {
            return this.name;
        }

        public FieldInfo[] getFields() {
            return (FieldInfo[])this.fields.toArray();
        }

        public FieldInfo getField(String name) {
            for (FieldInfo field : this.fields) {
                if (!field.getName().equals(name)) continue;
                return field;
            }
            return null;
        }

        public int getFieldId(String name) {
            for (int i = 0; i < this.fields.size(); ++i) {
                if (!this.fields.get(i).getName().equals(name)) continue;
                return i;
            }
            return -1;
        }

        public FieldInfo getField(int serialId) {
            return this.fields.get(serialId);
        }

        public int addFieldInfo(FieldInfo field) {
            this.fields.add(field);
            return this.fields.size() - 1;
        }
    }
}

