/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import javax.crypto.Cipher;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.LongHashMap;
import net.kotek.jdbm.Storage;
import net.kotek.jdbm.StorageDisk;
import net.kotek.jdbm.StorageDiskMapped;
import net.kotek.jdbm.StorageMemory;
import net.kotek.jdbm.StorageZip;
import net.kotek.jdbm.TransactionManager;
import net.kotek.jdbm.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RecordFile {
    final TransactionManager txnMgr;
    private final LongHashMap<BlockIo> inUse = new LongHashMap();
    private final LongHashMap<BlockIo> dirty = new LongHashMap();
    private final LongHashMap<BlockIo> inTxn = new LongHashMap();
    final boolean transactionsDisabled;
    static final byte[] CLEAN_DATA = new byte[4096];
    final Storage storage;
    private Cipher cipherOut;
    private Cipher cipherIn;

    RecordFile(String fileName, boolean readonly, boolean transactionsDisabled, Cipher cipherIn, Cipher cipherOut, boolean useRandomAccessFile) throws IOException {
        this.cipherIn = cipherIn;
        this.cipherOut = cipherOut;
        this.transactionsDisabled = transactionsDisabled;
        this.storage = fileName == null ? new StorageMemory(transactionsDisabled) : (fileName.contains("!/") ? new StorageZip(fileName) : (useRandomAccessFile ? new StorageDisk(fileName, readonly) : new StorageDiskMapped(fileName, readonly, transactionsDisabled)));
        if (this.storage.isReadonly() && !readonly) {
            throw new IllegalArgumentException("This type of storage is readonly, you should call readonly() on DBMaker");
        }
        this.txnMgr = !readonly && !transactionsDisabled ? new TransactionManager(this, this.storage, cipherIn, cipherOut) : null;
    }

    public RecordFile(String filename) throws IOException {
        this(filename, false, false, null, null, false);
    }

    BlockIo get(long blockid) throws IOException {
        BlockIo node = this.inTxn.get(blockid);
        if (node != null) {
            this.inTxn.remove(blockid);
            this.inUse.put(blockid, node);
            return node;
        }
        node = this.dirty.get(blockid);
        if (node != null) {
            this.dirty.remove(blockid);
            this.inUse.put(blockid, node);
            return node;
        }
        if (this.inUse.get(blockid) != null) {
            throw new Error("double get for block " + blockid);
        }
        if (this.cipherOut == null) {
            node = new BlockIo(blockid, this.storage.read(blockid));
        } else {
            byte[] bb;
            ByteBuffer b = this.storage.read(blockid);
            if (b.hasArray()) {
                bb = b.array();
            } else {
                bb = new byte[4096];
                b.position(0);
                b.get(bb, 0, 4096);
            }
            if (!Utils.allZeros(bb)) {
                try {
                    bb = this.cipherOut.doFinal(bb);
                    node = new BlockIo(blockid, ByteBuffer.wrap(bb));
                }
                catch (Exception e) {
                    throw new IOError(e);
                }
            } else {
                node = new BlockIo(blockid, ByteBuffer.wrap(CLEAN_DATA).asReadOnlyBuffer());
            }
        }
        this.inUse.put(blockid, node);
        node.setClean();
        return node;
    }

    void release(long blockid, boolean isDirty) throws IOException {
        BlockIo block = this.inUse.remove(blockid);
        if (!block.isDirty() && isDirty) {
            block.setDirty();
        }
        if (block.isDirty()) {
            this.dirty.put(blockid, block);
        } else if (!this.transactionsDisabled && block.isInTransaction()) {
            this.inTxn.put(blockid, block);
        }
    }

    void release(BlockIo block) throws IOException {
        long key = block.getBlockId();
        this.inUse.remove(key);
        if (block.isDirty()) {
            this.dirty.put(key, block);
        } else if (!this.transactionsDisabled && block.isInTransaction()) {
            this.inTxn.put(key, block);
        }
    }

    void discard(BlockIo block) {
        long key = block.getBlockId();
        this.inUse.remove(key);
    }

    void commit() throws IOException {
        if (!this.inUse.isEmpty() && this.inUse.size() > 1) {
            this.showList(this.inUse.valuesIterator());
            throw new Error("in use list not empty at commit time (" + this.inUse.size() + ")");
        }
        if (this.dirty.size() == 0) {
            return;
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.start();
        }
        long[] blockIds = new long[this.dirty.size()];
        int c = 0;
        Iterator<BlockIo> i = this.dirty.valuesIterator();
        while (i.hasNext()) {
            blockIds[c] = i.next().getBlockId();
            ++c;
        }
        Arrays.sort(blockIds);
        for (long blockid : blockIds) {
            BlockIo node = this.dirty.get(blockid);
            if (this.transactionsDisabled) {
                if (this.cipherIn != null) {
                    this.storage.write(node.getBlockId(), ByteBuffer.wrap(Utils.encrypt(this.cipherIn, node.getData())));
                } else {
                    this.storage.write(node.getBlockId(), node.getData());
                }
                node.setClean();
                continue;
            }
            this.txnMgr.add(node);
            this.inTxn.put(node.getBlockId(), node);
        }
        this.dirty.clear();
        if (!this.transactionsDisabled) {
            this.txnMgr.commit();
        }
    }

    void rollback() throws IOException {
        if (!this.inUse.isEmpty()) {
            this.showList(this.inUse.valuesIterator());
            throw new Error("in use list not empty at rollback time (" + this.inUse.size() + ")");
        }
        this.dirty.clear();
        this.txnMgr.synchronizeLogFromDisk();
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.valuesIterator());
            throw new Error("in txn list not empty at rollback time (" + this.inTxn.size() + ")");
        }
    }

    void close() throws IOException {
        if (!this.dirty.isEmpty()) {
            this.commit();
        }
        if (!this.transactionsDisabled) {
            this.txnMgr.shutdown();
        }
        if (!this.inTxn.isEmpty()) {
            this.showList(this.inTxn.valuesIterator());
            throw new Error("In transaction not empty");
        }
        if (!this.dirty.isEmpty()) {
            System.out.println("ERROR: dirty blocks at close time");
            this.showList(this.dirty.valuesIterator());
            throw new Error("Dirty blocks at close time");
        }
        if (!this.inUse.isEmpty()) {
            System.out.println("ERROR: inUse blocks at close time");
            this.showList(this.inUse.valuesIterator());
            throw new Error("inUse blocks at close time");
        }
        this.storage.sync();
        this.storage.forceClose();
    }

    void forceClose() throws IOException {
        if (!this.transactionsDisabled) {
            this.txnMgr.forceClose();
        }
        this.storage.forceClose();
    }

    private void showList(Iterator<BlockIo> i) {
        int cnt = 0;
        while (i.hasNext()) {
            System.out.println("elem " + cnt + ": " + i.next());
            ++cnt;
        }
    }

    void synch(BlockIo node) throws IOException {
        ByteBuffer data = node.getData();
        if (data != null) {
            if (this.cipherIn != null) {
                this.storage.write(node.getBlockId(), ByteBuffer.wrap(Utils.encrypt(this.cipherIn, data)));
            } else {
                this.storage.write(node.getBlockId(), data);
            }
        }
    }

    void releaseFromTransaction(BlockIo node) throws IOException {
        this.inTxn.remove(node.getBlockId());
    }

    void sync() throws IOException {
        this.storage.sync();
    }

    public int getDirtyPageCount() {
        return this.dirty.size();
    }

    public void deleteAllFiles() throws IOException {
        this.storage.deleteAllFiles();
    }
}

