/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOException;
import java.util.Arrays;
import net.kotek.jdbm.BlockIo;
import net.kotek.jdbm.Location;
import net.kotek.jdbm.PageManager;
import net.kotek.jdbm.RecordFile;
import net.kotek.jdbm.RecordHeader;
import net.kotek.jdbm.Utils;

final class PhysicalRowIdPageManagerFree {
    static final int DEFRAGMENT_AFTER_N_PAGES = 255;
    boolean needsDefragementation = false;
    static final transient int wasteMargin = 128;
    static final transient int wasteMargin2 = 3;
    protected RecordFile _file;
    protected PageManager _pageman;
    private long[] inTransRecid = new long[4];
    private int[] inTransCapacity = new int[4];
    private int inTransSize = 0;
    private int lastMaxSize = -1;

    PhysicalRowIdPageManagerFree(RecordFile file, PageManager pageman) throws IOException {
        this._file = file;
        this._pageman = pageman;
    }

    static int getFirstFreeLargerThan(BlockIo b, int requestedSize) {
        long waste;
        int maxSize = 0;
        int bestSlot = -1;
        int bestSlotSize = 0;
        for (int i = 0; i < 408; ++i) {
            int waste2;
            short pos = b.FreePhysicalRowId_slotToOffset(i);
            int currentRecSize = b.FreePhysicalRowId_getSize(pos);
            if (currentRecSize > maxSize) {
                maxSize = currentRecSize;
            }
            if ((waste2 = currentRecSize - requestedSize) < 0) continue;
            if (waste2 < 128) {
                return i;
            }
            if (bestSlotSize < currentRecSize) continue;
            bestSlot = i;
            bestSlotSize = currentRecSize;
        }
        if (bestSlot != -1 && (waste = (long)(bestSlotSize - requestedSize)) >= 0L && waste < 3L) {
            return bestSlot;
        }
        return -maxSize;
    }

    long getFreeRecord(int size) throws IOException {
        for (int i = 0; i < this.inTransSize; ++i) {
            if (this.inTransCapacity[i] < size || this.inTransCapacity[i] >= size + 128) continue;
            long ret = this.inTransRecid[i];
            --this.inTransSize;
            this.inTransRecid[i] = this.inTransRecid[this.inTransSize];
            this.inTransCapacity[i] = this.inTransCapacity[this.inTransSize];
            return ret;
        }
        int pageCounter = 0;
        if (this.lastMaxSize != -1 && size > this.lastMaxSize) {
            return 0L;
        }
        long retval = 0L;
        int maxSize = -1;
        long current = this._pageman.getFirst((short)4);
        while (current != 0L) {
            BlockIo fp = this._file.get(current);
            ++pageCounter;
            int slot = PhysicalRowIdPageManagerFree.getFirstFreeLargerThan(fp, size);
            if (slot > 0) {
                this.lastMaxSize = -1;
                retval = fp.FreePhysicalRowId_slotToLocation(slot);
                fp.FreePhysicalRowId_free(slot);
                if (fp.FreePhysicalRowId_getCount() == 0) {
                    this._file.release(current, false);
                    this._pageman.free((short)4, current);
                } else {
                    this._file.release(current, true);
                }
                if (pageCounter > 255) {
                    this.needsDefragementation = true;
                }
                return retval;
            }
            if (maxSize < -slot) {
                maxSize = -slot;
            }
            this._file.release(current, false);
            current = this._pageman.getNext(current);
        }
        this.lastMaxSize = maxSize;
        if (pageCounter > 255) {
            this.needsDefragementation = true;
        }
        return 0L;
    }

    void putFreeRecord(long rowid, int size) throws IOException {
        if (this.inTransSize == this.inTransRecid.length) {
            this.inTransRecid = Arrays.copyOf(this.inTransRecid, this.inTransRecid.length * 2);
            this.inTransCapacity = Arrays.copyOf(this.inTransCapacity, this.inTransCapacity.length * 2);
        }
        this.inTransRecid[this.inTransSize] = rowid;
        this.inTransCapacity[this.inTransSize] = size;
        ++this.inTransSize;
    }

    public void commit() throws IOException {
        if (this.inTransSize == 0) {
            return;
        }
        Utils.quickSort(this.inTransRecid, this.inTransCapacity, 0, this.inTransSize - 1);
        int prevIndex = 0;
        for (int i = 1; i < this.inTransSize; ++i) {
            if (this.inTransCapacity[i] == 0) continue;
            if (this.inTransCapacity[i] + this.inTransCapacity[prevIndex] < Short.MAX_VALUE && this.inTransRecid[prevIndex] + (long)this.inTransCapacity[i] == this.inTransRecid[i]) {
                long blockId = Location.getBlock(this.inTransRecid[prevIndex]);
                BlockIo b = this._file.get(blockId);
                RecordHeader.setCurrentSize(b, Location.getOffset(this.inTransRecid[prevIndex]), 0);
                int n = prevIndex;
                this.inTransCapacity[n] = this.inTransCapacity[n] + this.inTransCapacity[i];
                RecordHeader.setAvailableSize(b, Location.getOffset(this.inTransRecid[prevIndex]), this.inTransCapacity[prevIndex]);
                this._file.release(b);
                this.inTransRecid[i] = 0L;
                this.inTransCapacity[i] = 0;
                ++i;
                continue;
            }
            prevIndex = i;
        }
        int rowidpos = 0;
        long curpage = this._pageman.getFirst((short)4);
        if (this._file.transactionsDisabled && this.inTransSize > 200) {
            curpage = 0L;
        }
        while (rowidpos < this.inTransSize) {
            BlockIo fp = curpage != 0L ? this._file.get(curpage) : this._file.get(this._pageman.allocate((short)4));
            int slot = fp.FreePhysicalRowId_getFirstFree();
            while (slot != -1 && rowidpos < this.inTransSize) {
                int size = this.inTransCapacity[rowidpos];
                long rowid = this.inTransRecid[rowidpos++];
                if (size == 0) continue;
                short freePhysPos = fp.FreePhysicalRowId_alloc(slot);
                fp.pageHeaderSetLocation(freePhysPos, rowid);
                fp.FreePhysicalRowId_setSize(freePhysPos, size);
                slot = fp.FreePhysicalRowId_getFirstFree();
            }
            this._file.release(fp);
            if (rowidpos >= this.inTransSize) break;
            if (curpage == 0L) continue;
            curpage = this._pageman.getNext(curpage);
        }
        this.clearFreeInTrans();
    }

    public void rollback() {
        this.clearFreeInTrans();
    }

    private void clearFreeInTrans() {
        if (this.inTransRecid.length > 128) {
            this.inTransRecid = new long[4];
        }
        if (this.inTransCapacity.length > 128) {
            this.inTransCapacity = new int[4];
        }
        this.inTransSize = 0;
    }
}

