/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOException;
import javax.crypto.Cipher;
import net.kotek.jdbm.DBCache;
import net.kotek.jdbm.LongHashMap;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DBCacheMRU
extends DBCache {
    private static final boolean debug = false;
    protected LongHashMap<CacheEntry> _hash;
    protected int _max;
    protected CacheEntry _first;
    protected CacheEntry _last;

    public DBCacheMRU(String filename, boolean readonly, boolean transactionDisabled, Cipher cipherIn, Cipher cipherOut, boolean useRandomAccessFile, boolean autodefrag, boolean deleteFilesAfterClose, int cacheMaxRecords) {
        super(filename, readonly, transactionDisabled, cipherIn, cipherOut, useRandomAccessFile, autodefrag, deleteFilesAfterClose);
        this._hash = new LongHashMap(cacheMaxRecords);
        this._max = cacheMaxRecords;
    }

    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer, boolean disableCache) throws IOException {
        if (disableCache) {
            return super.fetch(recid, serializer, disableCache);
        }
        return this.fetch(recid, serializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void delete(long recid) throws IOException {
        this.checkNotClosed();
        super.delete(recid);
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._hash.get(recid);
            if (entry != null) {
                this.removeEntry(entry);
                this._hash.remove(entry._recid);
            }
            this._hashDirties.remove(recid);
        }
        if (super.needsAutoCommit()) {
            this.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized <A> void update(long recid, A obj, Serializer<A> serializer) throws IOException {
        this.checkNotClosed();
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            DBCache.DirtyCacheEntry e;
            CacheEntry entry = this.cacheGet(recid);
            if (entry != null) {
                this.removeEntry(entry);
            }
            if ((e = (DBCache.DirtyCacheEntry)this._hashDirties.get(recid)) != null) {
                if (recid != e._recid) {
                    throw new Error();
                }
                e._obj = obj;
                e._serializer = serializer;
                return;
            }
            e = new DBCache.DirtyCacheEntry();
            e._recid = recid;
            e._obj = obj;
            e._serializer = serializer;
            this._hashDirties.put(recid, e);
        }
        if (super.needsAutoCommit()) {
            this.commit();
        }
    }

    @Override
    public synchronized <A> A fetch(long recid, Serializer<A> serializer) throws IOException {
        this.checkNotClosed();
        CacheEntry entry = this.cacheGet(recid);
        if (entry != null) {
            return (A)entry._obj;
        }
        DBCache.DirtyCacheEntry entry2 = (DBCache.DirtyCacheEntry)this._hashDirties.get(recid);
        if (entry2 != null) {
            return (A)entry2._obj;
        }
        A value = super.fetch(recid, serializer);
        if (super.needsAutoCommit()) {
            this.commit();
        }
        this.cachePut(recid, value);
        return value;
    }

    @Override
    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.updateCacheEntries();
        super.close();
        this._hash = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void rollback() {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            this._hash.clear();
            this._first = null;
            this._last = null;
        }
        super.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry cacheGet(long key) {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._hash.get(key);
            if (entry != null && this._last != entry) {
                this.removeEntry(entry);
                this.addEntry(entry);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cachePut(long recid, Object value) throws IOException {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._hash.get(recid);
            if (entry != null) {
                entry._obj = value;
                if (this._last != entry) {
                    this.removeEntry(entry);
                    this.addEntry(entry);
                }
            } else {
                if (this._hash.size() == this._max) {
                    entry = this.purgeEntry();
                    entry._recid = recid;
                    entry._obj = value;
                } else {
                    entry = new CacheEntry(recid, value);
                }
                this.addEntry(entry);
                this._hash.put(entry._recid, entry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addEntry(CacheEntry entry) {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            if (this._first == null) {
                this._first = entry;
                this._last = entry;
            } else {
                this._last._next = entry;
                entry._previous = this._last;
                this._last = entry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeEntry(CacheEntry entry) {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            if (entry == this._first) {
                this._first = entry._next;
            }
            if (this._last == entry) {
                this._last = entry._previous;
            }
            CacheEntry previous = entry._previous;
            CacheEntry next = entry._next;
            if (previous != null) {
                previous._next = next;
            }
            if (next != null) {
                next._previous = previous;
            }
            entry._previous = null;
            entry._next = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CacheEntry purgeEntry() {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            CacheEntry entry = this._first;
            if (entry == null) {
                return new CacheEntry(-1L, null);
            }
            this.removeEntry(entry);
            this._hash.remove(entry._recid);
            entry._obj = null;
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        LongHashMap<CacheEntry> longHashMap = this._hash;
        synchronized (longHashMap) {
            this._hash.clear();
            this._first = null;
            this._last = null;
            this.updateCacheEntries();
        }
    }

    static final class CacheEntry {
        protected long _recid;
        protected Object _obj;
        protected CacheEntry _previous;
        protected CacheEntry _next;

        CacheEntry(long recid, Object obj) {
            this._recid = recid;
            this._obj = obj;
        }
    }
}

