/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.crypto.Cipher;
import net.kotek.jdbm.DBStore;
import net.kotek.jdbm.LongHashMap;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DBCache
extends DBStore {
    static final int NUM_OF_DIRTY_RECORDS_BEFORE_AUTOCOMIT = 100;
    static final byte NONE = 1;
    static final byte MRU = 2;
    static final byte WEAK = 3;
    static final byte SOFT = 4;
    static final byte HARD = 5;
    protected final LongHashMap<DirtyCacheEntry> _hashDirties = new LongHashMap();
    private static final Comparator<DirtyCacheEntry> DIRTY_COMPARATOR = new Comparator<DirtyCacheEntry>(){

        @Override
        public final int compare(DirtyCacheEntry o1, DirtyCacheEntry o2) {
            return (int)(o1._recid - o2._recid);
        }
    };

    public DBCache(String filename, boolean readonly, boolean transactionDisabled, Cipher cipherIn, Cipher cipherOut, boolean useRandomAccessFile, boolean autodefrag, boolean deleteFilesAfterClose) {
        super(filename, readonly, transactionDisabled, cipherIn, cipherOut, useRandomAccessFile, autodefrag, deleteFilesAfterClose);
    }

    @Override
    boolean needsAutoCommit() {
        return super.needsAutoCommit() || !this.commitInProgress && this._hashDirties.size() > 100;
    }

    @Override
    public synchronized <A> long insert(A obj, Serializer<A> serializer, boolean disableCache) throws IOException {
        this.checkNotClosed();
        if (super.needsAutoCommit()) {
            this.commit();
        }
        if (disableCache) {
            return super.insert(obj, serializer, disableCache);
        }
        long recid = super.insert(PREALOCATE_OBJ, null, disableCache);
        DirtyCacheEntry e = new DirtyCacheEntry();
        e._recid = recid;
        e._obj = obj;
        e._serializer = serializer;
        this._hashDirties.put(recid, e);
        return recid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void commit() {
        try {
            this.commitInProgress = true;
            this.updateCacheEntries();
            super.commit();
        }
        finally {
            this.commitInProgress = false;
        }
    }

    @Override
    public synchronized void rollback() {
        this._hashDirties.clear();
        super.rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCacheEntries() {
        try {
            LongHashMap<DirtyCacheEntry> longHashMap = this._hashDirties;
            synchronized (longHashMap) {
                while (!this._hashDirties.isEmpty()) {
                    int i;
                    DirtyCacheEntry[] vals = new DirtyCacheEntry[this._hashDirties.size()];
                    Iterator<DirtyCacheEntry> iter = this._hashDirties.valuesIterator();
                    for (i = 0; i < vals.length; ++i) {
                        vals[i] = iter.next();
                    }
                    iter = null;
                    Arrays.sort(vals, DIRTY_COMPARATOR);
                    for (i = 0; i < vals.length; ++i) {
                        DirtyCacheEntry entry = vals[i];
                        vals[i] = null;
                        super.update(entry._recid, entry._obj, entry._serializer);
                        this._hashDirties.remove(entry._recid);
                    }
                }
            }
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    static final class DirtyCacheEntry {
        long _recid;
        Object _obj;
        Serializer _serializer;

        DirtyCacheEntry() {
        }
    }
}

