/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.crypto.Cipher;
import net.kotek.jdbm.Location;
import net.kotek.jdbm.Utils;

final class BlockIo {
    private long blockId;
    private ByteBuffer data;
    private boolean dirty = false;
    private int transactionCount = 0;

    public BlockIo() {
    }

    BlockIo(long blockId, byte[] data) {
        this.blockId = blockId;
        this.data = ByteBuffer.wrap(data);
    }

    public BlockIo(long blockid, ByteBuffer data) {
        this.blockId = blockid;
        this.data = data;
    }

    ByteBuffer getData() {
        return this.data;
    }

    long getBlockId() {
        return this.blockId;
    }

    void setDirty() {
        this.dirty = true;
        if (this.data.isReadOnly()) {
            ByteBuffer old = this.data;
            this.data = ByteBuffer.allocate(4096);
            old.rewind();
            old.get(this.data.array(), 0, 4096);
            this.data.rewind();
        }
    }

    void setClean() {
        this.dirty = false;
    }

    boolean isDirty() {
        return this.dirty;
    }

    boolean isInTransaction() {
        return this.transactionCount != 0;
    }

    void incrementTransactionCount() {
        ++this.transactionCount;
        this.setClean();
    }

    void decrementTransactionCount() {
        --this.transactionCount;
        if (this.transactionCount < 0) {
            throw new Error("transaction count on block " + this.getBlockId() + " below zero!");
        }
    }

    public byte readByte(int pos) {
        return this.data.get(pos);
    }

    public void writeByte(int pos, byte value) {
        this.setDirty();
        this.data.put(pos, value);
    }

    public short readShort(int pos) {
        return this.data.getShort(pos);
    }

    public void writeShort(int pos, short value) {
        this.setDirty();
        this.data.putShort(pos, value);
    }

    public int readInt(int pos) {
        return this.data.getInt(pos);
    }

    public void writeInt(int pos, int value) {
        this.setDirty();
        this.data.putInt(pos, value);
    }

    public long readLong(int pos) {
        return this.data.getLong(pos);
    }

    public void writeLong(int pos, long value) {
        this.setDirty();
        this.data.putLong(pos, value);
    }

    public long readSixByteLong(int pos) {
        long ret = (long)(this.data.get(pos + 0) & 0x7F) << 40 | (long)(this.data.get(pos + 1) & 0xFF) << 32 | (long)(this.data.get(pos + 2) & 0xFF) << 24 | (long)(this.data.get(pos + 3) & 0xFF) << 16 | (long)(this.data.get(pos + 4) & 0xFF) << 8 | (long)(this.data.get(pos + 5) & 0xFF) << 0;
        if ((this.data.get(pos + 0) & 0x80) != 0) {
            return -ret;
        }
        return ret;
    }

    public void writeSixByteLong(int pos, long value) {
        int negativeBit = 0;
        if (value < 0L) {
            value = -value;
            negativeBit = 128;
        }
        this.setDirty();
        this.data.put(pos + 0, (byte)(0x7FL & value >> 40 | (long)negativeBit));
        this.data.put(pos + 1, (byte)(0xFFL & value >> 32));
        this.data.put(pos + 2, (byte)(0xFFL & value >> 24));
        this.data.put(pos + 3, (byte)(0xFFL & value >> 16));
        this.data.put(pos + 4, (byte)(0xFFL & value >> 8));
        this.data.put(pos + 5, (byte)(0xFFL & value >> 0));
    }

    public String toString() {
        return "BlockIO(" + this.blockId + "," + this.dirty + ")";
    }

    public void readExternal(DataInputStream in, Cipher cipherOut) throws IOException {
        this.blockId = in.readLong();
        byte[] data2 = new byte[4096];
        in.readFully(data2);
        if (cipherOut == null || Utils.allZeros(data2)) {
            this.data = ByteBuffer.wrap(data2);
        } else {
            try {
                this.data = ByteBuffer.wrap(cipherOut.doFinal(data2));
            }
            catch (Exception e) {
                throw new IOError(e);
            }
        }
    }

    public void writeExternal(DataOutput out, Cipher cipherIn) throws IOException {
        out.writeLong(this.blockId);
        out.write(Utils.encrypt(cipherIn, this.data.array()));
    }

    public byte[] getByteArray() {
        if (this.data.hasArray()) {
            return this.data.array();
        }
        byte[] d = new byte[4096];
        this.data.rewind();
        this.data.get(d, 0, 4096);
        return d;
    }

    public void writeByteArray(byte[] buf, int srcOffset, int offset, int length) {
        this.setDirty();
        this.data.rewind();
        this.data.position(offset);
        this.data.put(buf, srcOffset, length);
    }

    public void fileHeaderCheckHead(boolean isNew) {
        if (isNew) {
            this.writeShort(0, (short)4944);
        } else {
            short magic = this.readShort(0);
            if (magic != 4944) {
                throw new Error("CRITICAL: file header magic not OK " + magic);
            }
        }
    }

    long fileHeaderGetFirstOf(int list) {
        return this.readLong(this.fileHeaderOffsetOfFirst(list));
    }

    void fileHeaderSetFirstOf(int list, long value) {
        this.writeLong(this.fileHeaderOffsetOfFirst(list), value);
    }

    long fileHeaderGetLastOf(int list) {
        return this.readLong(this.fileHeaderOffsetOfLast(list));
    }

    void fileHeaderSetLastOf(int list, long value) {
        this.writeLong(this.fileHeaderOffsetOfLast(list), value);
    }

    private short fileHeaderOffsetOfFirst(int list) {
        return (short)(2 + 16 * list);
    }

    private short fileHeaderOffsetOfLast(int list) {
        return (short)(this.fileHeaderOffsetOfFirst(list) + 8);
    }

    long fileHeaderGetRoot(int root) {
        short offset = (short)(82 + root * 8);
        return this.readLong(offset);
    }

    void fileHeaderSetRoot(int root, long rowid) {
        short offset = (short)(82 + root * 8);
        this.writeLong(offset, rowid);
    }

    boolean pageHeaderMagicOk() {
        short magic = this.pageHeaderGetMagic();
        return magic >= 4945 && magic <= 4949;
    }

    protected void pageHeaderParanoiaMagicOk() {
        if (!this.pageHeaderMagicOk()) {
            throw new Error("CRITICAL: page header magic not OK " + this.pageHeaderGetMagic());
        }
    }

    short pageHeaderGetMagic() {
        return this.readShort(0);
    }

    long pageHeaderGetNext() {
        this.pageHeaderParanoiaMagicOk();
        return this.readSixByteLong(2);
    }

    void pageHeaderSetNext(long next) {
        this.pageHeaderParanoiaMagicOk();
        this.writeSixByteLong(2, next);
    }

    long pageHeaderGetPrev() {
        this.pageHeaderParanoiaMagicOk();
        return this.readSixByteLong(8);
    }

    void pageHeaderSetPrev(long prev) {
        this.pageHeaderParanoiaMagicOk();
        this.writeSixByteLong(8, prev);
    }

    void pageHeaderSetType(short type) {
        this.writeShort(0, (short)(4945 + type));
    }

    long pageHeaderGetLocation(short pos) {
        return this.readSixByteLong(pos + 0);
    }

    void pageHeaderSetLocation(short pos, long value) {
        this.writeSixByteLong(pos + 0, value);
    }

    short dataPageGetFirst() {
        return this.readShort(14);
    }

    void dataPageSetFirst(short value) {
        this.pageHeaderParanoiaMagicOk();
        if (value > 0 && value < 16) {
            throw new Error("DataPage.setFirst: offset " + value + " too small");
        }
        this.writeShort(14, value);
    }

    short FreePhysicalRowId_getCount() {
        return this.readShort(14);
    }

    private void FreePhysicalRowId_setCount(short i) {
        this.writeShort(14, i);
    }

    void FreePhysicalRowId_free(int slot) {
        short pos = this.FreePhysicalRowId_slotToOffset(slot);
        this.FreePhysicalRowId_setSize(pos, 0);
        this.FreePhysicalRowId_setCount((short)(this.FreePhysicalRowId_getCount() - 1));
    }

    short FreePhysicalRowId_alloc(int slot) {
        this.FreePhysicalRowId_setCount((short)(this.FreePhysicalRowId_getCount() + 1));
        return this.FreePhysicalRowId_slotToOffset(slot);
    }

    boolean FreePhysicalRowId_isFree(int slot) {
        short pos = this.FreePhysicalRowId_slotToOffset(slot);
        return this.FreePhysicalRowId_getSize(pos) == 0;
    }

    short FreePhysicalRowId_slotToOffset(int slot) {
        return (short)(16 + slot * 10);
    }

    int FreePhysicalRowId_offsetToSlot(short pos) {
        short pos2 = pos;
        return (pos2 - 16) / 10;
    }

    int FreePhysicalRowId_getFirstFree() {
        if (this.FreeLogicalRowId_getCount() == 408) {
            return -1;
        }
        for (int i = 0; i < 408; ++i) {
            if (!this.FreePhysicalRowId_isFree(i)) continue;
            return i;
        }
        return -1;
    }

    int FreePhysicalRowId_getSize(short pos) {
        return this.readInt(pos + 6);
    }

    void FreePhysicalRowId_setSize(short pos, int value) {
        this.writeInt(pos + 6, value);
    }

    public long FreePhysicalRowId_slotToLocation(int slot) {
        short pos = this.FreePhysicalRowId_slotToOffset(slot);
        return this.pageHeaderGetLocation(pos);
    }

    short FreeLogicalRowId_getCount() {
        return this.readShort(14);
    }

    private void FreeLogicalRowId_setCount(short i) {
        this.writeShort(14, i);
    }

    boolean FreeLogicalRowId_isFree(int slot) {
        return !this.FreeLogicalRowId_isAllocated(slot);
    }

    boolean FreeLogicalRowId_isAllocated(int slot) {
        return this.pageHeaderGetLocation(this.FreeLogicalRowId_slotToOffset(slot)) > 0L;
    }

    short FreeLogicalRowId_slotToOffset(int slot) {
        return (short)(20 + slot * 6);
    }

    void FreeLogicalRowId_free(short slot) {
        this.pageHeaderSetLocation(this.FreeLogicalRowId_slotToOffset(slot), Location.toLong(0L, (short)0));
        this.FreeLogicalRowId_setCount((short)(this.FreeLogicalRowId_getCount() - 1));
        if (slot < this.readShort(16)) {
            this.writeShort(16, slot);
        }
    }

    short FreeLogicalRowId_alloc(short slot) {
        this.FreeLogicalRowId_setCount((short)(this.FreeLogicalRowId_getCount() + 1));
        short pos = this.FreeLogicalRowId_slotToOffset(slot);
        this.pageHeaderSetLocation(pos, Location.toLong(-1L, (short)0));
        if (slot < this.readShort(18)) {
            this.writeShort(18, slot);
        }
        return pos;
    }

    short FreeLogicalRowId_getFirstFree() {
        for (short previousFoundFree = this.readShort(16); previousFoundFree < 679; previousFoundFree = (short)(previousFoundFree + 1)) {
            if (!this.FreeLogicalRowId_isFree(previousFoundFree)) continue;
            this.writeShort(16, previousFoundFree);
            return previousFoundFree;
        }
        return -1;
    }

    short FreeLogicalRowId_getFirstAllocated() {
        for (short previousFoundAllocated = this.readShort(18); previousFoundAllocated < 679; previousFoundAllocated = (short)(previousFoundAllocated + 1)) {
            if (!this.FreeLogicalRowId_isAllocated(previousFoundAllocated)) continue;
            this.writeShort(18, previousFoundAllocated);
            return previousFoundAllocated;
        }
        return -1;
    }

    public long FreeLogicalRowId_slotToLocation(int slot) {
        short pos = this.FreeLogicalRowId_slotToOffset(slot);
        return this.pageHeaderGetLocation(pos);
    }
}

