/*
 * Decompiled with CFR 0.152.
 */
package net.kotek.jdbm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOError;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.kotek.jdbm.BTreeNode;
import net.kotek.jdbm.DBAbstract;
import net.kotek.jdbm.DBStore;
import net.kotek.jdbm.DataInputOutput;
import net.kotek.jdbm.RecordListener;
import net.kotek.jdbm.Serialization;
import net.kotek.jdbm.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BTree<K, V> {
    private static final boolean DEBUG = false;
    public static final int DEFAULT_SIZE = 32;
    protected transient DBAbstract _db;
    private transient long _recid;
    protected Comparator<K> _comparator;
    protected Serializer<K> keySerializer;
    protected Serializer<V> valueSerializer;
    boolean loadValues = true;
    boolean hasValues = true;
    transient int modCount = 0;
    protected BTreeNode.InsertResult<K, V> insertResultReuse;
    private int _height;
    private transient long _root;
    protected volatile int _entries;
    private transient BTreeNode<K, V> _nodeSerializer = new BTreeNode();
    protected RecordListener[] recordListeners;
    protected final ReadWriteLock lock;
    private static final BTreeTupleBrowser EMPTY_BROWSER = new BTreeTupleBrowser(){

        public boolean getNext(BTreeTuple tuple) {
            return false;
        }

        public boolean getPrevious(BTreeTuple tuple) {
            return false;
        }

        public void remove(Object key) {
            throw new IndexOutOfBoundsException();
        }
    };

    public Serializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    public Serializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public BTree() {
        this._nodeSerializer._btree = this;
        this.recordListeners = new RecordListener[0];
        this.lock = new ReentrantReadWriteLock();
    }

    public static <K extends Comparable, V> BTree<K, V> createInstance(DBAbstract db) throws IOException {
        return BTree.createInstance(db, null, null, null, true);
    }

    public static <K, V> BTree<K, V> createInstance(DBAbstract db, Comparator<K> comparator, Serializer<K> keySerializer, Serializer<V> valueSerializer, boolean hasValues) throws IOException {
        if (db == null) {
            throw new IllegalArgumentException("Argument 'db' is null");
        }
        BTree<K, V> btree = new BTree<K, V>();
        btree._db = db;
        btree._comparator = comparator;
        btree.keySerializer = keySerializer;
        btree.valueSerializer = valueSerializer;
        btree.hasValues = hasValues;
        btree._recid = db.insert(btree, btree.getRecordManager().defaultSerializer(), false);
        return btree;
    }

    public static <K, V> BTree<K, V> load(DBAbstract db, long recid) throws IOException {
        BTree btree = (BTree)db.fetch(recid);
        btree._recid = recid;
        btree._db = db;
        btree._nodeSerializer = new BTreeNode();
        btree._nodeSerializer._btree = btree;
        return btree;
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V insert(K key, V value, boolean replace) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("Argument 'value' is null");
        }
        try {
            this.lock.writeLock().lock();
            BTreeNode<Object, Object> rootNode = this.getRoot();
            if (rootNode == null) {
                rootNode = new BTreeNode<K, V>(this, key, value);
                this._root = rootNode._recid;
                this._height = 1;
                this._entries = 1;
                this._db.update(this._recid, this);
                ++this.modCount;
                for (RecordListener l : this.recordListeners) {
                    l.recordInserted(key, value);
                }
                RecordListener[] arr$ = null;
                return (V)arr$;
            }
            BTreeNode.InsertResult<K, V> insert = rootNode.insert(this._height, key, value, replace);
            boolean dirty = false;
            if (insert._overflow != null) {
                rootNode = new BTreeNode(this, rootNode, insert._overflow);
                this._root = rootNode._recid;
                ++this._height;
                dirty = true;
            }
            if (insert._existing == null) {
                ++this._entries;
                ++this.modCount;
                dirty = true;
            }
            if (dirty) {
                this._db.update(this._recid, this);
            }
            for (RecordListener l : this.recordListeners) {
                if (insert._existing == null) {
                    l.recordInserted(key, value);
                    continue;
                }
                l.recordUpdated(key, insert._existing, value);
            }
            Object ret = insert._existing;
            insert._existing = null;
            insert._overflow = null;
            this.insertResultReuse = insert;
            Object v = ret;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        try {
            this.lock.writeLock().lock();
            BTreeNode<K, V> rootNode = this.getRoot();
            if (rootNode == null) {
                V v = null;
                return v;
            }
            boolean dirty = false;
            BTreeNode.RemoveResult<K, V> remove = rootNode.remove(this._height, key);
            if (remove._underflow && rootNode.isEmpty()) {
                --this._height;
                dirty = true;
                this._db.delete(this._root);
                this._root = this._height == 0 ? 0L : rootNode.loadLastChildNode()._recid;
            }
            if (remove._value != null) {
                --this._entries;
                ++this.modCount;
                dirty = true;
            }
            if (dirty) {
                this._db.update(this._recid, this);
            }
            if (remove._value != null) {
                for (RecordListener l : this.recordListeners) {
                    l.recordRemoved(key, remove._value);
                }
            }
            Object v = remove._value;
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) throws IOException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 'key' is null");
        }
        try {
            this.lock.readLock().lock();
            BTreeNode<K, V> rootNode = this.getRoot();
            if (rootNode == null) {
                V v = null;
                return v;
            }
            V v = rootNode.findValue(this._height, key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public BTreeTuple<K, V> findGreaterOrEqual(K key) throws IOException {
        if (key == null) {
            return null;
        }
        BTreeTuple<Object, Object> tuple = new BTreeTuple<Object, Object>(null, null);
        BTreeTupleBrowser<Object, Object> browser = this.browse(key, true);
        if (browser.getNext(tuple)) {
            return tuple;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BTreeTupleBrowser<K, V> browse() throws IOException {
        try {
            this.lock.readLock().lock();
            BTreeNode<K, V> rootNode = this.getRoot();
            if (rootNode == null) {
                BTreeTupleBrowser bTreeTupleBrowser = EMPTY_BROWSER;
                return bTreeTupleBrowser;
            }
            BTreeTupleBrowser<K, V> bTreeTupleBrowser = rootNode.findFirst();
            return bTreeTupleBrowser;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BTreeTupleBrowser<K, V> browse(K key, boolean inclusive) throws IOException {
        try {
            BTreeTupleBrowser<K, V> browser;
            this.lock.readLock().lock();
            BTreeNode<K, V> rootNode = this.getRoot();
            if (rootNode == null) {
                BTreeTupleBrowser bTreeTupleBrowser = EMPTY_BROWSER;
                return bTreeTupleBrowser;
            }
            BTreeTupleBrowser<K, V> bTreeTupleBrowser = browser = rootNode.find(this._height, key, inclusive);
            return bTreeTupleBrowser;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        return this._entries;
    }

    public long getRecid() {
        return this._recid;
    }

    BTreeNode<K, V> getRoot() throws IOException {
        if (this._root == 0L) {
            return null;
        }
        BTreeNode root = (BTreeNode)this._db.fetch(this._root, this._nodeSerializer);
        if (root != null) {
            root._recid = this._root;
            root._btree = this;
        }
        return root;
    }

    static BTree readExternal(DataInput in, Serialization ser) throws IOException, ClassNotFoundException {
        BTree tree = new BTree();
        tree._db = ser.db;
        tree._height = in.readInt();
        tree._recid = in.readLong();
        tree._root = in.readLong();
        tree._entries = in.readInt();
        tree.hasValues = in.readBoolean();
        tree._comparator = (Comparator)ser.deserialize(in);
        tree.keySerializer = (Serializer)ser.deserialize(in);
        tree.valueSerializer = (Serializer)ser.deserialize(in);
        return tree;
    }

    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this._height);
        out.writeLong(this._recid);
        out.writeLong(this._root);
        out.writeInt(this._entries);
        out.writeBoolean(this.hasValues);
        this._db.defaultSerializer().serialize(out, this._comparator);
        this._db.defaultSerializer().serialize(out, this.keySerializer);
        this._db.defaultSerializer().serialize(out, this.valueSerializer);
    }

    public static void defrag(long recid, DBStore r1, DBStore r2) throws IOException {
        try {
            byte[] data = r1.fetchRaw(recid);
            r2.forceInsert(recid, data);
            DataInputOutput in = new DataInputOutput(data);
            BTree t = (BTree)r1.defaultSerializer().deserialize(in);
            t.loadValues = false;
            t._db = r1;
            t._nodeSerializer = new BTreeNode(t, false);
            BTreeNode p = t.getRoot();
            if (p != null) {
                r2.forceInsert(t._root, r1.fetchRaw(t._root));
                p.defrag(r1, r2);
            }
        }
        catch (ClassNotFoundException e) {
            throw new IOError(e);
        }
    }

    public void addRecordListener(RecordListener<K, V> listener) {
        this.recordListeners = Arrays.copyOf(this.recordListeners, this.recordListeners.length + 1);
        this.recordListeners[this.recordListeners.length - 1] = listener;
    }

    public void removeRecordListener(RecordListener<K, V> listener) {
        List<RecordListener> l = Arrays.asList(this.recordListeners);
        l.remove(listener);
        this.recordListeners = l.toArray(new RecordListener[1]);
    }

    public DBAbstract getRecordManager() {
        return this._db;
    }

    public Comparator<K> getComparator() {
        return this._comparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() throws IOException {
        try {
            this.lock.writeLock().lock();
            BTreeNode<K, V> rootNode = this.getRoot();
            if (rootNode != null) {
                rootNode.delete();
            }
            this._entries = 0;
            ++this.modCount;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    void dumpChildNodeRecIDs(List<Long> out) throws IOException {
        BTreeNode<K, V> root = this.getRoot();
        if (root != null) {
            out.add(root._recid);
            root.dumpChildNodeRecIDs(out, this._height);
        }
    }

    public boolean hasValues() {
        return this.hasValues;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class BTreeTuple<K, V> {
        K key;
        V value;

        BTreeTuple() {
        }

        BTreeTuple(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface BTreeTupleBrowser<K, V> {
        public boolean getNext(BTreeTuple<K, V> var1) throws IOException;

        public boolean getPrevious(BTreeTuple<K, V> var1) throws IOException;

        public void remove(K var1) throws IOException;
    }
}

