/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.security.KeyPair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.mapreduce.Mapper;
import net.tomp2p.mapreduce.TaskManager;
import net.tomp2p.mapreduce.TaskStatus;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class TaskRPC
extends ReplyHandler {
    private final TaskManager taskManager;

    public TaskRPC(PeerBean peerBean, ConnectionBean connectionBean, TaskManager taskManager) {
        super(peerBean, connectionBean);
        this.taskManager = taskManager;
        this.registerIoHandler(Message.Command.TASK);
    }

    public FutureResponse task(PeerAddress remotePeer, ChannelCreator channelCreator, Number160 taskID, Map<Number160, Data> dataMap, Mapper mapper, KeyPair keyPair, boolean forceUDP) {
        Message message = this.createMessage(remotePeer, Message.Command.TASK, Message.Type.REQUEST_1);
        FutureResponse futureResponse = new FutureResponse(message);
        try {
            byte[] me = Utils.encodeJavaObject(mapper);
            ChannelBuffer payload = ChannelBuffers.wrappedBuffer((byte[])me);
            message.setPayload(payload);
            message.setDataMap(dataMap);
            message.setKey(taskID);
            if (keyPair != null) {
                message.setPublicKeyAndSign(keyPair);
            }
            if (forceUDP) {
                RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message);
                return requestHandler.sendUDP(channelCreator);
            }
            RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message);
            return requestHandler.sendTCP(channelCreator);
        }
        catch (IOException ioe) {
            futureResponse.setFailed(ioe.toString());
            return futureResponse;
        }
    }

    public FutureResponse taskStatus(PeerAddress remotePeer, ChannelCreator channelCreator, Collection<Number160> taskIDs, boolean forceTCP) {
        Message message = this.createMessage(remotePeer, Message.Command.TASK, Message.Type.REQUEST_2);
        message.setKeys(taskIDs);
        FutureResponse futureResponse = new FutureResponse(message);
        if (!forceTCP) {
            RequestHandlerUDP<FutureResponse> requestHandler = new RequestHandlerUDP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message);
            return requestHandler.sendUDP(channelCreator);
        }
        RequestHandlerTCP<FutureResponse> requestHandler = new RequestHandlerTCP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message);
        return requestHandler.sendTCP(channelCreator);
    }

    @Override
    public boolean checkMessage(Message message) {
        return (message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_2) && message.getCommand() == Message.Command.TASK;
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        Message responseMessage = this.createMessage(message.getSender(), message.getCommand(), Message.Type.OK);
        if (message.getType() == Message.Type.REQUEST_1) {
            Number160 taskId = message.getKey();
            Map<Number160, Data> dataMap = message.getDataMap();
            ChannelBuffer channelBuffer = message.getPayload1();
            Object obj = Utils.decodeJavaObject(channelBuffer.array(), channelBuffer.arrayOffset(), channelBuffer.capacity());
            Mapper mapper = (Mapper)obj;
            int queuePosition = this.taskManager.submitTask(taskId, mapper, dataMap);
            responseMessage.setInteger(queuePosition);
        } else if (message.getType() == Message.Type.REQUEST_2) {
            Collection<Number160> taskIDs = message.getKeys();
            for (Number160 taskId : taskIDs) {
                TaskStatus taskStatus = this.taskManager.taskStatus(taskId);
                Data data = new Data(taskStatus);
                HashMap<Number160, Data> resultMap = new HashMap<Number160, Data>();
                resultMap.put(taskId, data);
                message.setDataMap(resultMap);
            }
        } else {
            responseMessage.setType(Message.Type.NOT_FOUND);
        }
        return responseMessage;
    }
}

