/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(HandshakeRPC.class);
    private final List<PeerListener> listeners;
    private final boolean enable;
    private final boolean wait;

    public HandshakeRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, new ArrayList<PeerListener>());
    }

    public HandshakeRPC(PeerBean peerBean, ConnectionBean connectionBean, List<PeerListener> listeners) {
        this(peerBean, connectionBean, listeners, true, true, false);
    }

    HandshakeRPC(PeerBean peerBean, ConnectionBean connectionBean, List<PeerListener> listeners, boolean enable, boolean register, boolean wait) {
        super(peerBean, connectionBean);
        this.enable = enable;
        this.wait = wait;
        this.listeners = listeners;
        if (register) {
            this.registerIoHandler(Message.Command.PING);
        }
    }

    public FutureResponse pingBroadcastUDP(PeerAddress remotePeer, ChannelCreator channelCreator) {
        return this.createHandlerUDP(remotePeer, Message.Type.REQUEST_1).sendBroadcastUDP(channelCreator);
    }

    public RequestHandlerUDP<FutureResponse> pingUDP(PeerAddress remotePeer) {
        return this.createHandlerUDP(remotePeer, Message.Type.REQUEST_1);
    }

    public FutureResponse pingUDP(PeerAddress remotePeer, ChannelCreator channelCreator) {
        return this.pingUDP(remotePeer).sendUDP(channelCreator);
    }

    public FutureResponse pingTCP(PeerAddress remotePeer, ChannelCreator channelCreator) {
        return this.createHandlerTCP(remotePeer, Message.Type.REQUEST_1).sendTCP(channelCreator);
    }

    public FutureResponse fireUDP(PeerAddress remotePeer, ChannelCreator channelCreator) {
        return this.createHandlerUDP(remotePeer, Message.Type.REQUEST_FF_1).fireAndForgetUDP(channelCreator);
    }

    public FutureResponse fireTCP(PeerAddress remotePeer, ChannelCreator channelCreator) {
        return this.createHandlerTCP(remotePeer, Message.Type.REQUEST_FF_1).fireAndForgetTCP(channelCreator);
    }

    private RequestHandlerUDP<FutureResponse> createHandlerUDP(PeerAddress remotePeer, Message.Type type) {
        Message message = this.createMessage(remotePeer, Message.Command.PING, type);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerUDP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message);
    }

    private RequestHandlerTCP<FutureResponse> createHandlerTCP(PeerAddress remotePeer, Message.Type type) {
        Message message = this.createMessage(remotePeer, Message.Command.PING, type);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerTCP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message);
    }

    public FutureResponse pingUDPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, Message.Command.PING, Message.Type.REQUEST_2);
        ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
        self.add(this.peerBean.getServerPeerAddress());
        message.setNeighbors(self);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerUDP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPDiscover(PeerAddress remotePeer, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, Message.Command.PING, Message.Type.REQUEST_2);
        ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
        self.add(this.peerBean.getServerPeerAddress());
        message.setNeighbors(self);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerTCP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPProbe(PeerAddress remotePeer, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, Message.Command.PING, Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerUDP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPProbe(PeerAddress remotePeer, ChannelCreator channelCreator) {
        Message message = this.createMessage(remotePeer, Message.Command.PING, Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerTCP<FutureResponse>(futureResponse, this.peerBean, this.connectionBean, message).sendTCP(channelCreator);
    }

    @Override
    public boolean checkMessage(Message message) {
        return (message.getType() == Message.Type.REQUEST_FF_1 || message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_3) && message.getCommand() == Message.Command.PING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message handleResponse(final Message message, boolean sign) throws Exception {
        if (message.getType() == Message.Type.REQUEST_3) {
            if (logger.isDebugEnabled()) {
                logger.debug("reply to probing, fire message to " + message.getSender());
            }
            Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
            if (sign) {
                responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
            }
            responseMessage.setMessageId(message.getMessageId());
            if (message.isUDP()) {
                this.connectionBean.getConnectionReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            FutureResponse futureResponse = HandshakeRPC.this.fireUDP(message.getSender(), future.getChannelCreator());
                            Utils.addReleaseListenerAll(futureResponse, HandshakeRPC.this.connectionBean.getConnectionReservation(), future.getChannelCreator());
                        } else if (logger.isWarnEnabled()) {
                            logger.warn("handleResponse for REQUEST_3 failed (UDP) " + future.getFailedReason());
                        }
                    }
                });
            } else {
                this.connectionBean.getConnectionReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                    @Override
                    public void operationComplete(FutureChannelCreator future) throws Exception {
                        if (future.isSuccess()) {
                            FutureResponse futureResponse = HandshakeRPC.this.fireTCP(message.getSender(), future.getChannelCreator());
                            Utils.addReleaseListenerAll(futureResponse, HandshakeRPC.this.connectionBean.getConnectionReservation(), future.getChannelCreator());
                        } else if (logger.isWarnEnabled()) {
                            logger.warn("handleResponse for REQUEST_3 failed (TCP) " + future.getFailedReason());
                        }
                    }
                });
            }
            return responseMessage;
        }
        if (message.getType() == Message.Type.REQUEST_2) {
            if (logger.isDebugEnabled()) {
                logger.debug("reply to discover, found " + message.getSender());
            }
            Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
            if (sign) {
                responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
            }
            responseMessage.setMessageId(message.getMessageId());
            ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
            self.add(message.getSender());
            responseMessage.setNeighbors(self);
            return responseMessage;
        }
        if (message.getType() == Message.Type.REQUEST_1) {
            if (message.getSender().getID().equals(this.peerBean.getServerPeerAddress().getID()) && message.getRecipient().getID().equals(Number160.ZERO)) {
                return message;
            }
            if (this.enable) {
                Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
                if (sign) {
                    responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
                }
                responseMessage.setMessageId(message.getMessageId());
                if (this.wait) {
                    Timings.sleepUninterruptibly(10000);
                }
                return responseMessage;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("do not reply");
            }
            if (this.wait) {
                Timings.sleepUninterruptibly(10000);
            }
            return null;
        }
        if (message.getType() == Message.Type.REQUEST_FF_1) {
            PeerAddress serverAddress = this.peerBean.getServerPeerAddress();
            if (message.isUDP()) {
                PeerAddress newServerAddress = serverAddress.changeFirewalledUDP(false);
                this.peerBean.setServerPeerAddress(newServerAddress);
                List<PeerListener> list = this.listeners;
                synchronized (list) {
                    for (PeerListener listener : this.listeners) {
                        listener.serverAddressChanged(newServerAddress, false);
                    }
                }
            }
            PeerAddress newServerAddress = serverAddress.changeFirewalledTCP(false);
            this.peerBean.setServerPeerAddress(newServerAddress);
            List<PeerListener> list = this.listeners;
            synchronized (list) {
                for (PeerListener listener : this.listeners) {
                    listener.serverAddressChanged(newServerAddress, true);
                }
            }
            return message;
        }
        return null;
    }
}

