/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.tomp2p.upnp.DiscoveryResultsHandler;
import net.tomp2p.upnp.HttpResponse;
import net.tomp2p.utils.Timings;

public class DiscoveryListener
implements Runnable {
    private static final int DEFAULT_TIMEOUT = 250;
    private Map<String, Set<DiscoveryResultsHandler>> registeredHandlers = new HashMap<String, Set<DiscoveryResultsHandler>>();
    private final Object REGISTRATION_PROCESS = new Object();
    private static final DiscoveryListener singleton = new DiscoveryListener();
    private boolean inService = false;
    private boolean daemon = true;
    private MulticastSocket skt;
    private DatagramPacket input;

    private DiscoveryListener() {
    }

    static final DiscoveryListener getInstance() {
        return singleton;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResultsHandler(DiscoveryResultsHandler resultsHandler, String searchTarget) throws IOException {
        Object object = this.REGISTRATION_PROCESS;
        synchronized (object) {
            Set<DiscoveryResultsHandler> handlers;
            if (!this.inService) {
                this.startDevicesListenerThread();
            }
            if ((handlers = this.registeredHandlers.get(searchTarget)) == null) {
                handlers = new HashSet<DiscoveryResultsHandler>();
                this.registeredHandlers.put(searchTarget, handlers);
            }
            handlers.add(resultsHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterResultsHandler(DiscoveryResultsHandler resultsHandler, String searchTarget) {
        Object object = this.REGISTRATION_PROCESS;
        synchronized (object) {
            Set<DiscoveryResultsHandler> handlers = this.registeredHandlers.get(searchTarget);
            if (handlers != null) {
                handlers.remove(resultsHandler);
                if (handlers.size() == 0) {
                    this.registeredHandlers.remove(searchTarget);
                }
            }
            if (this.registeredHandlers.size() == 0) {
                this.stopDevicesListenerThread();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startDevicesListenerThread() throws IOException {
        DiscoveryListener discoveryListener = singleton;
        synchronized (discoveryListener) {
            if (!this.inService) {
                this.startMultiCastSocket();
                Thread deamon = new Thread((Runnable)this, "DiscoveryListener daemon");
                deamon.setDaemon(this.daemon);
                deamon.start();
                while (!this.inService) {
                    try {
                        Timings.sleep(2);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopDevicesListenerThread() {
        DiscoveryListener discoveryListener = singleton;
        synchronized (discoveryListener) {
            this.inService = false;
        }
    }

    private void startMultiCastSocket() throws IOException {
        int bindPort = 1901;
        this.skt = new MulticastSocket(null);
        this.skt.bind(new InetSocketAddress(InetAddress.getByName("0.0.0.0"), bindPort));
        this.skt.setTimeToLive(4);
        this.skt.setSoTimeout(250);
        this.skt.joinGroup(InetAddress.getByName("239.255.255.250"));
        byte[] buf = new byte[2048];
        this.input = new DatagramPacket(buf, buf.length);
    }

    @Override
    public void run() {
        if (!Thread.currentThread().getName().equals("DiscoveryListener daemon")) {
            throw new RuntimeException("No right to call this method");
        }
        this.inService = true;
        while (this.inService) {
            try {
                this.listenBroadCast();
            }
            catch (SocketTimeoutException ex) {
            }
            catch (IOException ioEx) {
                ioEx.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.inService = false;
            }
        }
        try {
            this.skt.leaveGroup(InetAddress.getByName("239.255.255.250"));
            this.skt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listenBroadCast() throws IOException {
        this.skt.receive(this.input);
        InetAddress from = this.input.getAddress();
        String received = new String(this.input.getData(), this.input.getOffset(), this.input.getLength());
        HttpResponse msg = null;
        try {
            msg = new HttpResponse(received);
        }
        catch (IllegalArgumentException ex) {
            return;
        }
        String header = msg.getHeader();
        if (header != null && header.startsWith("HTTP/1.1 200 OK") && msg.getHTTPHeaderField("st") != null) {
            String deviceDescrLoc = msg.getHTTPHeaderField("location");
            if (deviceDescrLoc == null || deviceDescrLoc.trim().length() == 0) {
                return;
            }
            URL loc = new URL(deviceDescrLoc);
            String st = msg.getHTTPHeaderField("st");
            if (st == null || st.trim().length() == 0) {
                return;
            }
            String usn = msg.getHTTPHeaderField("usn");
            if (usn == null || usn.trim().length() == 0) {
                return;
            }
            String maxAge = msg.getHTTPFieldElement("Cache-Control", "max-age");
            if (maxAge == null || maxAge.trim().length() == 0) {
                return;
            }
            String server = msg.getHTTPHeaderField("server");
            if (server == null || server.trim().length() == 0) {
                return;
            }
            String udn = usn;
            int index = udn.indexOf("::");
            if (index != -1) {
                udn = udn.substring(0, index);
            }
            Object object = this.REGISTRATION_PROCESS;
            synchronized (object) {
                Set<DiscoveryResultsHandler> handlers = this.registeredHandlers.get(st);
                if (handlers != null) {
                    for (DiscoveryResultsHandler handler : handlers) {
                        handler.discoveredDevice(usn, udn, st, maxAge, loc, server, from);
                    }
                }
            }
        }
    }
}

