/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import net.tomp2p.peers.PeerAddress;

public class TrackerData
implements Comparable<TrackerData> {
    private final PeerAddress peerAddress;
    private final PeerAddress referrer;
    private final byte[] attachement;
    private final int offset;
    private final int length;
    private final boolean couldProvideMoreData;

    public TrackerData(PeerAddress peerAddress, PeerAddress referrer, byte[] attachement, int offset, int length) {
        this(peerAddress, referrer, attachement, offset, length, false);
    }

    public TrackerData(PeerAddress peerAddress, PeerAddress referrer, byte[] attachement, int offset, int length, boolean couldProvideMoreData) {
        this.peerAddress = peerAddress;
        this.referrer = referrer;
        this.attachement = attachement;
        this.offset = offset;
        this.length = length;
        this.couldProvideMoreData = couldProvideMoreData;
    }

    public PeerAddress getPeerAddress() {
        return this.peerAddress;
    }

    public PeerAddress getReferrer() {
        return this.referrer;
    }

    public byte[] getAttachement() {
        return this.attachement;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TrackerData)) {
            return false;
        }
        return ((TrackerData)obj).getPeerAddress().getID().equals(this.getPeerAddress().getID());
    }

    @Override
    public int compareTo(TrackerData o) {
        return this.getPeerAddress().getID().compareTo(o.getPeerAddress().getID());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("p:").append(this.peerAddress).append(",l:").append(this.length);
        return sb.toString();
    }

    public boolean couldProvideMoreData() {
        return this.couldProvideMoreData;
    }
}

