/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionReservation;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private static final int NR_THREADS = Runtime.getRuntime().availableProcessors() + 1;
    private static final int WARNING_THRESHOLD = 10000;
    private final LinkedBlockingQueue<Runnable> executorQueue = new LinkedBlockingQueue();
    private final Queue<Timeout> timeouts = new PriorityQueue<Timeout>();
    private final ExecutorService executor = new ThreadPoolExecutor(NR_THREADS, NR_THREADS, 0L, TimeUnit.MILLISECONDS, this.executorQueue, new MyThreadFactory());
    private final ExecutorService timeoutExecutor = Executors.newSingleThreadExecutor();
    private volatile Maintenance maintenance;
    private volatile boolean running = true;

    public void addQueue(FutureRunnable futureRunnable) {
        if (logger.isDebugEnabled()) {
            logger.debug("we are called from a TCP netty thread, so send this in an other thread " + Thread.currentThread().getName() + ". The queue size is: " + this.executorQueue.size());
        }
        if (this.executorQueue.size() > 10000 && logger.isInfoEnabled()) {
            logger.info("slow down, we have a huge backlog!");
        }
        if (this.executor.isShutdown()) {
            futureRunnable.failed("shutting down");
            return;
        }
        this.executor.execute(futureRunnable);
    }

    public void shutdown() {
        this.running = false;
        List<Runnable> runners = this.executor.shutdownNow();
        for (Runnable runner : runners) {
            FutureRunnable futureRunnable = (FutureRunnable)runner;
            futureRunnable.failed("Shutting down...");
        }
        if (this.maintenance != null) {
            this.maintenance.shutdown();
        }
        this.timeoutExecutor.shutdownNow();
    }

    public void startMaintainance(final PeerMap peerMap, HandshakeRPC handshakeRPC, ConnectionReservation connectionReservation, int max) {
        if (this.maintenance == null) {
            this.maintenance = new Maintenance(peerMap, handshakeRPC, connectionReservation, max);
            this.maintenance.start();
        } else {
            this.maintenance.add(peerMap);
            this.maintenance.getMasterPeerMap().addPeerOfflineListener(new PeerStatusListener(){

                @Override
                public void peerOnline(PeerAddress peerAddress) {
                    if (peerMap.contains(peerAddress)) {
                        peerMap.peerFound(peerAddress, null);
                    }
                }

                @Override
                public void peerOffline(PeerAddress peerAddress, PeerStatusListener.Reason reason) {
                }

                @Override
                public void peerFail(PeerAddress peerAddress, boolean force) {
                    peerMap.peerOffline(peerAddress, force);
                }
            });
        }
    }

    public void startTimeout() {
        this.timeoutExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (Scheduler.this.running) {
                        Timeout timeout;
                        Queue queue = Scheduler.this.timeouts;
                        synchronized (queue) {
                            timeout = (Timeout)Scheduler.this.timeouts.poll();
                        }
                        int waitingTime = timeout == null ? Integer.MAX_VALUE : (int)(timeout.getExpiration() - Timings.currentTimeMillis());
                        if (waitingTime > 0) {
                            Queue queue2 = Scheduler.this.timeouts;
                            synchronized (queue2) {
                                Scheduler.this.timeouts.wait(waitingTime);
                            }
                        }
                        if (waitingTime == Integer.MAX_VALUE) continue;
                        waitingTime = (int)(timeout.getExpiration() - Timings.currentTimeMillis());
                        if (waitingTime > 0) {
                            Scheduler.this.timeouts.add(timeout);
                            continue;
                        }
                        timeout.getBaseFuture().setFailed(timeout.getReason());
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTimeout(BaseFuture baseFuture, int millis, String reason) {
        Queue<Timeout> queue = this.timeouts;
        synchronized (queue) {
            this.timeouts.add(new Timeout(baseFuture, Timings.currentTimeMillis() + (long)millis, reason));
            this.timeouts.notifyAll();
        }
    }

    String poll() {
        Timeout t = this.timeouts.poll();
        if (t != null) {
            return t.getReason();
        }
        return null;
    }

    private static class Timeout
    implements Comparable<Timeout> {
        private final BaseFuture baseFuture;
        private final long expiration;
        private final String reason;

        public Timeout(BaseFuture baseFuture, long expiration, String reason) {
            this.baseFuture = baseFuture;
            this.expiration = expiration;
            this.reason = reason;
        }

        public BaseFuture getBaseFuture() {
            return this.baseFuture;
        }

        public long getExpiration() {
            return this.expiration;
        }

        public String getReason() {
            return this.reason;
        }

        @Override
        public int compareTo(Timeout o) {
            long diff = this.expiration - o.expiration;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }

    private class Maintenance
    extends Thread
    implements Runnable {
        private final List<PeerMap> peerMaps = new ArrayList<PeerMap>();
        private final HandshakeRPC handshakeRPC;
        private final ConnectionReservation connectionReservation;
        private final PeerMap masterPeerMap;
        private final int max;

        public Maintenance(PeerMap peerMap, HandshakeRPC handshakeRPC, ConnectionReservation connectionReservation, int max) {
            this.handshakeRPC = handshakeRPC;
            this.connectionReservation = connectionReservation;
            this.max = max;
            this.masterPeerMap = peerMap;
            this.add(peerMap);
            this.setName("maintenance");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<PeerAddress> checkPeers = new ArrayList<PeerAddress>();
            while (Scheduler.this.running) {
                List<PeerMap> list = this.peerMaps;
                synchronized (list) {
                    if (checkPeers.size() == 0) {
                        for (PeerMap peerMap : this.peerMaps) {
                            checkPeers.addAll(peerMap.peersForMaintenance());
                        }
                    }
                }
                int max2 = Math.min(this.max, checkPeers.size());
                final FutureLateJoin lateJoin = new FutureLateJoin(max2);
                Iterator iterator = checkPeers.iterator();
                for (int i = 0; i < max2; ++i) {
                    final PeerAddress peerAddress = (PeerAddress)iterator.next();
                    FutureChannelCreator fcc = this.connectionReservation.reserve(1);
                    fcc.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                        @Override
                        public void operationComplete(FutureChannelCreator future) throws Exception {
                            if (future.isSuccess()) {
                                ChannelCreator cc = future.getChannelCreator();
                                FutureResponse futureResponse = Maintenance.this.handshakeRPC.pingUDP(peerAddress, cc);
                                Utils.addReleaseListener(futureResponse, Maintenance.this.connectionReservation, cc, 1);
                                lateJoin.add(futureResponse);
                            }
                        }
                    });
                    iterator.remove();
                }
                try {
                    lateJoin.await();
                    Timings.sleep(1000);
                }
                catch (InterruptedException e) {
                    lateJoin.setFailed("interrupted");
                }
            }
        }

        public void shutdown() {
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(PeerMap peerMap) {
            List<PeerMap> list = this.peerMaps;
            synchronized (list) {
                this.peerMaps.add(peerMap);
            }
        }

        public PeerMap getMasterPeerMap() {
            return this.masterPeerMap;
        }
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private int nr = 0;

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "scheduler-" + this.nr);
            ++this.nr;
            return t;
        }
    }
}

