/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.ReplyTimeoutHandler;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.TomP2PDecoderTCP;
import net.tomp2p.message.TomP2PDecoderUDP;
import net.tomp2p.message.TomP2PEncoderTCP;
import net.tomp2p.message.TomP2PEncoderUDP;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class ChannelCreator {
    private final Semaphore connectionSemaphore;
    private final ChannelGroup channelsTCP = new DefaultChannelGroup("TomP2P ConnectionPool TCP");
    private final ChannelGroup channelsUDP = new DefaultChannelGroup("TomP2P ConnectionPool UDP");
    private final String name;
    private final long creatorThread;
    private final MessageLogger messageLoggerFilter;
    private final ChannelFactory tcpClientChannelFactory;
    private final ChannelFactory udpChannelFactory;
    private final boolean keepAliveAndReuse;
    private final Map<InetSocketAddress, ChannelFuture> cacheMap;
    private final Statistics statistics;
    private volatile boolean shutdown;
    private volatile AtomicInteger permitsCount;

    ChannelCreator(int permits, Statistics statistics, MessageLogger messageLoggerFilter, ChannelFactory tcpClientChannelFactory, ChannelFactory udpClientChannelFactory, boolean keepAliveAndReuse, String name, long creatorThread) {
        this.permitsCount = new AtomicInteger(permits);
        this.connectionSemaphore = new Semaphore(permits);
        this.cacheMap = new ConcurrentHashMap<InetSocketAddress, ChannelFuture>(permits);
        this.messageLoggerFilter = messageLoggerFilter;
        this.tcpClientChannelFactory = tcpClientChannelFactory;
        this.udpChannelFactory = udpClientChannelFactory;
        this.keepAliveAndReuse = keepAliveAndReuse;
        this.statistics = statistics;
        this.name = name;
        this.creatorThread = creatorThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel createUDPChannel(ReplyTimeoutHandler timeoutHandler, RequestHandlerUDP<? extends BaseFuture> requestHandler, FutureResponse futureResponse, boolean broadcast) {
        Channel channel;
        if (this.shutdown) {
            return null;
        }
        if (!this.connectionSemaphore.tryAcquire()) {
            throw new RuntimeException("you ran out of permits. You had " + this.permitsCount + " available, but now its down to 0");
        }
        this.statistics.incrementUDPChannelCreation();
        try {
            channel = this.createChannelUDP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, broadcast);
        }
        catch (Exception e) {
            futureResponse.setFailed("Cannot create channel " + e);
            this.connectionSemaphore.release();
            this.statistics.decrementUDPChannelCreation();
            return null;
        }
        ChannelCreator channelCreator = this;
        synchronized (channelCreator) {
            if (this.shutdown) {
                channel.close().awaitUninterruptibly();
                futureResponse.setFailed("shutdown in progres (ChannelCreator/UDP)");
                this.connectionSemaphore.release();
                this.statistics.decrementUDPChannelCreation();
                return null;
            }
            this.channelsUDP.add((Object)channel);
        }
        channel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelCreator.this.connectionSemaphore.release();
                ChannelCreator.this.statistics.decrementUDPChannelCreation();
            }
        });
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFuture createTCPChannel(ReplyTimeoutHandler timeoutHandler, RequestHandlerTCP<? extends BaseFuture> requestHandler, FutureResponse futureResponse, int connectTimeoutMillis, final InetSocketAddress recipient) {
        ChannelFuture channelFuture;
        if (this.shutdown) {
            return null;
        }
        boolean newConnection = true;
        if (this.keepAliveAndReuse) {
            channelFuture = this.cacheMap.get(recipient);
            if (channelFuture == null) {
                if (!this.connectionSemaphore.tryAcquire()) {
                    throw new RuntimeException("you ran out of permits. You had " + this.permitsCount + " available, but now its down to 0");
                }
                this.statistics.incrementTCPChannelCreation();
                channelFuture = this.createChannelTCP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, recipient, new InetSocketAddress(0), connectTimeoutMillis);
                this.cacheMap.put(recipient, channelFuture);
            } else {
                newConnection = false;
                ReplyTimeoutHandler oldTimoutHandler = (ReplyTimeoutHandler)channelFuture.getChannel().getPipeline().replace("timeout", "timeout", (ChannelHandler)timeoutHandler);
                oldTimoutHandler.cancel();
                channelFuture.getChannel().getPipeline().replace("request", "request", requestHandler);
            }
        } else {
            if (!this.connectionSemaphore.tryAcquire()) {
                throw new RuntimeException("you ran out of permits. You had " + this.permitsCount + " available, but now its down to 0");
            }
            this.statistics.incrementTCPChannelCreation();
            try {
                channelFuture = this.createChannelTCP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, recipient, new InetSocketAddress(0), connectTimeoutMillis);
            }
            catch (Exception e) {
                futureResponse.setFailed("Cannot create channel " + e);
                this.connectionSemaphore.release();
                this.statistics.decrementTCPChannelCreation();
                return null;
            }
        }
        Channel channel = channelFuture.getChannel();
        ChannelCreator channelCreator = this;
        synchronized (channelCreator) {
            if (this.shutdown) {
                channel.close().awaitUninterruptibly();
                futureResponse.setFailed("shutdown in progres (ChannelCreator/TCP)");
                this.connectionSemaphore.release();
                this.statistics.decrementTCPChannelCreation();
                return null;
            }
            this.channelsTCP.add((Object)channel);
        }
        if (newConnection) {
            channel.getCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ChannelCreator.this.connectionSemaphore.release();
                    ChannelCreator.this.statistics.decrementTCPChannelCreation();
                    if (ChannelCreator.this.keepAliveAndReuse) {
                        ChannelCreator.this.cacheMap.remove(recipient);
                    }
                }
            });
        }
        return channelFuture;
    }

    private ChannelFuture createChannelTCP(ChannelHandler timeoutHandler, ChannelHandler requestHandler, SocketAddress remoteAddress, SocketAddress localAddress, int connectionTimoutMillis) {
        ClientBootstrap bootstrap = new ClientBootstrap(this.tcpClientChannelFactory);
        bootstrap.setOption("connectTimeoutMillis", (Object)connectionTimoutMillis);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("soLinger", (Object)0);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        ChannelCreator.setupBootstrapTCP((Bootstrap)bootstrap, timeoutHandler, requestHandler, (ChannelUpstreamHandler)new TomP2PDecoderTCP(), new TomP2PEncoderTCP(), new ChunkedWriteHandler(), (ChannelHandler)this.messageLoggerFilter);
        ChannelFuture channelFuture = bootstrap.connect(remoteAddress);
        return channelFuture;
    }

    private Channel createChannelUDP(ChannelHandler timeoutHandler, ChannelHandler requestHandler, boolean allowBroadcast) {
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap(this.udpChannelFactory);
        ChannelCreator.setupBootstrapUDP((Bootstrap)bootstrap, timeoutHandler, requestHandler, new TomP2PDecoderUDP(), new TomP2PEncoderUDP(), (ChannelHandler)this.messageLoggerFilter);
        bootstrap.setOption("broadcast", (Object)(allowBroadcast ? 1 : 0));
        bootstrap.setOption("receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1400));
        Channel c = bootstrap.bind((SocketAddress)new InetSocketAddress(0));
        return c;
    }

    private static void setupBootstrapTCP(Bootstrap bootstrap, ChannelHandler timeoutHandler, ChannelHandler requestHandler, ChannelUpstreamHandler decoder, ChannelDownstreamHandler encoder, ChunkedWriteHandler streamer, ChannelHandler messageLoggerFilter) {
        ChannelPipeline pipe = bootstrap.getPipeline();
        if (timeoutHandler != null) {
            pipe.addLast("timeout", timeoutHandler);
        }
        pipe.addLast("streamer", (ChannelHandler)streamer);
        pipe.addLast("encoder", (ChannelHandler)encoder);
        pipe.addLast("decoder", (ChannelHandler)decoder);
        if (messageLoggerFilter != null) {
            pipe.addLast("loggerUpstream", messageLoggerFilter);
        }
        if (requestHandler != null) {
            pipe.addLast("request", requestHandler);
        }
    }

    private static void setupBootstrapUDP(Bootstrap bootstrap, ChannelHandler timeoutHandler, ChannelHandler requestHandler, ChannelUpstreamHandler decoder, ChannelDownstreamHandler encoder, ChannelHandler messageLoggerFilter) {
        ChannelPipeline pipe = bootstrap.getPipeline();
        if (timeoutHandler != null) {
            pipe.addLast("timeout", timeoutHandler);
        }
        pipe.addLast("encoder", (ChannelHandler)encoder);
        pipe.addLast("decoder", (ChannelHandler)decoder);
        if (messageLoggerFilter != null) {
            pipe.addLast("loggerUpstream", messageLoggerFilter);
        }
        if (requestHandler != null) {
            pipe.addLast("request", requestHandler);
        }
    }

    public ChannelFuture close(PeerAddress destination) {
        ChannelFuture channelFuture = this.cacheMap.get(destination);
        if (channelFuture != null) {
            return channelFuture.getChannel().close();
        }
        return null;
    }

    public int getPermits() {
        return this.permitsCount.get();
    }

    void release(int permits) {
        this.connectionSemaphore.release(permits);
        int result = this.permitsCount.addAndGet(-permits);
        if (result < 0) {
            throw new RuntimeException("Cannot release more than I acquired");
        }
    }

    public boolean hasNoPermits() {
        return this.permitsCount.compareAndSet(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ChannelCreator channelCreator = this;
        synchronized (channelCreator) {
            this.shutdown = true;
            this.channelsTCP.close().awaitUninterruptibly();
            this.channelsUDP.close().awaitUninterruptibly();
        }
    }

    public String getName() {
        return this.name;
    }

    public long getCreatorThread() {
        return this.creatorThread;
    }
}

