/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.rpc.HashData;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.Digest;
import net.tomp2p.storage.Responsibility;
import net.tomp2p.storage.StorageRunner;
import net.tomp2p.utils.Utils;

public abstract class Storage
implements Digest,
Responsibility {
    private ProtectionMode protectionDomainMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionDomainEnable = ProtectionEnable.ALL;
    private ProtectionMode protectionEntryMode = ProtectionMode.MASTER_PUBLIC_KEY;
    private ProtectionEnable protectionEntryEnable = ProtectionEnable.ALL;
    private Collection<Number160> removedDomains = new HashSet<Number160>();

    public abstract boolean put(Number480 var1, Data var2, PublicKey var3, boolean var4, boolean var5);

    public abstract Data get(Number480 var1);

    public abstract SortedMap<Number480, Data> get(Number480 var1, Number480 var2);

    public abstract SortedMap<Number480, Data> remove(Number480 var1, Number480 var2, PublicKey var3);

    public abstract Data remove(Number480 var1, PublicKey var2);

    public abstract boolean contains(Number480 var1);

    public abstract void iterateAndRun(Number160 var1, StorageRunner var2);

    public abstract void close();

    public abstract Collection<Number480> storedDirectReplication();

    public SortedMap<Number480, Data> remove(Number320 number320, PublicKey publicKey) {
        return this.remove(number320.min(), number320.max(), publicKey);
    }

    public SortedMap<Number480, Data> get(Number320 key) {
        return this.get(key.min(), key.max());
    }

    public void setProtection(ProtectionEnable protectionDomainEnable, ProtectionMode protectionDomainMode, ProtectionEnable protectionEntryEnable, ProtectionMode protectionEntryMode) {
        this.setProtectionDomainEnable(protectionDomainEnable);
        this.setProtectionDomainMode(protectionDomainMode);
        this.setProtectionEntryEnable(protectionEntryEnable);
        this.setProtectionEntryMode(protectionEntryMode);
    }

    public void setProtectionDomainMode(ProtectionMode protectionDomainMode) {
        this.protectionDomainMode = protectionDomainMode;
    }

    public ProtectionMode getProtectionDomainMode() {
        return this.protectionDomainMode;
    }

    public void setProtectionDomainEnable(ProtectionEnable protectionDomainEnable) {
        this.protectionDomainEnable = protectionDomainEnable;
    }

    public ProtectionEnable getProtectionDomainEnable() {
        return this.protectionDomainEnable;
    }

    public void setProtectionEntryMode(ProtectionMode protectionEntryMode) {
        this.protectionEntryMode = protectionEntryMode;
    }

    public ProtectionMode getProtectionEntryMode() {
        return this.protectionEntryMode;
    }

    public void setProtectionEntryEnable(ProtectionEnable protectionEntryEnable) {
        this.protectionEntryEnable = protectionEntryEnable;
    }

    public ProtectionEnable getProtectionEntryEnable() {
        return this.protectionEntryEnable;
    }

    public void removeDomainProtection(Number160 removeDomain) {
        this.removedDomains.add(removeDomain);
    }

    boolean isDomainRemoved(Number160 domain) {
        return this.removedDomains.contains(domain);
    }

    boolean canProtectDomain(Number320 partKey, PublicKey publicKey) {
        if (this.getProtectionDomainEnable() == ProtectionEnable.ALL && !this.isDomainRemoved(partKey.getDomainKey())) {
            return true;
        }
        if (!this.isDomainRemoved(partKey.getDomainKey())) {
            return this.foreceOverrideDomain(partKey.getDomainKey(), publicKey);
        }
        return false;
    }

    boolean foreceOverrideDomain(Number160 domainKey, PublicKey publicKey) {
        if (this.getProtectionDomainMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return Storage.isMine(domainKey, publicKey);
        }
        return false;
    }

    boolean foreceOverrideEntry(Number160 entryKey, PublicKey publicKey) {
        if (this.getProtectionEntryMode() == ProtectionMode.MASTER_PUBLIC_KEY && publicKey != null) {
            return Storage.isMine(entryKey, publicKey);
        }
        return false;
    }

    boolean canUpdateEntry(Number480 key, Data oldData, Data newData, boolean protectEntry) {
        if (protectEntry) {
            return this.canProtectEntry(key, oldData, newData);
        }
        return true;
    }

    private boolean canProtectEntry(Number480 key, Data oldData, Data newData) {
        if (this.getProtectionEntryEnable() == ProtectionEnable.ALL) {
            if (oldData == null) {
                return true;
            }
            if (oldData.getPublicKey() == null) {
                return true;
            }
            if (oldData.getPublicKey().equals(newData.getPublicKey())) {
                return true;
            }
        }
        return this.foreceOverrideEntry(key.getContentKey(), newData.getPublicKey());
    }

    static boolean isMine(Number160 key, PublicKey publicKey) {
        return key.equals(Utils.makeSHAHash(publicKey.getEncoded()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Number160> compareAndPut(Number160 locationKey, Number160 domainKey, Map<Number160, HashData> hashDataMap, PublicKey publicKey, boolean partial, boolean protectDomain) {
        ArrayList<Number160> retVal = new ArrayList<Number160>();
        Lock lock = this.acquire(locationKey, domainKey);
        try {
            Number480 key;
            boolean perfectMatch = true;
            for (Map.Entry<Number160, HashData> entry : hashDataMap.entrySet()) {
                key = new Number480(locationKey, domainKey, entry.getKey());
                Data data = this.get(key);
                if (data == null) {
                    perfectMatch = false;
                    continue;
                }
                Number160 storedHash = data.getHash();
                if (!storedHash.equals(entry.getValue().getHash())) {
                    perfectMatch = false;
                    continue;
                }
                if (!partial) continue;
                this.put(key, entry.getValue().getData(), publicKey, false, protectDomain);
                retVal.add(key.getContentKey());
            }
            if (!partial && perfectMatch) {
                for (Map.Entry<Number160, HashData> entry : hashDataMap.entrySet()) {
                    key = new Number480(locationKey, domainKey, entry.getKey());
                    this.put(key, entry.getValue().getData(), publicKey, false, protectDomain);
                    retVal.add(key.getContentKey());
                }
            }
        }
        finally {
            this.release(lock);
        }
        return retVal;
    }

    private Lock acquire(Number160 locationKey, Number160 domainKey) {
        ReentrantLock lock = new ReentrantLock();
        lock.tryLock();
        return lock;
    }

    private void release(Lock lock) {
        lock.unlock();
    }

    public static enum ProtectionMode {
        NO_MASTER,
        MASTER_PUBLIC_KEY;

    }

    public static enum ProtectionEnable {
        ALL,
        NONE;

    }
}

