/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import java.io.IOException;
import java.io.Serializable;
import java.security.PublicKey;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;

public class Data
implements Serializable {
    private static final long serialVersionUID = -5023493840082652284L;
    private final byte[] data;
    private final int offset;
    private final int length;
    private final long validFromMillis;
    private int ttlSeconds;
    private Number160 hash;
    private boolean protectedEntry;
    private boolean directReplication;
    private PeerAddress originator;
    private PublicKey publicKey;

    public Data(Object object) throws IOException {
        this(object, null);
    }

    public Data(Object object, PeerAddress originator) throws IOException {
        this(Utils.encodeJavaObject(object), originator);
    }

    public Data(byte[] data) {
        this(data, (PeerAddress)null);
    }

    public Data(byte[] data, PeerAddress originator) {
        this(data, 0, data.length, originator);
    }

    public Data(byte[] data, int offset, int length, PeerAddress originator) {
        this.data = data;
        this.offset = offset;
        this.length = length;
        this.validFromMillis = Timings.currentTimeMillis();
        this.originator = originator;
    }

    public byte[] getData() {
        return this.data;
    }

    public Object getObject() throws ClassNotFoundException, IOException {
        return Utils.decodeJavaObject(this.data, this.offset, this.length);
    }

    public long getCreated() {
        return this.validFromMillis;
    }

    public int getTTLSeconds() {
        return this.ttlSeconds;
    }

    public void setTTLSeconds(int ttlSeconds) {
        this.ttlSeconds = ttlSeconds;
    }

    public Number160 getHash() {
        if (this.hash == null) {
            this.hash = Utils.makeSHAHash(this.data, this.offset, this.length);
        }
        return this.hash;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public long getExpirationMillis() {
        return this.ttlSeconds <= 0 ? Long.MAX_VALUE : this.validFromMillis + (long)this.ttlSeconds * 1000L;
    }

    public boolean isProtectedEntry() {
        return this.protectedEntry;
    }

    public void setProtectedEntry(boolean protectedEntry) {
        this.protectedEntry = protectedEntry;
    }

    public void setDirectReplication(boolean directReplication) {
        this.directReplication = directReplication;
    }

    public boolean isDirectReplication() {
        return this.directReplication;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data[l:");
        sb.append(this.length);
        sb.append(",tyn:");
        sb.append(this.getTTLSeconds());
        sb.append(",hasPK:");
        sb.append(this.publicKey != null);
        sb.append(",h:");
        sb.append(this.getHash());
        sb.append("]");
        return sb.toString();
    }

    public PeerAddress getPeerAddress() {
        return this.originator;
    }

    public void setPeerAddress(PeerAddress originator) {
        this.originator = originator;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

