/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.tomp2p.upnp.Action;
import net.tomp2p.upnp.Argument;
import net.tomp2p.upnp.Device;
import net.tomp2p.upnp.StateVariable;
import net.tomp2p.upnp.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Service {
    public final String serviceType;
    public final String serviceId;
    public final URL SCPDURL;
    public final URL controlURL;
    public final URL eventSubURL;
    public final String USN;
    public final Device serviceOwnerDevice;
    private int specVersionMajor;
    private int specVersionMinor;
    private String SCPDURLData;
    private Map<String, Action> UPNPServiceActions = new TreeMap<String, Action>();
    private Map<String, StateVariable> UPNPServiceStateVariables = new TreeMap<String, StateVariable>();
    private boolean parsedSCPD = false;

    public Service(Node serviceCtx, URL baseDeviceURL, Device serviceOwnerDevice) throws MalformedURLException, XPathExpressionException {
        this.serviceOwnerDevice = serviceOwnerDevice;
        this.serviceType = XMLUtil.xpath.evaluate("serviceType", serviceCtx);
        this.serviceId = XMLUtil.xpath.evaluate("serviceId", serviceCtx);
        this.SCPDURL = Device.getURL(XMLUtil.xpath.evaluate("SCPDURL", serviceCtx), baseDeviceURL);
        this.controlURL = Device.getURL(XMLUtil.xpath.evaluate("controlURL", serviceCtx), baseDeviceURL);
        this.eventSubURL = Device.getURL(XMLUtil.xpath.evaluate("eventSubURL", serviceCtx), baseDeviceURL);
        this.USN = serviceOwnerDevice.UDN.concat("::").concat(this.serviceType);
    }

    public int getSpecVersionMajor() {
        this.lazyInitiate();
        return this.specVersionMajor;
    }

    public int getSpecVersionMinor() {
        this.lazyInitiate();
        return this.specVersionMinor;
    }

    public Action getUPNPServiceAction(String actionName) {
        this.lazyInitiate();
        return this.UPNPServiceActions.get(actionName);
    }

    public StateVariable getUPNPServiceStateVariable(String stateVariableName) {
        this.lazyInitiate();
        return this.UPNPServiceStateVariables.get(stateVariableName);
    }

    public Iterator<String> getAvailableActionsName() {
        this.lazyInitiate();
        return this.UPNPServiceActions.keySet().iterator();
    }

    public int getAvailableActionsSize() {
        this.lazyInitiate();
        return this.UPNPServiceActions.keySet().size();
    }

    public Iterator<String> getAvailableStateVariableName() {
        this.lazyInitiate();
        return this.UPNPServiceStateVariables.keySet().iterator();
    }

    public int getAvailableStateVariableSize() {
        this.lazyInitiate();
        return this.UPNPServiceStateVariables.keySet().size();
    }

    private void parseSCPD() {
        try {
            Document doc = XMLUtil.getXML(this.SCPDURL);
            XPath xpath = XMLUtil.xpath;
            this.specVersionMajor = Integer.parseInt(xpath.evaluate("scpd/specVersion/major", doc));
            this.specVersionMinor = Integer.parseInt(xpath.evaluate("scpd/specVersion/major", doc));
            Node varList = (Node)xpath.evaluate("scpd/serviceStateTable", doc, XPathConstants.NODE);
            int varCount = Integer.parseInt(xpath.evaluate("count( stateVariable )", varList));
            this.UPNPServiceStateVariables = new HashMap<String, StateVariable>();
            for (int i = 1; i <= varCount; ++i) {
                Node stateVarXML = (Node)xpath.evaluate("stateVariable[ " + i + " ]", varList, XPathConstants.NODE);
                StateVariable var = new StateVariable(this, stateVarXML);
                this.UPNPServiceStateVariables.put(var.name, var);
            }
            Node actionList = (Node)xpath.evaluate("scpd/actionList", doc, XPathConstants.NODE);
            int actionCount = Integer.parseInt(xpath.evaluate("count( action )", actionList));
            this.UPNPServiceActions = new HashMap<String, Action>();
            for (int i = 1; i <= actionCount; ++i) {
                Node actionXML = (Node)xpath.evaluate("action[ " + i + " ]", actionList, XPathConstants.NODE);
                Action action = new Action(this, actionXML);
                for (Argument arg : action.arguments) {
                    arg.relatedStateVariable = this.UPNPServiceStateVariables.get(arg.relatedStateVariableName);
                }
                this.UPNPServiceActions.put(action.getName(), action);
            }
            this.parsedSCPD = true;
        }
        catch (Throwable t) {
            System.out.println(XMLUtil.getXMLString(this.SCPDURL));
            throw new RuntimeException("Error during lazy SCDP file parsing at " + this.SCPDURL, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lazyInitiate() {
        if (!this.parsedSCPD) {
            Service service = this;
            synchronized (service) {
                if (!this.parsedSCPD) {
                    this.parseSCPD();
                }
            }
        }
    }

    public String getSCDPData() {
        if (this.SCPDURLData == null) {
            try {
                InputStream in = this.SCPDURL.openConnection().getInputStream();
                int readen = 0;
                byte[] buff = new byte[512];
                StringBuilder strBuff = new StringBuilder();
                while ((readen = in.read(buff)) != -1) {
                    strBuff.append(new String(buff, 0, readen));
                }
                in.close();
                this.SCPDURLData = strBuff.toString();
            }
            catch (IOException ioEx) {
                return null;
            }
        }
        return this.SCPDURLData;
    }

    public String toString() {
        String s;
        this.lazyInitiate();
        StringBuilder b = new StringBuilder();
        b.append("type = ").append(this.serviceType);
        b.append("\nid = ").append(this.serviceId);
        b.append("\nurl = ").append(this.SCPDURL);
        b.append("\ncontrol = ").append(this.controlURL);
        b.append("\nevent = ").append(this.eventSubURL);
        b.append("\nActions:");
        for (Action action : this.UPNPServiceActions.values()) {
            s = "\n\t" + action.toString();
            s = s.replaceAll("\n", "\n\t");
            b.append(s);
        }
        b.append("\nVariables:");
        for (StateVariable v : this.UPNPServiceStateVariables.values()) {
            s = "\n\t" + v.toString();
            s = s.replaceAll("\n", "\n\t");
            b.append(s);
        }
        return b.toString();
    }
}

