/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import com.google.common.collect.MapMaker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.storage.Responsibility;

public class ResponsibilityMemory
implements Responsibility {
    private final ConcurrentMap<Number160, Number160> responsibilityMap = new MapMaker().makeMap();
    private final ConcurrentMap<Number160, Set<Number160>> responsibilityMapRev = new MapMaker().makeMap();

    @Override
    public Number160 findPeerIDForResponsibleContent(Number160 locationKey) {
        return (Number160)this.responsibilityMap.get(locationKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Number160> findContentForResponsiblePeerID(Number160 peerID) {
        Collection result = (Collection)this.responsibilityMapRev.get(peerID);
        if (result == null) {
            return Collections.emptyList();
        }
        Collection collection = result;
        synchronized (collection) {
            return new ArrayList<Number160>(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateResponsibilities(Number160 locationKey, Number160 peerId) {
        Set tmp2;
        HashSet<Number160> tmp1;
        Set<Number160> set;
        boolean isNew = true;
        Number160 old = this.responsibilityMap.put(locationKey, peerId);
        if (old != null) {
            isNew = !old.equals(peerId);
            Set tmp = (Set)this.responsibilityMapRev.get(old);
            if (tmp != null) {
                boolean remove = false;
                set = tmp;
                synchronized (set) {
                    tmp.remove(locationKey);
                    if (tmp.isEmpty()) {
                        remove = true;
                    }
                }
                if (remove) {
                    this.responsibilityMapRev.remove(old);
                }
            }
        }
        set = tmp1 = (tmp2 = (Set)this.responsibilityMapRev.putIfAbsent(peerId, tmp1 = new HashSet<Number160>())) == null ? tmp1 : tmp2;
        synchronized (set) {
            tmp1.add(locationKey);
        }
        return isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResponsibility(Number160 locationKey) {
        Set tmp2;
        Number160 tmp = (Number160)this.responsibilityMap.remove(locationKey);
        if (tmp != null && (tmp2 = (Set)this.responsibilityMapRev.get(tmp)) != null) {
            boolean remove = false;
            Set set = tmp2;
            synchronized (set) {
                tmp2.remove(locationKey);
                if (tmp2.isEmpty()) {
                    remove = true;
                }
            }
            if (remove) {
                this.responsibilityMapRev.remove(tmp);
            }
        }
    }
}

