/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.storage;

import com.google.common.collect.MapMaker;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import net.tomp2p.p2p.IdentityManagement;
import net.tomp2p.p2p.Maintenance;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.replication.Replication;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.storage.Digest;
import net.tomp2p.storage.TrackerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorage
implements PeerStatusListener,
Digest {
    private static final Logger logger = LoggerFactory.getLogger(TrackerStorage.class);
    private static final Map<Number160, TrackerData> EMPTY_MAP = new HashMap<Number160, TrackerData>();
    private static final DigestInfo EMPTY_DIGEST_INFO = new DigestInfo(Number160.ZERO, 0);
    public static final int TRACKER_SIZE = 35;
    private final ConcurrentMap<Number320, Map<Number160, TrackerData>> trackerDataActive;
    private final ConcurrentMap<Number320, Map<Number160, TrackerData>> trackerDataMesh;
    private final ConcurrentMap<Number320, Map<Number160, TrackerData>> trackerDataSecondary;
    private final ConcurrentMap<Number160, Collection<Number320>> reverseTrackerDataMesh;
    private final ConcurrentMap<Number160, Collection<Number320>> reverseTrackerDataSecondary;
    private final ConcurrentMap<Number160, Collection<Number160>> peerOffline;
    private final IdentityManagement identityManagement;
    private final int trackerTimoutSeconds;
    private final Replication replication;
    private final Maintenance maintenance;
    private boolean fillPrimaryStorageFast = false;
    private int secondaryFactor = 5;
    private int primanyFactor = 1;

    public TrackerStorage(IdentityManagement identityManagement, int trackerTimoutSeconds, Replication replication, Maintenance maintenance) {
        this.trackerTimoutSeconds = trackerTimoutSeconds;
        this.identityManagement = identityManagement;
        this.replication = replication;
        this.maintenance = maintenance;
        this.trackerDataActive = new MapMaker().makeMap();
        this.trackerDataMesh = new MapMaker().expireAfterAccess((long)trackerTimoutSeconds, TimeUnit.SECONDS).makeMap();
        this.trackerDataSecondary = new MapMaker().expireAfterAccess((long)trackerTimoutSeconds, TimeUnit.SECONDS).makeMap();
        this.reverseTrackerDataMesh = new MapMaker().expireAfterAccess((long)trackerTimoutSeconds, TimeUnit.SECONDS).makeMap();
        this.reverseTrackerDataSecondary = new MapMaker().expireAfterAccess((long)trackerTimoutSeconds, TimeUnit.SECONDS).makeMap();
        this.peerOffline = new MapMaker().expireAfterAccess((long)(trackerTimoutSeconds * 5), TimeUnit.SECONDS).makeMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number160, TrackerData> activePeers(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        Map data = (Map)this.trackerDataActive.get(keys);
        if (data == null) {
            return EMPTY_MAP;
        }
        Map map = data;
        synchronized (map) {
            return new HashMap<Number160, TrackerData>(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number160, TrackerData> meshPeers(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        Map data = (Map)this.trackerDataMesh.get(keys);
        if (data == null) {
            return EMPTY_MAP;
        }
        Map map = data;
        synchronized (map) {
            return new HashMap<Number160, TrackerData>(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Number160, TrackerData> secondaryPeers(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        Map data = (Map)this.trackerDataSecondary.get(keys);
        if (data == null) {
            return EMPTY_MAP;
        }
        Map map = data;
        synchronized (map) {
            return new HashMap<Number160, TrackerData>(data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActive(Number160 locationKey, Number160 domainKey, PeerAddress remotePeer, byte[] attachement, int offset, int length) {
        Number320 key = new Number320(locationKey, domainKey);
        HashMap<Number160, TrackerData> data = new HashMap<Number160, TrackerData>();
        Map data2 = this.trackerDataActive.putIfAbsent(key, data);
        HashMap<Number160, TrackerData> hashMap = data = data2 == null ? data : data2;
        synchronized (hashMap) {
            data.put(remotePeer.getID(), new TrackerData(remotePeer, this.identityManagement.getPeerAddress(), attachement, offset, length));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeActive(Number160 locationKey, Number160 domainKey, Number160 remotePeerId) {
        TrackerData retVal;
        Number320 key = new Number320(locationKey, domainKey);
        Map data = (Map)this.trackerDataActive.get(key);
        if (data == null) {
            return false;
        }
        Map map = data;
        synchronized (map) {
            retVal = (TrackerData)data.remove(remotePeerId);
            if (data.size() == 0) {
                this.trackerDataActive.remove(key);
            }
        }
        return retVal != null;
    }

    public boolean put(Number160 locationKey, Number160 domainKey, PeerAddress peerAddress, PublicKey publicKey, byte[] attachement) {
        if (attachement == null) {
            return this.put(locationKey, domainKey, peerAddress, publicKey, null, 0, 0);
        }
        return this.put(locationKey, domainKey, peerAddress, publicKey, attachement, 0, attachement.length);
    }

    public boolean put(Number160 locationKey, Number160 domainKey, PeerAddress peerAddress, PublicKey publicKey, byte[] attachement, int offset, int length) {
        Number320 key;
        if (logger.isDebugEnabled()) {
            logger.debug("try to store on tracker " + locationKey);
        }
        Number160 peerId = peerAddress.getID();
        if (this.isOffline(peerAddress)) {
            return false;
        }
        if (!this.identityManagement.checkIdentity(peerId, publicKey)) {
            return false;
        }
        if (this.canStorePrimary(locationKey, domainKey, false) && this.storeData(peerAddress, attachement, offset, length, peerId, key = new Number320(locationKey, domainKey), this.trackerDataMesh, this.reverseTrackerDataMesh, this.getPrimanyFactor())) {
            this.replication.checkResponsibility(locationKey);
            return true;
        }
        return false;
    }

    private boolean isOffline(PeerAddress peerAddress) {
        return this.peerOffline.containsKey(peerAddress.getID());
    }

    public boolean putReferred(Number160 locationKey, Number160 domainKey, PeerAddress peerAddress, PeerAddress referrer, byte[] attachement, int offset, int length, ReferrerType type) {
        Number320 key;
        Number160 peerId = peerAddress.getID();
        if (this.canStoreSecondary(locationKey, domainKey) && this.storeData(peerAddress, attachement, offset, length, peerId, key = new Number320(locationKey, domainKey), this.trackerDataSecondary, this.reverseTrackerDataSecondary, this.getSecondaryFactor())) {
            if (ReferrerType.MESH == type && !this.isSecondaryTracker(locationKey, domainKey)) {
                this.maintenance.addTrackerMaintenance(peerAddress, referrer, locationKey, domainKey, this);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean moveFromSecondaryToMesh(PeerAddress peerAddress, PeerAddress referrer, Number160 locationKey, Number160 domainKey, PublicKey publicKey) {
        Number320 key = new Number320(locationKey, domainKey);
        Map map = (Map)this.trackerDataSecondary.get(key);
        if (map == null) {
            return false;
        }
        Map map2 = map;
        synchronized (map2) {
            TrackerData data = (TrackerData)map.remove(peerAddress.getID());
            if (data != null && !this.put(locationKey, domainKey, data.getPeerAddress(), publicKey, data.getAttachement(), data.getOffset(), data.getLength())) {
                map.put(peerAddress.getID(), data);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeData(PeerAddress peerAddress, byte[] attachement, int offset, int length, Number160 peerId, Number320 key, ConcurrentMap<Number320, Map<Number160, TrackerData>> trackerData, ConcurrentMap<Number160, Collection<Number320>> reverseTrackerData, int factor) {
        HashMap<Number160, TrackerData> data = new HashMap<Number160, TrackerData>();
        Map data2 = trackerData.putIfAbsent(key, data);
        HashMap<Number160, TrackerData> hashMap = data = data2 == null ? data : data2;
        synchronized (hashMap) {
            if (data.size() > 35 * factor) {
                return false;
            }
            data.put(peerId, new TrackerData(peerAddress, null, attachement, offset, length));
        }
        HashSet<Number320> collection = new HashSet<Number320>();
        Collection collection2 = reverseTrackerData.putIfAbsent(peerId, collection);
        HashSet<Number320> hashSet = collection = collection2 == null ? collection : collection2;
        synchronized (hashSet) {
            collection.add(key);
        }
        return true;
    }

    private boolean canStorePrimary(Number160 locationKey, Number160 domainKey, boolean referred) {
        if (!referred || this.isFillPrimaryStorageFast()) {
            return this.sizePrimary(locationKey, domainKey) <= 35 * this.getPrimanyFactor();
        }
        return false;
    }

    private boolean canStoreSecondary(Number160 locationKey, Number160 domainKey) {
        return this.sizeSecondary(locationKey, domainKey) <= 35 * this.getSecondaryFactor();
    }

    public int sizePrimary(Number160 locationKey, Number160 domainKey) {
        return this.size(locationKey, domainKey, this.trackerDataMesh);
    }

    public int sizeSecondary(Number160 locationKey, Number160 domainKey) {
        return this.size(locationKey, domainKey, this.trackerDataSecondary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int size(Number160 locationKey, Number160 domainKey, ConcurrentMap<Number320, Map<Number160, TrackerData>> trackerData) {
        Number320 key = new Number320(locationKey, domainKey);
        Map data = (Map)trackerData.get(key);
        if (data == null) {
            return 0;
        }
        Map map = data;
        synchronized (map) {
            return data.size();
        }
    }

    public void setSecondaryFactor(int secondaryFactor) {
        this.secondaryFactor = secondaryFactor;
    }

    public int getSecondaryFactor() {
        return this.secondaryFactor;
    }

    public void setPrimanyFactor(int primanyFactor) {
        this.primanyFactor = primanyFactor;
    }

    public int getPrimanyFactor() {
        return this.primanyFactor;
    }

    @Override
    public void peerOffline(PeerAddress peerAddress, PeerStatusListener.Reason reason) {
        if (reason == PeerStatusListener.Reason.NOT_REACHABLE) {
            this.peerOffline(peerAddress.getID(), this.identityManagement.getSelf());
        }
    }

    private void peerOffline(Number160 peerId, Number160 referrerId) {
        this.indicateOffline(peerId, referrerId);
        this.remove(peerId, this.trackerDataMesh, this.reverseTrackerDataMesh);
        this.remove(peerId, this.trackerDataSecondary, this.reverseTrackerDataSecondary);
    }

    private void indicateOffline(Number160 peerId, Number160 referrerId) {
        HashSet<Number160> collection = new HashSet<Number160>();
        Collection collection2 = this.peerOffline.putIfAbsent(peerId, collection);
        collection = collection2 == null ? collection : collection2;
        collection.add(referrerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean remove(Number160 peerId, ConcurrentMap<Number320, Map<Number160, TrackerData>> trackerData, ConcurrentMap<Number160, Collection<Number320>> reverseTrackerData) {
        boolean retVal = false;
        Collection collection = (Collection)reverseTrackerData.remove(peerId);
        if (collection == null) {
            return false;
        }
        Collection collection2 = collection;
        synchronized (collection2) {
            for (Number320 key : collection) {
                Map data = (Map)trackerData.get(key);
                if (data == null) continue;
                Map map = data;
                synchronized (map) {
                    if (data.remove(peerId) != null) {
                        retVal = true;
                    }
                    if (data.size() == 0) {
                        trackerData.remove(key);
                    }
                }
            }
        }
        return retVal;
    }

    @Override
    public void peerFail(PeerAddress peerAddress, boolean force) {
    }

    @Override
    public void peerOnline(PeerAddress peerAddress) {
        this.peerOffline.remove(peerAddress.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigestInfo digest(Number320 key) {
        Map data = (Map)this.trackerDataMesh.get(key);
        if (data == null) {
            return EMPTY_DIGEST_INFO;
        }
        Map map = data;
        synchronized (map) {
            DigestInfo digestInfo = new DigestInfo();
            for (Number160 tmpKey : data.keySet()) {
                digestInfo.getKeyDigests().add(tmpKey);
            }
            return digestInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DigestInfo digest(Number320 key, Collection<Number160> contentKeys) {
        if (contentKeys == null) {
            return this.digest(key);
        }
        Map data = (Map)this.trackerDataMesh.get(key);
        if (data == null) {
            return EMPTY_DIGEST_INFO;
        }
        Map map = data;
        synchronized (map) {
            DigestInfo digestInfo = new DigestInfo();
            for (Number160 tmpKey : contentKeys) {
                if (!data.containsKey(tmpKey)) continue;
                digestInfo.getKeyDigests().add(tmpKey);
            }
            return digestInfo;
        }
    }

    public void removeReferred(Number160 locationKey, Number160 domainKey, Number160 key, PeerAddress referrer) {
        this.indicateOffline(key, referrer.getID());
    }

    public void setFillPrimaryStorageFast(boolean fillPrimaryStorageFast) {
        this.fillPrimaryStorageFast = fillPrimaryStorageFast;
    }

    public boolean isFillPrimaryStorageFast() {
        return this.fillPrimaryStorageFast;
    }

    public int getTrackerTimoutSeconds() {
        return this.trackerTimoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSecondaryTracker(Number160 locationKey, Number160 domainKey) {
        Number320 keys = new Number320(locationKey, domainKey);
        Map data = (Map)this.trackerDataMesh.get(keys);
        if (data == null) {
            return false;
        }
        Map map = data;
        synchronized (map) {
            return data.containsKey(this.identityManagement.getSelf());
        }
    }

    public Collection<Number160> responsibleDomains(Number160 locationKey) {
        ArrayList<Number160> retVal = new ArrayList<Number160>();
        for (Number320 number320 : this.trackerDataMesh.keySet()) {
            if (!number320.getLocationKey().equals(locationKey)) continue;
            retVal.add(number320.getDomainKey());
        }
        return retVal;
    }

    public static enum ReferrerType {
        ACTIVE,
        MESH;

    }
}

