/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.storage.TrackerData;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(TrackerRPC.class);
    public static final int MAX_MSG_SIZE_UDP = 35;

    public TrackerRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.TRACKER_ADD, Message.Command.TRACKER_GET);
    }

    public PeerAddress getPeerAddress() {
        return this.peerBean.getServerPeerAddress();
    }

    public FutureResponse addToTracker(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, byte[] attachement, boolean signMessage, boolean primary, Set<Number160> knownPeers, ChannelCreator channelCreator) {
        if (attachement == null) {
            return this.addToTracker(remotePeer, locationKey, domainKey, null, 0, 0, signMessage, primary, knownPeers, channelCreator);
        }
        return this.addToTracker(remotePeer, locationKey, domainKey, attachement, 0, attachement.length, signMessage, primary, knownPeers, channelCreator);
    }

    public static boolean isPrimary(FutureResponse response) {
        return response.getRequest().getType() == Message.Type.REQUEST_3;
    }

    public static boolean isSecondary(FutureResponse response) {
        return response.getRequest().getType() == Message.Type.REQUEST_1;
    }

    public FutureResponse addToTracker(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, byte[] attachement, int offset, int legth, boolean signMessage, boolean primary, Set<Number160> knownPeers, ChannelCreator channelCreator) {
        this.nullCheck(remotePeer, locationKey, domainKey);
        Message message = this.createMessage(remotePeer, Message.Command.TRACKER_ADD, primary ? Message.Type.REQUEST_3 : Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (knownPeers != null && knownPeers instanceof SimpleBloomFilter) {
            message.setPayload(ChannelBuffers.wrappedBuffer((byte[])((SimpleBloomFilter)knownPeers).toByteArray()));
        } else {
            message.setPayload(ChannelBuffers.EMPTY_BUFFER);
        }
        if (attachement != null) {
            FutureResponse futureResponse = new FutureResponse(message);
            TrackerRequestTCP requestHandler = new TrackerRequestTCP(this, futureResponse, this.peerBean, this.connectionBean, message, locationKey, domainKey);
            message.setPayload(ChannelBuffers.wrappedBuffer((byte[])attachement, (int)offset, (int)legth));
            return requestHandler.sendTCP(channelCreator);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        TrackerRequestUDP requestHandler = new TrackerRequestUDP(futureResponse, this.peerBean, this.connectionBean, message, locationKey, domainKey);
        return requestHandler.sendUDP(channelCreator);
    }

    public FutureResponse getFromTracker(PeerAddress remotePeer, Number160 locationKey, Number160 domainKey, boolean expectAttachement, boolean signMessage, Set<Number160> knownPeers, ChannelCreator channelCreator) {
        this.nullCheck(remotePeer, locationKey, domainKey);
        Message message = this.createMessage(remotePeer, Message.Command.TRACKER_GET, Message.Type.REQUEST_1);
        if (signMessage) {
            message.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        message.setKeyKey(locationKey, domainKey);
        if (knownPeers != null && knownPeers instanceof SimpleBloomFilter) {
            message.setPayload(ChannelBuffers.wrappedBuffer((byte[])((SimpleBloomFilter)knownPeers).toByteArray()));
        } else {
            message.setPayload(ChannelBuffers.EMPTY_BUFFER);
        }
        if (expectAttachement) {
            FutureResponse futureResponse = new FutureResponse(message);
            TrackerRequestTCP requestHandler = new TrackerRequestTCP(this, futureResponse, this.peerBean, this.connectionBean, message, locationKey, domainKey);
            return requestHandler.sendTCP(channelCreator);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        TrackerRequestUDP requestHandler = new TrackerRequestUDP(futureResponse, this.peerBean, this.connectionBean, message, locationKey, domainKey);
        return requestHandler.sendUDP(channelCreator);
    }

    @Override
    public boolean checkMessage(Message message) {
        return (message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_3) && message.getKeyKey1() != null && message.getKeyKey2() != null;
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        int size;
        boolean couldProvideMoreData;
        Message responseMessage = this.createMessage(message.getSender(), message.getCommand(), Message.Type.OK);
        if (sign) {
            responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
        }
        responseMessage.setMessageId(message.getMessageId());
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        SimpleBloomFilter knownPeers = null;
        if (message.getPayload1() == null) {
            throw new RuntimeException("BF data may be empty but it has to be there.");
        }
        ChannelBuffer buffer = message.getPayload1();
        int length = buffer.writerIndex();
        if (length > 0) {
            knownPeers = new SimpleBloomFilter(buffer.array(), buffer.arrayOffset(), length);
        }
        byte[] attachement = null;
        if (message.getPayload2() != null) {
            buffer = message.getPayload2();
            attachement = new byte[buffer.readableBytes()];
            buffer.readBytes(attachement);
        }
        PublicKey publicKey = message.getPublicKey();
        TrackerStorage trackerStorage = this.peerBean.getTrackerStorage();
        Map<Number160, TrackerData> meshPeers = trackerStorage.meshPeers(locationKey, domainKey);
        if (knownPeers != null) {
            meshPeers = Utils.disjunction(meshPeers, knownPeers);
        }
        boolean bl = couldProvideMoreData = (size = meshPeers.size()) > (meshPeers = Utils.limit(meshPeers, 35)).size();
        if (couldProvideMoreData) {
            responseMessage.setType(Message.Type.PARTIALLY_OK);
        }
        responseMessage.setTrackerData(meshPeers.values());
        PeerAddress senderAddress = message.getSender();
        if (message.getCommand() == Message.Command.TRACKER_ADD) {
            if (!trackerStorage.put(locationKey, domainKey, senderAddress, publicKey, attachement)) {
                responseMessage.setType(Message.Type.DENIED);
                if (logger.isDebugEnabled()) {
                    logger.debug("tracker NOT put on(" + this.peerBean.getServerPeerAddress() + ") locationKey:" + locationKey + ", domainKey:" + domainKey + ", address:" + senderAddress);
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug("tracker put on(" + this.peerBean.getServerPeerAddress() + ") locationKey:" + locationKey + ", domainKey:" + domainKey + ", address:" + senderAddress + "sizeP: " + trackerStorage.sizePrimary(locationKey, domainKey));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("tracker get on(" + this.peerBean.getServerPeerAddress() + ") locationKey:" + locationKey + ", domainKey:" + domainKey + ", address:" + senderAddress + " returning: " + (meshPeers == null ? "0" : Integer.valueOf(meshPeers.size())));
        }
        return responseMessage;
    }

    private void preHandleMessage(Message message, TrackerStorage trackerStorage, PeerAddress referrer, Number160 locationKey, Number160 domainKey) throws IOException, ClassNotFoundException {
        Collection<TrackerData> tmp = message.getTrackerData();
        if (tmp == null || tmp.size() == 0) {
            return;
        }
        for (TrackerData data : tmp) {
            trackerStorage.putReferred(locationKey, domainKey, data.getPeerAddress(), referrer, data.getAttachement(), data.getOffset(), data.getLength(), TrackerStorage.ReferrerType.MESH);
        }
    }

    private class TrackerRequestUDP
    extends RequestHandlerUDP {
        private final Message message;
        private final Number160 locationKey;
        private final Number160 domainKey;

        public TrackerRequestUDP(FutureResponse futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message, Number160 locationKey, Number160 domainKey) {
            super(futureResponse, peerBean, connectionBean, message);
            this.message = message;
            this.locationKey = locationKey;
            this.domainKey = domainKey;
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
            Object object = e.getMessage();
            if (object instanceof Message) {
                TrackerRPC.this.preHandleMessage((Message)object, TrackerRPC.this.peerBean.getTrackerStorage(), this.message.getRecipient(), this.locationKey, this.domainKey);
            } else {
                logger.error("Response received, but not a message: " + object);
            }
            super.messageReceived(ctx, e);
        }
    }

    private static class TrackerRequestTCP<K extends FutureResponse>
    extends RequestHandlerTCP<K> {
        private final Message message;
        private final Number160 locationKey;
        private final Number160 domainKey;
        final /* synthetic */ TrackerRPC this$0;

        public TrackerRequestTCP(K futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message, Number160 locationKey, Number160 domainKey) {
            this.this$0 = var1_1;
            super(futureResponse, peerBean, connectionBean, message);
            this.message = message;
            this.locationKey = locationKey;
            this.domainKey = domainKey;
        }

        public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent ce) throws Exception {
            this.this$0.preHandleMessage(this.message, this.this$0.peerBean.getTrackerStorage(), this.message.getRecipient(), this.locationKey, this.domainKey);
            super.handleUpstream(ctx, ce);
        }
    }
}

