/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.Map;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.replication.ResponsibilityListener;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorageReplication
implements ResponsibilityListener {
    private static final Logger logger = LoggerFactory.getLogger(TrackerStorageReplication.class);
    private final PeerExchangeRPC peerExchangeRPC;
    private final Map<BaseFuture, Long> pendingFutures;
    private final TrackerStorage trackerStorage;
    private final Peer peer;

    public TrackerStorageReplication(Peer peer, PeerExchangeRPC peerExchangeRPC, Map<BaseFuture, Long> pendingFutures, TrackerStorage trackerStorage) {
        this.peer = peer;
        this.peerExchangeRPC = peerExchangeRPC;
        this.pendingFutures = pendingFutures;
        this.trackerStorage = trackerStorage;
    }

    @Override
    public void meResponsible(Number160 locationKey) {
    }

    @Override
    public void otherResponsible(final Number160 locationKey, final PeerAddress other) {
        if (logger.isDebugEnabled()) {
            logger.debug("other peer became responsibel and we thought we were responsible, so move the data to this peer");
        }
        for (final Number160 domainKey : this.trackerStorage.responsibleDomains(locationKey)) {
            this.peer.getConnectionBean().getConnectionReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        FutureResponse futureResponse = TrackerStorageReplication.this.peerExchangeRPC.peerExchange(other, locationKey, domainKey, true, future.getChannelCreator());
                        Utils.addReleaseListener(futureResponse, TrackerStorageReplication.this.peer.getConnectionBean().getConnectionReservation(), future.getChannelCreator(), 1);
                        TrackerStorageReplication.this.pendingFutures.put(futureResponse, Timings.currentTimeMillis());
                    } else if (logger.isErrorEnabled()) {
                        logger.error("otherResponsible failed " + future.getFailedReason());
                    }
                }
            });
        }
    }
}

