/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.SocketAddress;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfigurationBean;
import net.tomp2p.connection.ReplyTimeoutHandler;
import net.tomp2p.connection.Sender;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderNetty
implements Sender {
    private static final Logger logger = LoggerFactory.getLogger(SenderNetty.class);
    private final Timer timer;
    private final ConnectionConfigurationBean configuration;
    private volatile boolean shutdown = false;

    public SenderNetty(ConnectionConfigurationBean configuration, Timer timer) {
        this.configuration = configuration;
        this.timer = timer;
    }

    @Override
    public void sendTCP(RequestHandlerTCP<? extends BaseFuture> handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator, int idleTCPMillis) {
        if (logger.isDebugEnabled()) {
            logger.debug("send TCP " + Thread.currentThread().getName());
        }
        if (this.shutdown) {
            futureResponse.setFailed("shutdown in progres");
            return;
        }
        this.sendTCP0(message.getRecipient(), handler, futureResponse, message, channelCreator, idleTCPMillis);
    }

    @Override
    public void sendUDP(RequestHandlerUDP handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator) {
        if (logger.isDebugEnabled()) {
            logger.debug("send UDP " + Thread.currentThread().getName());
        }
        if (this.shutdown) {
            futureResponse.setFailed("shutdown in progres");
            return;
        }
        this.sendUDP0(message.getRecipient(), handler, futureResponse, message, false, channelCreator);
    }

    @Override
    public void sendBroadcastUDP(RequestHandlerUDP handler, FutureResponse futureResponse, Message message, ChannelCreator channelCreator) {
        if (logger.isDebugEnabled()) {
            logger.debug("send UDP " + Thread.currentThread().getName());
        }
        if (this.shutdown) {
            futureResponse.setFailed("shutdown in progres");
            return;
        }
        this.sendUDP0(message.getRecipient(), handler, futureResponse, message, true, channelCreator);
    }

    private void sendTCP0(PeerAddress remotePeer, final RequestHandlerTCP<? extends BaseFuture> requestHandler, final FutureResponse futureResponse, final Message message, ChannelCreator channelCreator, int idleTCPMillis) {
        if (futureResponse.isCompleted()) {
            return;
        }
        try {
            ReplyTimeoutHandler replyTimeoutHandler = null;
            if (requestHandler != null) {
                replyTimeoutHandler = new ReplyTimeoutHandler(this.timer, idleTCPMillis, remotePeer);
                futureResponse.setReplyTimeoutHandler(replyTimeoutHandler);
            } else if (message.getType() != Message.Type.REQUEST_FF_1) {
                throw new RuntimeException("This send needs to be a fire and forget request");
            }
            final ChannelFuture channelFutureConnect = channelCreator.createTCPChannel(replyTimeoutHandler, requestHandler, futureResponse, this.configuration.getConnectTimeoutMillis(), message.getRecipient().createSocketTCP());
            if (channelFutureConnect == null) {
                futureResponse.setFailed("shutdown in progres");
                return;
            }
            final Cancellable cancel = new Cancellable(){

                @Override
                public void cancel() {
                    channelFutureConnect.cancel();
                }
            };
            futureResponse.addCancellation(cancel);
            channelFutureConnect.addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    futureResponse.removeCancellation(cancel);
                    if (future.isSuccess() && !channelFutureConnect.isCancelled()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("send TCP message " + message);
                        }
                        ChannelFuture writeFuture = future.getChannel().write((Object)message);
                        SenderNetty.this.afterSend(writeFuture, futureResponse, requestHandler == null);
                    } else {
                        future.getChannel().close();
                        if (channelFutureConnect.isCancelled()) {
                            futureResponse.cancel();
                        } else {
                            logger.warn("Failed to connect channel " + future.isCancelled() + "/" + future.getCause() + "msg:" + message);
                            futureResponse.setFailed("Connect failed " + future.getCause());
                            if (logger.isWarnEnabled() && future.getCause() != null) {
                                future.getCause().printStackTrace();
                            }
                        }
                    }
                }
            });
        }
        catch (Exception ce) {
            futureResponse.setFailed("Could not get channel " + ce.toString());
            if (logger.isWarnEnabled()) {
                logger.warn(ce.toString());
            }
            if (logger.isDebugEnabled()) {
                ce.printStackTrace();
            }
            return;
        }
    }

    private void sendUDP0(PeerAddress remotePeer, RequestHandlerUDP requestHandler, FutureResponse futureResponse, Message message, boolean broadcast, ChannelCreator channelCreator) {
        if (futureResponse.isCompleted()) {
            return;
        }
        ReplyTimeoutHandler replyTimeoutHandler = null;
        if (requestHandler != null) {
            replyTimeoutHandler = new ReplyTimeoutHandler(this.timer, this.configuration.getIdleUDPMillis(), remotePeer);
            futureResponse.setReplyTimeoutHandler(replyTimeoutHandler);
        } else if (message.getType() != Message.Type.REQUEST_FF_1 && message.getType() != Message.Type.REQUEST_FF_2) {
            throw new RuntimeException("This send needs to be a fire and forget request");
        }
        try {
            Channel channel = channelCreator.createUDPChannel(replyTimeoutHandler, requestHandler, futureResponse, broadcast);
            if (channel == null) {
                futureResponse.setFailed("shutdown in progres");
                return;
            }
            ChannelFuture writeFuture = channel.write((Object)message, (SocketAddress)remotePeer.createSocketUDP());
            this.afterSend(writeFuture, futureResponse, requestHandler == null);
        }
        catch (Exception ce) {
            futureResponse.setFailed("Could not get channel " + ce.toString());
            logger.warn(ce.toString());
            if (logger.isDebugEnabled()) {
                ce.printStackTrace();
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("send UDP message " + message);
        }
    }

    private void afterSend(final ChannelFuture writeFuture, final FutureResponse futureResponse, final boolean isFireAndForget) {
        final Cancellable cancel = new Cancellable(){

            @Override
            public void cancel() {
                writeFuture.cancel();
            }
        };
        futureResponse.addCancellation(cancel);
        writeFuture.addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture writeFuture) {
                futureResponse.removeCancellation(cancel);
                if (!writeFuture.isSuccess()) {
                    writeFuture.getChannel().close();
                    if (writeFuture.isCancelled()) {
                        futureResponse.cancel();
                    } else {
                        futureResponse.setFailed("Write failed");
                        logger.warn("Failed to write channel the request " + futureResponse.getRequest());
                        if (logger.isWarnEnabled() && writeFuture.getCause() != null) {
                            writeFuture.getCause().printStackTrace();
                        }
                    }
                }
                if (isFireAndForget) {
                    futureResponse.setResponse(null);
                    writeFuture.getChannel().close();
                }
            }
        });
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }
}

