/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionReservation;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerStatusListener;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.utils.Timings;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private static final int NR_THREADS = Runtime.getRuntime().availableProcessors() + 1;
    private static final int WARNING_THRESHOLD = 10000;
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private final ExecutorService executor = new ThreadPoolExecutor(NR_THREADS, NR_THREADS, 0L, TimeUnit.MILLISECONDS, this.queue, new MyThreadFactory());
    private volatile Maintenance maintenance;

    public void addQueue(FutureRunnable futureRunnable) {
        if (logger.isDebugEnabled()) {
            logger.debug("we are called from a TCP netty thread, so send this in an other thread " + Thread.currentThread().getName() + ". The queue size is: " + this.queue.size());
        }
        if (this.queue.size() > 10000 && logger.isInfoEnabled()) {
            logger.info("slow down, we have a huge backlog!");
        }
        if (this.executor.isShutdown()) {
            futureRunnable.failed("shutting down");
            return;
        }
        this.executor.execute(futureRunnable);
    }

    public void shutdown() {
        List<Runnable> runners = this.executor.shutdownNow();
        for (Runnable runner : runners) {
            FutureRunnable futureRunnable = (FutureRunnable)runner;
            futureRunnable.failed("Shutting down...");
        }
        if (this.maintenance != null) {
            this.maintenance.shutdown();
        }
    }

    public void startMaintainance(final PeerMap peerMap, HandshakeRPC handshakeRPC, ConnectionReservation connectionReservation, int max) {
        if (this.maintenance == null) {
            this.maintenance = new Maintenance(peerMap, handshakeRPC, connectionReservation, max);
            this.maintenance.start();
        } else {
            this.maintenance.add(peerMap);
            this.maintenance.getMasterPeerMap().addPeerOfflineListener(new PeerStatusListener(){

                @Override
                public void peerOnline(PeerAddress peerAddress) {
                    if (peerMap.contains(peerAddress)) {
                        peerMap.peerFound(peerAddress, null);
                    }
                }

                @Override
                public void peerOffline(PeerAddress peerAddress, PeerStatusListener.Reason reason) {
                }

                @Override
                public void peerFail(PeerAddress peerAddress, boolean force) {
                    peerMap.peerOffline(peerAddress, force);
                }
            });
        }
    }

    private class Maintenance
    extends Thread
    implements Runnable {
        private volatile boolean running = true;
        private final List<PeerMap> peerMaps = new ArrayList<PeerMap>();
        private final HandshakeRPC handshakeRPC;
        private final ConnectionReservation connectionReservation;
        private final PeerMap masterPeerMap;
        private final int max;

        public Maintenance(PeerMap peerMap, HandshakeRPC handshakeRPC, ConnectionReservation connectionReservation, int max) {
            this.handshakeRPC = handshakeRPC;
            this.connectionReservation = connectionReservation;
            this.max = max;
            this.masterPeerMap = peerMap;
            this.add(peerMap);
            this.setName("maintenance");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<PeerAddress> checkPeers = new ArrayList<PeerAddress>();
            while (this.running) {
                List<PeerMap> list = this.peerMaps;
                synchronized (list) {
                    if (checkPeers.size() == 0) {
                        for (PeerMap peerMap : this.peerMaps) {
                            checkPeers.addAll(peerMap.peersForMaintenance());
                        }
                    }
                }
                int max2 = Math.min(this.max, checkPeers.size());
                final FutureLateJoin lateJoin = new FutureLateJoin(max2);
                Iterator iterator = checkPeers.iterator();
                for (int i = 0; i < max2; ++i) {
                    final PeerAddress peerAddress = (PeerAddress)iterator.next();
                    FutureChannelCreator fcc = this.connectionReservation.reserve(1);
                    fcc.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                        @Override
                        public void operationComplete(FutureChannelCreator future) throws Exception {
                            if (future.isSuccess()) {
                                ChannelCreator cc = future.getChannelCreator();
                                FutureResponse futureResponse = Maintenance.this.handshakeRPC.pingUDP(peerAddress, cc);
                                Utils.addReleaseListener(futureResponse, Maintenance.this.connectionReservation, cc, 1);
                                lateJoin.add(futureResponse);
                            }
                        }
                    });
                    iterator.remove();
                }
                try {
                    lateJoin.await();
                    Timings.sleep(1000);
                }
                catch (InterruptedException e) {
                    lateJoin.setFailed("interrupted");
                }
            }
        }

        public void shutdown() {
            this.running = false;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(PeerMap peerMap) {
            List<PeerMap> list = this.peerMaps;
            synchronized (list) {
                this.peerMaps.add(peerMap);
            }
        }

        public PeerMap getMasterPeerMap() {
            return this.masterPeerMap;
        }
    }

    private class MyThreadFactory
    implements ThreadFactory {
        private int nr = 0;

        private MyThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "scheduler-" + this.nr);
            ++this.nr;
            return t;
        }
    }
}

