/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.upnp.DiscoveryListener;
import net.tomp2p.upnp.DiscoveryResultsHandler;
import net.tomp2p.upnp.RootDevice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Discovery {
    private static final Logger logger = LoggerFactory.getLogger(Discovery.class);
    public static final String ROOT_DEVICES = "upnp:rootdevice";
    public static final String ALL_DEVICES = "ssdp:all";
    public static final int DEFAULT_MX = 3;
    public static final int DEFAULT_TTL = 4;
    public static final int DEFAULT_TIMEOUT = 1500;
    public static final String DEFAULT_SEARCH = "ssdp:all";
    public static final int DEFAULT_SSDP_SEARCH_PORT = 1901;
    public static final String SSDP_IP = "239.255.255.250";
    public static final int SSDP_PORT = 1900;

    public static Collection<RootDevice> discover() throws IOException {
        return Discovery.discover(1500, 4, 3, "ssdp:all");
    }

    public static Collection<RootDevice> discover(String searchTarget) throws IOException {
        return Discovery.discover(1500, 4, 3, searchTarget);
    }

    public static Collection<RootDevice> discover(int timeOut, String searchTarget) throws IOException {
        return Discovery.discover(timeOut, 4, 3, searchTarget);
    }

    public static Collection<RootDevice> discover(int timeOut, int ttl, int mx, String searchTarget) throws IOException {
        return Discovery.discoverDevices(timeOut, ttl, mx, searchTarget, null);
    }

    public static Collection<RootDevice> discover(int timeOut, int ttl, int mx, String searchTarget, NetworkInterface ni) throws IOException {
        return Discovery.discoverDevices(timeOut, ttl, mx, searchTarget, ni);
    }

    private static Collection<RootDevice> discoverDevices(int timeOut, int ttl, int mx, String searchTarget, NetworkInterface ni) throws IOException {
        if (searchTarget == null || searchTarget.trim().length() == 0) {
            throw new IllegalArgumentException("Illegal searchTarget");
        }
        final HashMap devices = new HashMap();
        DiscoveryResultsHandler handler = new DiscoveryResultsHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void discoveredDevice(String usn, String udn, String nt, String maxAge, URL location, String firmware, InetAddress localIP) {
                Map map = devices;
                synchronized (map) {
                    if (!devices.containsKey(usn)) {
                        try {
                            RootDevice device = RootDevice.build(location, maxAge, firmware, usn, udn, localIP);
                            devices.put(usn, device);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                    }
                }
            }
        };
        DiscoveryListener.getInstance().registerResultsHandler(handler, searchTarget);
        if (ni == null) {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface intf = e.nextElement();
                Discovery.sendViaInterface(ttl, mx, searchTarget, intf);
            }
        } else {
            Discovery.sendViaInterface(ttl, mx, searchTarget, ni);
        }
        try {
            Thread.sleep(timeOut);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        DiscoveryListener.getInstance().unRegisterResultsHandler(handler, searchTarget);
        if (devices.size() == 0) {
            return null;
        }
        return devices.values();
    }

    private static void sendViaInterface(int ttl, int mx, String searchTarget, NetworkInterface intf) {
        Enumeration<InetAddress> adrs = intf.getInetAddresses();
        while (adrs.hasMoreElements()) {
            InetAddress adr = adrs.nextElement();
            if (!(adr instanceof Inet4Address) || adr.isLoopbackAddress()) continue;
            try {
                Discovery.sendSearchMessage(adr, ttl, mx, searchTarget);
            }
            catch (IOException ex) {
                logger.warn("error sending message" + ex);
            }
        }
    }

    public static void sendSearchMessage(InetAddress src, int ttl, int mx, String searchTarget) throws IOException {
        int bindPort = 1901;
        String port = System.getProperty("net.sbbi.upnp.Discovery.bindPort");
        if (port != null) {
            bindPort = Integer.parseInt(port);
        }
        InetSocketAddress adr = new InetSocketAddress(InetAddress.getByName(SSDP_IP), 1900);
        MulticastSocket skt = new MulticastSocket(null);
        skt.bind(new InetSocketAddress(src, bindPort));
        skt.setTimeToLive(ttl);
        StringBuilder packet = new StringBuilder();
        packet.append("M-SEARCH * HTTP/1.1\r\n");
        packet.append("HOST: 239.255.255.250:1900\r\n");
        packet.append("MAN: \"ssdp:discover\"\r\n");
        packet.append("MX: ").append(mx).append("\r\n");
        packet.append("ST: ").append(searchTarget).append("\r\n").append("\r\n");
        String toSend = packet.toString();
        byte[] pk = toSend.getBytes();
        skt.send(new DatagramPacket(pk, pk.length, adr));
        skt.disconnect();
        skt.close();
    }
}

