/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.tomp2p.message.SHA1Signature;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.stream.ChunkedInput;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class ProtocolChunkedInput
implements ChunkedInput {
    private final ChannelHandlerContext ctx;
    private final Queue<ChannelBuffer> queue = new ConcurrentLinkedQueue<ChannelBuffer>();
    private ChannelBuffer channelBuffer = ChannelBuffers.dynamicBuffer();
    private volatile boolean done = false;
    private final Signature signature;

    public ProtocolChunkedInput(ChannelHandlerContext ctx, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException {
        this.ctx = ctx;
        if (privateKey != null) {
            this.signature = Signature.getInstance("SHA1withDSA");
            this.signature.initSign(privateKey);
        } else {
            this.signature = null;
        }
    }

    public boolean hasNextChunk() throws Exception {
        return !this.queue.isEmpty();
    }

    public Object nextChunk() throws Exception {
        ChannelBuffer channelBuffer = this.queue.poll();
        if (channelBuffer == null) {
            return null;
        }
        if (this.signature != null && channelBuffer != ChannelBuffers.EMPTY_BUFFER) {
            this.signature.update(channelBuffer.array(), channelBuffer.arrayOffset(), channelBuffer.arrayOffset() + channelBuffer.writerIndex());
        } else if (this.signature != null && channelBuffer == ChannelBuffers.EMPTY_BUFFER) {
            byte[] signatureData = this.signature.sign();
            SHA1Signature decodedSignature = new SHA1Signature();
            decodedSignature.decode(signatureData);
            channelBuffer = ChannelBuffers.wrappedBuffer((byte[][])new byte[][]{decodedSignature.getNumber1().toByteArray(), decodedSignature.getNumber2().toByteArray()});
        }
        return channelBuffer;
    }

    public int size() {
        return this.queue.size();
    }

    public void addMarkerForSignature() {
        this.flush(true);
        this.queue.add(ChannelBuffers.EMPTY_BUFFER);
        this.done = true;
    }

    public boolean isEndOfInput() throws Exception {
        return this.done && !this.hasNextChunk();
    }

    public void close() throws Exception {
        this.done = true;
    }

    public void resume() {
        ChunkedWriteHandler chunkedWriteHandler = (ChunkedWriteHandler)this.ctx.getPipeline().get("streamer");
        chunkedWriteHandler.resumeTransfer();
    }

    public void copyToCurrent(byte[] byteArray) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeBytes(byteArray);
    }

    public void copyToCurrent(int size) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeInt(size);
    }

    public void copyToCurrent(byte size) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeByte((int)size);
    }

    public void copyToCurrent(long long1) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeLong(long1);
    }

    public void copyToCurrent(short short1) {
        if (this.done) {
            return;
        }
        this.channelBuffer.writeShort((int)short1);
    }

    public void copyToCurrent(ChannelBuffer slice) {
        if (this.done) {
            return;
        }
        this.flush(false);
        this.queue.add(slice);
    }

    public void copyToCurrent(byte[] array, int offset, int length) {
        if (this.done) {
            return;
        }
        this.flush(false);
        this.queue.add(ChannelBuffers.wrappedBuffer((byte[])array, (int)offset, (int)length));
    }

    public void flush(boolean last) {
        if (this.channelBuffer.writerIndex() > 0) {
            this.queue.add(this.channelBuffer);
            if (!last) {
                this.channelBuffer = ChannelBuffers.dynamicBuffer();
            }
        }
        if (last) {
            this.done = true;
        }
    }
}

