/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.tomp2p.futures.FutureRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private static final int NR_THREADS = Runtime.getRuntime().availableProcessors() + 1;
    private static final int WARNING_THRESHOLD = 10000;
    private final LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue();
    private final ExecutorService executor = new ThreadPoolExecutor(NR_THREADS, NR_THREADS, 0L, TimeUnit.MILLISECONDS, this.queue);

    public void addQueue(FutureRunnable futureRunnable) {
        if (logger.isDebugEnabled()) {
            logger.debug("we are called from a TCP netty thread, so send this in an other thread " + Thread.currentThread().getName() + ". The queue size is: " + this.queue.size());
        }
        if (this.queue.size() > 10000 && logger.isInfoEnabled()) {
            logger.info("slow down, we have a huge backlog!");
        }
        if (this.executor.isShutdown()) {
            futureRunnable.failed("shutting down");
            return;
        }
        this.executor.execute(futureRunnable);
    }

    public void shutdown() {
        List<Runnable> runners = this.executor.shutdownNow();
        for (Runnable runner : runners) {
            FutureRunnable futureRunnable = (FutureRunnable)runner;
            futureRunnable.failed("Shutting down...");
        }
    }
}

