/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfigurationBean;
import net.tomp2p.connection.ConnectionHandler;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerConnection;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.Cancellable;
import net.tomp2p.futures.FutureBootstrap;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureCleanup;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.futures.FutureData;
import net.tomp2p.futures.FutureDiscover;
import net.tomp2p.futures.FutureLateJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.futures.FutureTracker;
import net.tomp2p.futures.FutureWrappedBootstrap;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.p2p.DistributedHashHashMap;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.DistributedTracker;
import net.tomp2p.p2p.IdentityManagement;
import net.tomp2p.p2p.Maintenance;
import net.tomp2p.p2p.P2PConfiguration;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.p2p.config.ConfigurationBaseDHT;
import net.tomp2p.p2p.config.ConfigurationBootstrap;
import net.tomp2p.p2p.config.ConfigurationDirect;
import net.tomp2p.p2p.config.ConfigurationGet;
import net.tomp2p.p2p.config.ConfigurationRemove;
import net.tomp2p.p2p.config.ConfigurationStore;
import net.tomp2p.p2p.config.ConfigurationTrackerGet;
import net.tomp2p.p2p.config.ConfigurationTrackerStore;
import net.tomp2p.p2p.config.Configurations;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.Number320;
import net.tomp2p.peers.Number480;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import net.tomp2p.peers.PeerMapKadImpl;
import net.tomp2p.replication.DefaultStorageReplication;
import net.tomp2p.replication.Replication;
import net.tomp2p.replication.TrackerStorageReplication;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.HandshakeRPC;
import net.tomp2p.rpc.NeighborRPC;
import net.tomp2p.rpc.ObjectDataReply;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.rpc.QuitRPC;
import net.tomp2p.rpc.RawDataReply;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.rpc.SimpleBloomFilter;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.rpc.TrackerRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.storage.ResponsibilityMemory;
import net.tomp2p.storage.StorageMemory;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.CacheMap;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Peer {
    private static final Logger logger = LoggerFactory.getLogger(Peer.class);
    private static final KeyPair EMPTY_KEYPAIR = new KeyPair(null, null);
    private ConnectionHandler connectionHandler;
    private final Number160 peerId;
    private final int p2pID;
    private final KeyPair keyPair;
    private DistributedHashHashMap dht;
    private DistributedTracker tracker;
    private IdentityManagement identityManagement;
    private Maintenance maintenance;
    private HandshakeRPC handshakeRCP;
    private StorageRPC storageRPC;
    private NeighborRPC neighborRPC;
    private QuitRPC quitRCP;
    private PeerExchangeRPC peerExchangeRPC;
    private DirectDataRPC directDataRPC;
    private TrackerRPC trackerRPC;
    private DistributedRouting routing;
    private Bindings bindings;
    private final P2PConfiguration peerConfiguration;
    private final ConnectionConfigurationBean connectionConfiguration;
    private ScheduledExecutorService scheduledExecutorServiceMaintenance;
    private ScheduledExecutorService scheduledExecutorServiceReplication;
    private final Map<BaseFuture, Long> pendingFutures = Collections.synchronizedMap(new CacheMap(1000));
    private boolean masterFlag = true;
    private List<ScheduledFuture<?>> scheduledFutures = Collections.synchronizedList(new ArrayList());
    private final List<PeerListener> listeners = new ArrayList<PeerListener>();
    private Timer timer;
    public static final int BLOOMFILTER_SIZE = 1024;

    public Peer(KeyPair keyPair) {
        this(Utils.makeSHAHash(keyPair.getPublic().getEncoded()), keyPair);
    }

    public Peer(Number160 nodeId) {
        this(1, nodeId, new P2PConfiguration(), new ConnectionConfigurationBean(), EMPTY_KEYPAIR);
    }

    public Peer(Number160 nodeId, KeyPair keyPair) {
        this(1, nodeId, new P2PConfiguration(), new ConnectionConfigurationBean(), keyPair);
    }

    public Peer(int p2pID, KeyPair keyPair) {
        this(p2pID, Utils.makeSHAHash(keyPair.getPublic().getEncoded()), keyPair);
    }

    public Peer(int p2pID, Number160 nodeId) {
        this(p2pID, nodeId, new P2PConfiguration(), new ConnectionConfigurationBean(), EMPTY_KEYPAIR);
    }

    public Peer(int p2pID, Number160 nodeId, KeyPair keyPair) {
        this(p2pID, nodeId, new P2PConfiguration(), new ConnectionConfigurationBean(), keyPair);
    }

    public Peer(int p2pID, Number160 nodeId, ConnectionConfigurationBean connectionConfiguration) {
        this(p2pID, nodeId, new P2PConfiguration(), connectionConfiguration, EMPTY_KEYPAIR);
    }

    public Peer(int p2pID, Number160 nodeId, P2PConfiguration peerConfiguration, ConnectionConfigurationBean connectionConfiguration, KeyPair keyPair) {
        this.p2pID = p2pID;
        this.peerId = nodeId;
        this.peerConfiguration = peerConfiguration;
        this.connectionConfiguration = connectionConfiguration;
        this.keyPair = keyPair;
    }

    public void addPeerListener(PeerListener listener) {
        if (this.isRunning()) {
            listener.notifyOnStart();
        }
        this.listeners.add(listener);
    }

    public void removePeerListener() {
        this.listeners.remove(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.info("begin shutdown in progres at " + System.nanoTime());
        List<ScheduledFuture<?>> list = this.scheduledFutures;
        synchronized (list) {
            for (ScheduledFuture<?> scheduledFuture : this.scheduledFutures) {
                scheduledFuture.cancel(true);
            }
        }
        if (this.masterFlag && this.timer != null) {
            this.timer.stop();
        }
        if (this.masterFlag && this.scheduledExecutorServiceMaintenance != null) {
            this.scheduledExecutorServiceMaintenance.shutdownNow();
        }
        if (this.masterFlag && this.scheduledExecutorServiceReplication != null) {
            this.scheduledExecutorServiceReplication.shutdownNow();
        }
        this.getConnectionHandler().shutdown();
        for (PeerListener listener : this.listeners) {
            listener.notifyOnShutdown();
        }
        this.getPeerBean().getStorage().close();
        this.connectionHandler = null;
    }

    public void listen() throws Exception {
        this.listen(this.connectionConfiguration.getDefaultPort(), this.connectionConfiguration.getDefaultPort());
    }

    public void listen(File messageLogger) throws Exception {
        this.listen(this.connectionConfiguration.getDefaultPort(), this.connectionConfiguration.getDefaultPort(), messageLogger);
    }

    public void listen(int udpPort, int tcpPort) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings());
    }

    public void listen(int udpPort, int tcpPort, File messageLogger) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings(), messageLogger);
    }

    public void listen(int udpPort, int tcpPort, InetAddress bind) throws Exception {
        this.listen(udpPort, tcpPort, new Bindings(bind), null);
    }

    public void listen(int udpPort, int tcpPort, Bindings bindings) throws Exception {
        this.listen(udpPort, tcpPort, bindings, null);
    }

    public void listen(int udpPort, int tcpPort, Bindings bindings, File messageLogger) throws Exception {
        this.masterFlag = true;
        this.timer = new HashedWheelTimer(10L, TimeUnit.MILLISECONDS, 10);
        this.bindings = bindings;
        this.scheduledExecutorServiceMaintenance = Executors.newScheduledThreadPool(this.peerConfiguration.getMaintenanceThreads());
        this.scheduledExecutorServiceReplication = Executors.newScheduledThreadPool(this.peerConfiguration.getReplicationThreads());
        PeerMapKadImpl peerMap = new PeerMapKadImpl(this.peerId, this.peerConfiguration);
        Statistics statistics = peerMap.getStatistics();
        this.init(new ConnectionHandler(udpPort, tcpPort, this.peerId, bindings, this.getP2PID(), this.connectionConfiguration, messageLogger, this.keyPair, peerMap, this.listeners, this.peerConfiguration, this.timer), statistics);
        logger.debug("init done");
    }

    public void listen(Peer master) throws Exception {
        this.masterFlag = false;
        this.timer = master.timer;
        this.bindings = master.bindings;
        this.scheduledExecutorServiceMaintenance = master.scheduledExecutorServiceMaintenance;
        this.scheduledExecutorServiceReplication = master.scheduledExecutorServiceReplication;
        PeerMapKadImpl peerMap = new PeerMapKadImpl(this.peerId, this.peerConfiguration);
        Statistics statistics = peerMap.getStatistics();
        this.init(new ConnectionHandler(master.getConnectionHandler(), this.peerId, this.keyPair, peerMap), statistics);
    }

    protected void init(ConnectionHandler connectionHandler, Statistics statistics) {
        this.connectionHandler = connectionHandler;
        PeerBean peerBean = connectionHandler.getPeerBean();
        peerBean.setStatistics(statistics);
        ConnectionBean connectionBean = connectionHandler.getConnectionBean();
        PeerAddress selfAddress = this.getPeerAddress();
        PeerMap peerMap = connectionHandler.getPeerBean().getPeerMap();
        ResponsibilityMemory responsibilityMemory = new ResponsibilityMemory();
        StorageMemory storage = new StorageMemory(responsibilityMemory);
        peerBean.setStorage(storage);
        Replication replicationStorage = new Replication(responsibilityMemory, selfAddress, peerMap);
        peerBean.setReplicationStorage(replicationStorage);
        this.identityManagement = new IdentityManagement(this.getPeerAddress());
        this.maintenance = new Maintenance();
        Replication replicationTracker = new Replication(new ResponsibilityMemory(), selfAddress, peerMap);
        TrackerStorage storageTracker = new TrackerStorage(this.identityManagement, this.getP2PConfiguration().getTrackerTimoutSeconds(), replicationTracker, this.maintenance);
        peerBean.setTrackerStorage(storageTracker);
        peerMap.addPeerOfflineListener(storageTracker);
        this.handshakeRCP = new HandshakeRPC(peerBean, connectionBean);
        this.storageRPC = new StorageRPC(peerBean, connectionBean);
        this.neighborRPC = new NeighborRPC(peerBean, connectionBean);
        this.quitRCP = new QuitRPC(peerBean, connectionBean);
        this.peerExchangeRPC = new PeerExchangeRPC(peerBean, connectionBean);
        this.directDataRPC = new DirectDataRPC(peerBean, connectionBean);
        TrackerStorageReplication trackerStorageReplication = new TrackerStorageReplication(this, this.peerExchangeRPC, this.pendingFutures, storageTracker);
        replicationTracker.addResponsibilityListener(trackerStorageReplication);
        this.trackerRPC = new TrackerRPC(peerBean, connectionBean);
        this.routing = new DistributedRouting(peerBean, this.neighborRPC);
        this.dht = new DistributedHashHashMap(this.routing, this.storageRPC, this.directDataRPC);
        this.tracker = new DistributedTracker(peerBean, this.routing, this.trackerRPC, this.peerExchangeRPC);
        if (this.peerConfiguration.isStartMaintenance()) {
            this.startMaintainance();
        }
        for (PeerListener listener : this.listeners) {
            listener.notifyOnStart();
        }
    }

    public void setDefaultStorageReplication() {
        Replication replicationStorage = this.getPeerBean().getReplicationStorage();
        DefaultStorageReplication defaultStorageReplication = new DefaultStorageReplication(this, this.getPeerBean().getStorage(), this.storageRPC, this.pendingFutures);
        this.scheduledFutures.add(this.addIndirectReplicaiton(defaultStorageReplication));
        replicationStorage.addResponsibilityListener(defaultStorageReplication);
    }

    public Map<BaseFuture, Long> getPendingFutures() {
        return this.pendingFutures;
    }

    public boolean isRunning() {
        return this.connectionHandler != null;
    }

    public boolean isListening() {
        if (!this.isRunning()) {
            return false;
        }
        return this.connectionHandler.isListening();
    }

    void startMaintainance() {
        this.scheduledFutures.add(this.addMaintainance(new Maintenance2(this.connectionHandler.getPeerBean().getPeerMap(), this.handshakeRCP, this.peerConfiguration)));
    }

    public void customLoggerMessage(String customMessage) {
        this.getConnectionHandler().customLoggerMessage(customMessage);
    }

    public HandshakeRPC getHandshakeRPC() {
        if (this.handshakeRCP == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.handshakeRCP;
    }

    public StorageRPC getStoreRPC() {
        if (this.storageRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.storageRPC;
    }

    public QuitRPC getQuitRPC() {
        if (this.quitRCP == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.quitRCP;
    }

    public PeerExchangeRPC getPeerExchangeRPC() {
        if (this.peerExchangeRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.peerExchangeRPC;
    }

    public DirectDataRPC getDirectDataRPC() {
        if (this.directDataRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.directDataRPC;
    }

    public TrackerRPC getTrackerRPC() {
        if (this.trackerRPC == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.trackerRPC;
    }

    public DistributedRouting getRouting() {
        if (this.routing == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.routing;
    }

    public ScheduledFuture<?> addIndirectReplicaiton(Runnable runnable) {
        return this.scheduledExecutorServiceReplication.scheduleWithFixedDelay(runnable, this.peerConfiguration.getReplicationRefreshMillis(), this.peerConfiguration.getReplicationRefreshMillis(), TimeUnit.MILLISECONDS);
    }

    public ScheduledFuture<?> addMaintainance(Runnable runnable) {
        return this.scheduledExecutorServiceMaintenance.scheduleWithFixedDelay(runnable, 0L, (this.peerConfiguration.getWaitingTimeBetweenNodeMaintenenceSeconds()[0] + 1) / 2, TimeUnit.SECONDS);
    }

    public ConnectionHandler getConnectionHandler() {
        if (this.connectionHandler == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.connectionHandler;
    }

    public DistributedHashHashMap getDHT() {
        if (this.dht == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.dht;
    }

    public DistributedTracker getTracker() {
        if (this.tracker == null) {
            throw new RuntimeException("Not listening to anything. Use the listen method first");
        }
        return this.tracker;
    }

    public PeerBean getPeerBean() {
        return this.getConnectionHandler().getPeerBean();
    }

    public ConnectionBean getConnectionBean() {
        return this.getConnectionHandler().getConnectionBean();
    }

    public Number160 getPeerID() {
        return this.peerId;
    }

    public PeerAddress getPeerAddress() {
        return this.getPeerBean().getServerPeerAddress();
    }

    public void setPeerMap(PeerMap peerMap) {
        this.getPeerBean().setPeerMap(peerMap);
    }

    public int getP2PID() {
        return this.p2pID;
    }

    public void setRawDataReply(RawDataReply rawDataReply) {
        this.getDirectDataRPC().setReply(rawDataReply);
    }

    public void setObjectDataReply(ObjectDataReply objectDataReply) {
        this.getDirectDataRPC().setReply(objectDataReply);
    }

    public PeerConnection createPeerConnection(PeerAddress destination, int idleTCPMillis) {
        FutureChannelCreator fcc = this.getConnectionBean().getReservation().reserve(1, true, "PeerConnection");
        fcc.awaitUninterruptibly();
        if (fcc.isFailed()) {
            return null;
        }
        ChannelCreator cc = fcc.getChannelCreator();
        PeerConnection peerConnection = new PeerConnection(destination, this.getConnectionBean().getReservation(), cc, idleTCPMillis);
        return peerConnection;
    }

    public FutureData send(PeerAddress remotePeer, ChannelBuffer requestBuffer) {
        return this.send(remotePeer, requestBuffer, true);
    }

    public FutureData send(PeerConnection connection, ChannelBuffer requestBuffer) {
        return this.send(connection, requestBuffer, true);
    }

    public FutureData send(PeerAddress remotePeer, Object object) throws IOException {
        byte[] me = Utils.encodeJavaObject(object);
        return this.send(remotePeer, ChannelBuffers.wrappedBuffer((byte[])me), false);
    }

    public FutureData send(PeerConnection connection, Object object) throws IOException {
        byte[] me = Utils.encodeJavaObject(object);
        return this.send(connection, ChannelBuffers.wrappedBuffer((byte[])me), false);
    }

    private FutureData send(final PeerConnection connection, ChannelBuffer requestBuffer, boolean raw) {
        RequestHandlerTCP<FutureData> request = this.getDirectDataRPC().send(connection.getDestination(), requestBuffer.slice(), raw);
        request.setKeepAlive(true);
        try {
            connection.aquireSingleConnection();
        }
        catch (InterruptedException e) {
            request.getFutureResponse().setFailed("Interupted " + e);
        }
        request.sendTCP(connection.getChannelCreator(), connection.getIdleTCPMillis());
        request.getFutureResponse().addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                connection.releaseSingleConnection();
            }
        });
        return request.getFutureResponse();
    }

    private FutureData send(PeerAddress remotePeer, ChannelBuffer requestBuffer, boolean raw) {
        final RequestHandlerTCP<FutureData> request = this.getDirectDataRPC().send(remotePeer, requestBuffer.slice(), raw);
        this.getConnectionBean().getReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureData futureData = (FutureData)request.sendTCP(future.getChannelCreator());
                    Utils.addReleaseListenerAll(futureData, Peer.this.getConnectionBean().getReservation(), future.getChannelCreator());
                } else {
                    ((FutureData)request.getFutureResponse()).setFailed(future);
                }
            }
        });
        return request.getFutureResponse();
    }

    public FutureBootstrap bootstrapBroadcast() {
        return this.bootstrapBroadcast(this.connectionConfiguration.getDefaultPort());
    }

    public FutureBootstrap bootstrapBroadcast(int port) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureLateJoin<FutureResponse> tmp = this.pingBroadcast(port);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureLateJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureLateJoin<FutureResponse> future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse = future.getLastSuceessFuture();
                    if (futureResponse == null) {
                        result.setFailed("no futures found");
                        return;
                    }
                    PeerAddress sender = futureResponse.getResponse().getSender();
                    ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
                    bootstrapTo.add(sender);
                    result.setBootstrapTo(bootstrapTo);
                    result.waitFor(Peer.this.bootstrap(sender));
                } else {
                    result.setFailed("could not reach anyone with the broadcast (1)");
                }
            }
        });
        return result;
    }

    FutureLateJoin<FutureResponse> pingBroadcast(final int port) {
        final int size = this.bindings.getBroadcastAddresses().size();
        final FutureLateJoin<FutureResponse> futureLateJoin = new FutureLateJoin<FutureResponse>(size, 1);
        if (size > 0) {
            this.getConnectionBean().getReservation().reserve(size).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

                @Override
                public void operationComplete(FutureChannelCreator future) throws Exception {
                    if (future.isSuccess()) {
                        FutureResponse validBroadcast = null;
                        for (int i = 0; i < size; ++i) {
                            InetAddress broadcastAddress = Peer.this.bindings.getBroadcastAddresses().get(i);
                            PeerAddress peerAddress = new PeerAddress(Number160.ZERO, broadcastAddress, port, port);
                            validBroadcast = Peer.this.getHandshakeRPC().pingBroadcastUDP(peerAddress, future.getChannelCreator());
                            Utils.addReleaseListener(validBroadcast, Peer.this.getConnectionBean().getReservation(), future.getChannelCreator(), 1);
                            if (logger.isDebugEnabled()) {
                                logger.debug("ping broadcast to " + broadcastAddress);
                            }
                            if (futureLateJoin.add(validBroadcast)) {
                                continue;
                            }
                            break;
                        }
                    } else {
                        futureLateJoin.setFailed(future);
                    }
                }
            });
        } else {
            futureLateJoin.setFailed("No broadcast address found. Cannot ping nothing");
        }
        return futureLateJoin;
    }

    public FutureResponse ping(InetSocketAddress address) {
        final RequestHandlerUDP request = this.getHandshakeRPC().pingUDP(new PeerAddress(Number160.ZERO, address));
        this.getConnectionBean().getReservation().reserve(1).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    FutureResponse futureResponse = request.sendUDP(future.getChannelCreator());
                    Utils.addReleaseListener(futureResponse, Peer.this.getConnectionBean().getReservation(), future.getChannelCreator(), 1);
                } else {
                    request.getFutureResponse().setFailed(future);
                }
            }
        });
        return request.getFutureResponse();
    }

    public FutureBootstrap bootstrap(InetSocketAddress address) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        FutureResponse tmp = this.ping(address);
        tmp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                if (future.isSuccess()) {
                    PeerAddress sender = future.getResponse().getSender();
                    ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
                    bootstrapTo.add(sender);
                    result.setBootstrapTo(bootstrapTo);
                    result.waitFor(Peer.this.bootstrap(sender));
                } else {
                    result.setFailed("could not reach anyone with the broadcast (2)");
                }
            }
        });
        return result;
    }

    public FutureBootstrap bootstrap(PeerAddress peerAddress) {
        ArrayList<PeerAddress> bootstrapTo = new ArrayList<PeerAddress>(1);
        bootstrapTo.add(peerAddress);
        return this.bootstrap(peerAddress, bootstrapTo, Configurations.defaultBootstrapConfiguration());
    }

    @Deprecated
    public FutureBootstrap bootstrap(PeerAddress peerAddress, Collection<PeerAddress> bootstrapTo, ConfigurationStore config) {
        ConfigurationBootstrap config2 = Configurations.defaultBootstrapConfiguration();
        config2.setRequestP2PConfiguration(config.getRequestP2PConfiguration());
        config2.setRoutingConfiguration(config.getRoutingConfiguration());
        return this.bootstrap(peerAddress, bootstrapTo, config2);
    }

    public FutureBootstrap bootstrap(final PeerAddress peerAddress, final Collection<PeerAddress> bootstrapTo, final ConfigurationBootstrap config) {
        final FutureWrappedBootstrap result = new FutureWrappedBootstrap();
        result.setBootstrapTo(bootstrapTo);
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getRequestP2PConfiguration().getParallel());
        this.getConnectionBean().getReservation().reserve(conn + 3).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(final FutureChannelCreator futureChannelCreator) throws Exception {
                if (futureChannelCreator.isSuccess()) {
                    if (Peer.this.peerConfiguration.isBehindFirewall()) {
                        FutureDiscover futureDiscover = new FutureDiscover();
                        Peer.this.discover(futureDiscover, peerAddress, futureChannelCreator.getChannelCreator());
                        futureDiscover.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureDiscover>(){

                            @Override
                            public void operationComplete(FutureDiscover future) throws Exception {
                                if (future.isSuccess()) {
                                    FutureRouting futureBootstrap = Peer.this.routing.bootstrap(bootstrapTo, config.getRoutingConfiguration().getMaxNoNewInfo(config.getRequestP2PConfiguration().getMinimumResults()), config.getRoutingConfiguration().getMaxFailures(), config.getRoutingConfiguration().getMaxSuccess(), config.getRoutingConfiguration().getParallel(), false, config.isForceRoutingOnlyToSelf(), futureChannelCreator.getChannelCreator());
                                    result.waitFor(futureBootstrap);
                                    Utils.addReleaseListenerAll(futureBootstrap, Peer.this.getConnectionBean().getReservation(), futureChannelCreator.getChannelCreator());
                                } else {
                                    result.setFailed("Network discovery failed.");
                                    Peer.this.getConnectionBean().getReservation().release(futureChannelCreator.getChannelCreator());
                                }
                            }
                        });
                    } else {
                        Peer.this.getConnectionBean().getReservation().release(futureChannelCreator.getChannelCreator(), 3);
                        FutureRouting futureBootstrap = Peer.this.routing.bootstrap(bootstrapTo, config.getRoutingConfiguration().getMaxNoNewInfo(config.getRequestP2PConfiguration().getMinimumResults()), config.getRoutingConfiguration().getMaxFailures(), config.getRoutingConfiguration().getMaxSuccess(), config.getRoutingConfiguration().getParallel(), false, config.isForceRoutingOnlyToSelf(), futureChannelCreator.getChannelCreator());
                        Utils.addReleaseListenerAll(futureBootstrap, Peer.this.getConnectionBean().getReservation(), futureChannelCreator.getChannelCreator());
                        result.waitFor(futureBootstrap);
                    }
                } else {
                    result.setFailed(futureChannelCreator);
                }
            }
        });
        return result;
    }

    @Deprecated
    public void setupPortForwandingUPNP(String internalHost) {
        this.setupPortForwanding(internalHost);
    }

    public void setupPortForwanding(String internalHost) {
        int portUDP = this.bindings.getOutsideUDPPort();
        int portTCP = this.bindings.getOutsideTCPPort();
        try {
            this.connectionHandler.getNATUtils().mapUPNP(internalHost, this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
        }
        catch (IOException e) {
            logger.warn("cannot find UPNP devices " + e);
            try {
                boolean retVal = this.connectionHandler.getNATUtils().mapPMP(this.getPeerAddress().portUDP(), this.getPeerAddress().portTCP(), portUDP, portTCP);
                if (!retVal) {
                    logger.warn("cannot find NAT-PMP devices");
                }
            }
            catch (NatPmpException e1) {
                logger.warn("cannot find NAT-PMP devices " + e);
            }
        }
    }

    public FutureDiscover discover(final PeerAddress peerAddress) {
        final FutureDiscover futureDiscover = new FutureDiscover();
        this.getConnectionBean().getReservation().reserve(3).addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureChannelCreator>(){

            @Override
            public void operationComplete(FutureChannelCreator future) throws Exception {
                if (future.isSuccess()) {
                    Peer.this.discover(futureDiscover, peerAddress, future.getChannelCreator());
                } else {
                    futureDiscover.setFailed(future);
                }
            }
        });
        return futureDiscover;
    }

    private void discover(final FutureDiscover futureDiscover, final PeerAddress peerAddress, final ChannelCreator cc) {
        final FutureResponse futureResponseTCP = this.getHandshakeRPC().pingTCPDiscover(peerAddress, cc);
        Utils.addReleaseListener(futureResponseTCP, this.getConnectionBean().getReservation(), cc, 1);
        this.addPeerListener(new PeerListener(){
            private boolean changedUDP = false;
            private boolean changedTCP = false;

            @Override
            public void serverAddressChanged(PeerAddress peerAddress, boolean tcp) {
                if (tcp) {
                    this.changedTCP = true;
                    futureDiscover.setDiscoveredTCP();
                } else {
                    this.changedUDP = true;
                    futureDiscover.setDiscoveredUDP();
                }
                if (this.changedTCP && this.changedUDP) {
                    futureDiscover.done(peerAddress);
                }
            }

            @Override
            public void notifyOnStart() {
            }

            @Override
            public void notifyOnShutdown() {
            }
        });
        futureResponseTCP.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureResponse>(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void operationComplete(FutureResponse future) throws Exception {
                PeerAddress serverAddress = Peer.this.getPeerBean().getServerPeerAddress();
                if (!futureResponseTCP.isSuccess()) {
                    Peer.this.getConnectionBean().getReservation().release(cc, 2);
                    futureDiscover.setFailed("FutureDiscover: We need at least the TCP connection: " + futureResponseTCP.getFailedReason());
                    return;
                }
                Collection<PeerAddress> tmp = futureResponseTCP.getResponse().getNeighbors();
                if (tmp.size() != 1) {
                    Peer.this.getConnectionBean().getReservation().release(cc, 2);
                    futureDiscover.setFailed("Peer " + peerAddress + " did not report our IP address");
                    return;
                }
                PeerAddress seenAs = tmp.iterator().next();
                logger.info("I'm seen as " + seenAs + " by peer " + peerAddress + " I see myself as " + Peer.this.getPeerAddress().getInetAddress());
                if (!Peer.this.getPeerAddress().getInetAddress().equals(seenAs.getInetAddress())) {
                    Peer.this.setupPortForwanding(futureResponseTCP.getResponse().getRecipient().getInetAddress().getHostAddress());
                    serverAddress = serverAddress.changePorts(Peer.this.bindings.getOutsideUDPPort(), Peer.this.bindings.getOutsideTCPPort());
                    serverAddress = serverAddress.changeAddress(seenAs.getInetAddress());
                    Peer.this.getPeerBean().setServerPeerAddress(serverAddress);
                    FutureResponse fr1 = Peer.this.getHandshakeRPC().pingTCPProbe(peerAddress, cc);
                    FutureResponse fr2 = Peer.this.getHandshakeRPC().pingUDPProbe(peerAddress, cc);
                    Utils.addReleaseListener(fr1, Peer.this.getConnectionBean().getReservation(), cc, 1);
                    Utils.addReleaseListener(fr2, Peer.this.getConnectionBean().getReservation(), cc, 1);
                    futureDiscover.setTimeout(Peer.this.timer, Peer.this.peerConfiguration.getDiscoverTimeoutSec());
                    return;
                }
                Peer.this.getConnectionBean().getReservation().release(cc, 2);
                futureDiscover.done(seenAs);
            }
        });
    }

    public FutureDHT put(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.put(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT put(Number160 locationKey, Data data, ConfigurationStore config) {
        return this.put(locationKey, data, config, this.reserve(config));
    }

    public FutureDHT put(Number160 locationKey, Data data, ConfigurationStore config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashMap<Number160, Data> dataMap = new HashMap<Number160, Data>();
        dataMap.put(config.getContentKey(), data);
        return this.put(locationKey, dataMap, config, channelCreator);
    }

    public FutureDHT put(Number160 locationKey, Map<Number160, Data> dataMap, ConfigurationStore config) {
        return this.put(locationKey, dataMap, config, this.reserve(config));
    }

    public FutureDHT put(Number160 locationKey, Map<Number160, Data> dataMap, ConfigurationStore config, FutureChannelCreator channelCreator) {
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDHT().put(locationKey, config.getDomain(), dataMap, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), config.isAutomaticCleanup(), config.getFutureCreate(), channelCreator, this.getConnectionBean().getReservation());
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.schedulePut(locationKey, dataMap, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> schedulePut(final Number160 locationKey, final Map<Number160, Data> dataMap, final ConfigurationStore config, final FutureDHT futureDHT) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                FutureDHT futureDHT2 = Peer.this.getDHT().put(locationKey, config.getDomain(), dataMap, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isStoreIfAbsent(), config.isProtectDomain(), config.isSignMessage(), true, config.getFutureCreate(), futureChannelCreator, Peer.this.getConnectionBean().getReservation());
                futureDHT.repeated(futureDHT2);
            }
        };
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT add(Number160 locationKey, Data data) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.add(locationKey, data, Configurations.defaultStoreConfiguration());
    }

    public FutureDHT add(Number160 locationKey, Data data, ConfigurationStore config) {
        return this.add(locationKey, data, config, this.reserve(config));
    }

    public FutureDHT add(Number160 locationKey, Data data, ConfigurationStore config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        ArrayList<Data> dataCollection = new ArrayList<Data>();
        dataCollection.add(data);
        return this.add(locationKey, dataCollection, config, channelCreator);
    }

    public FutureDHT add(Number160 locationKey, Collection<Data> dataCollection, ConfigurationStore config) {
        return this.add(locationKey, dataCollection, config, this.reserve(config));
    }

    public FutureDHT add(Number160 locationKey, Collection<Data> dataCollection, ConfigurationStore config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        if (config.getContentKey() != null && !config.getContentKey().equals(Number160.ZERO)) {
            logger.warn("Warning, setting a content key in add() does not have any effect");
        }
        if (!config.isSignMessage()) {
            for (Data data : dataCollection) {
                if (!data.isProtectedEntry()) continue;
                config.setSignMessage(true);
                break;
            }
        }
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDHT().add(locationKey, config.getDomain(), dataCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), config.isAutomaticCleanup(), config.getFutureCreate(), channelCreator, this.getConnectionBean().getReservation());
        if (config.getRefreshSeconds() > 0) {
            ScheduledFuture<?> tmp = this.scheduleAdd(locationKey, dataCollection, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleAdd(final Number160 locationKey, final Collection<Data> dataCollection, final ConfigurationStore config, final FutureDHT futureDHT) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                FutureDHT futureDHT2 = Peer.this.getDHT().add(locationKey, config.getDomain(), dataCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isProtectDomain(), config.isSignMessage(), true, config.getFutureCreate(), futureChannelCreator, Peer.this.getConnectionBean().getReservation());
                futureDHT.repeated(futureDHT2);
            }
        };
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT getAll(Number160 locationKey) {
        return this.get(locationKey, null, Configurations.defaultGetConfiguration());
    }

    public FutureDHT getAll(Number160 locationKey, ConfigurationGet config) {
        return this.get(locationKey, null, config, this.reserve(config));
    }

    public FutureDHT getAll(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        return this.get(locationKey, null, config, channelCreator);
    }

    public FutureDHT get(Number160 locationKey) {
        return this.get(locationKey, Configurations.defaultGetConfiguration());
    }

    public FutureDHT get(Number160 locationKey, ConfigurationGet config) {
        return this.get(locationKey, config, this.reserve(config));
    }

    public FutureDHT get(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.get(locationKey, keyCollection, config, channelCreator);
    }

    public FutureDHT get(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config) {
        return this.get(locationKey, keyCollection, config, this.reserve(config));
    }

    public FutureDHT get(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        FutureDHT futureDHT = this.getDHT().get(locationKey, config.getDomain(), keyCollection, config.getPublicKey(), config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getEvaluationScheme(), config.isSignMessage(), false, config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getReservation());
        return futureDHT;
    }

    public FutureDHT digestAll(Number160 locationKey) {
        return this.digest(locationKey, null, Configurations.defaultGetConfiguration());
    }

    public FutureDHT digestAll(Number160 locationKey, ConfigurationGet config) {
        return this.digestAll(locationKey, config, this.reserve(config));
    }

    public FutureDHT digestAll(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        return this.digest(locationKey, null, config, channelCreator);
    }

    public FutureDHT digest(Number160 locationKey) {
        return this.digest(locationKey, Configurations.defaultGetConfiguration());
    }

    public FutureDHT digest(Number160 locationKey, ConfigurationGet config) {
        return this.digest(locationKey, config, this.reserve(config));
    }

    public FutureDHT digest(Number160 locationKey, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.digest(locationKey, keyCollection, config, channelCreator);
    }

    public FutureDHT digest(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config) {
        return this.digest(locationKey, keyCollection, config, this.reserve(config));
    }

    public FutureDHT digest(Number160 locationKey, Set<Number160> keyCollection, ConfigurationGet config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        FutureDHT futureDHT = this.getDHT().get(locationKey, config.getDomain(), keyCollection, config.getPublicKey(), config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getEvaluationScheme(), config.isSignMessage(), true, config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getReservation());
        return futureDHT;
    }

    public FutureDHT removeAll(Number160 locationKey) {
        return this.removeAll(locationKey, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT removeAll(Number160 locationKey, ConfigurationRemove config) {
        return this.removeAll(locationKey, config, this.reserve(config));
    }

    public FutureDHT removeAll(Number160 locationKey, ConfigurationRemove config, FutureChannelCreator channelCreator) {
        return this.remove(locationKey, null, config, channelCreator);
    }

    public FutureDHT remove(Number160 locationKey) {
        return this.remove(locationKey, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT remove(Number160 locationKey, ConfigurationRemove config) {
        return this.remove(locationKey, config, this.reserve(config));
    }

    public FutureDHT remove(Number160 locationKey, ConfigurationRemove config, FutureChannelCreator channelCreator) {
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(config.getContentKey());
        return this.remove(locationKey, keyCollection, config, channelCreator);
    }

    public FutureDHT remove(Number160 locationKey, Number160 contentKey) {
        HashSet<Number160> keyCollection = new HashSet<Number160>();
        keyCollection.add(contentKey);
        return this.remove(locationKey, keyCollection, Configurations.defaultRemoveConfiguration());
    }

    public FutureDHT remove(Number160 locationKey, Set<Number160> keyCollection, ConfigurationRemove config) {
        return this.remove(locationKey, keyCollection, config, this.reserve(config));
    }

    public FutureDHT remove(Number160 locationKey, Set<Number160> keyCollection, ConfigurationRemove config, FutureChannelCreator channelCreator) {
        if (keyCollection != null) {
            for (Number160 contentKey : keyCollection) {
                this.getPeerBean().getStorage().remove(new Number480(locationKey, config.getDomain(), contentKey), this.keyPair.getPublic());
            }
        } else {
            this.getPeerBean().getStorage().remove(new Number320(locationKey, config.getDomain()), this.keyPair.getPublic());
        }
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDHT().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), config.isAutomaticCleanup(), config.getFutureCreate(), channelCreator, this.getConnectionBean().getReservation());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleRemove(locationKey, keyCollection, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleRemove(final Number160 locationKey, final Set<Number160> keyCollection, final ConfigurationRemove config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                FutureDHT futureDHT2 = Peer.this.getDHT().remove(locationKey, config.getDomain(), keyCollection, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.isReturnResults(), config.isSignMessage(), true, config.getFutureCreate(), futureChannelCreator, Peer.this.getConnectionBean().getReservation());
                futureDHT.repeated(futureDHT2);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, buffer, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer, ConfigurationDirect config) {
        return this.send(locationKey, buffer, config, this.reserve(config));
    }

    public FutureDHT send(Number160 locationKey, ChannelBuffer buffer, ConfigurationDirect config, FutureChannelCreator channelCreator) {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDHT().direct(locationKey, buffer, true, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getReservation());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    public FutureDHT send(Number160 locationKey, Object object) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        return this.send(locationKey, object, Configurations.defaultConfigurationDirect());
    }

    public FutureDHT send(Number160 locationKey, Object object, ConfigurationDirect config) throws IOException {
        return this.send(locationKey, object, config, this.reserve(config));
    }

    public FutureDHT send(Number160 locationKey, Object object, ConfigurationDirect config, FutureChannelCreator channelCreator) throws IOException {
        if (locationKey == null) {
            throw new IllegalArgumentException("null in get not allowed in locationKey");
        }
        byte[] me = Utils.encodeJavaObject(object);
        ChannelBuffer buffer = ChannelBuffers.wrappedBuffer((byte[])me);
        config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), this.getPeerBean().getPeerMap()));
        FutureDHT futureDHT = this.getDHT().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), config.isAutomaticCleanup(), channelCreator, this.getConnectionBean().getReservation());
        if (config.getRefreshSeconds() > 0 && config.getRepetitions() > 0) {
            ScheduledFuture<?> tmp = this.scheduleSend(locationKey, buffer, config, futureDHT);
            this.setupCancel(futureDHT, tmp);
        }
        return futureDHT;
    }

    private ScheduledFuture<?> scheduleSend(final Number160 locationKey, final ChannelBuffer buffer, final ConfigurationDirect config, final FutureDHT futureDHT) {
        final int repetion = config.getRepetitions();
        final class MyRunnable
        implements Runnable {
            private ScheduledFuture<?> future;
            private boolean canceled = false;
            private int counter = 0;

            MyRunnable() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.reserve(config);
                config.setRequestP2PConfiguration(Peer.adjustConfiguration(config.getRequestP2PConfiguration(), Peer.this.getPeerBean().getPeerMap()));
                FutureDHT futureDHT2 = Peer.this.getDHT().direct(locationKey, buffer, false, config.getRoutingConfiguration(), config.getRequestP2PConfiguration(), config.getFutureCreate(), config.isCancelOnFinish(), true, futureChannelCreator, Peer.this.getConnectionBean().getReservation());
                futureDHT.repeated(futureDHT2);
                if (++this.counter >= repetion) {
                    MyRunnable myRunnable = this;
                    synchronized (myRunnable) {
                        this.canceled = true;
                        if (this.future != null) {
                            this.future.cancel(false);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void setFuture(ScheduledFuture<?> future) {
                MyRunnable myRunnable = this;
                synchronized (myRunnable) {
                    if (this.canceled) {
                        future.cancel(false);
                    } else {
                        this.future = future;
                    }
                }
            }
        }
        MyRunnable myRunnable = new MyRunnable();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(myRunnable, config.getRefreshSeconds(), config.getRefreshSeconds(), TimeUnit.SECONDS);
        myRunnable.setFuture(tmp);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public FutureTracker getFromTracker(Number160 locationKey, ConfigurationTrackerGet config) {
        return this.getFromTracker(locationKey, config, new SimpleBloomFilter<Number160>(1024, 200));
    }

    public FutureTracker getFromTrackerCreateBloomfilter1(Number160 locationKey, ConfigurationTrackerGet config, Collection<PeerAddress> knownPeers) {
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 200);
        if (!knownPeers.isEmpty()) {
            for (PeerAddress peerAddress : knownPeers) {
                bloomFilter.add(peerAddress.getID());
            }
        }
        return this.getFromTracker(locationKey, config, bloomFilter);
    }

    public FutureTracker getFromTrackerCreateBloomfilter2(Number160 locationKey, ConfigurationTrackerGet config, Collection<Number160> knownPeers) {
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 200);
        if (!knownPeers.isEmpty()) {
            for (Number160 number160 : knownPeers) {
                bloomFilter.add(number160);
            }
        }
        return this.getFromTracker(locationKey, config, bloomFilter);
    }

    public FutureTracker getFromTracker(Number160 locationKey, ConfigurationTrackerGet config, Set<Number160> knownPeers) {
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
        FutureChannelCreator futureChannelCreator = this.getConnectionBean().getReservation().reserve(conn);
        FutureTracker futureTracker = this.getTracker().getFromTracker(locationKey, config.getDomain(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isExpectAttachement(), config.getEvaluationScheme(), config.isSignMessage(), config.isUseSecondaryTrackers(), knownPeers, futureChannelCreator, this.getConnectionBean().getReservation());
        return futureTracker;
    }

    public FutureTracker addToTracker(Number160 locationKey, ConfigurationTrackerStore config) {
        ScheduledFuture<?> tmp;
        SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 1024);
        this.getPeerBean().getTrackerStorage().put(locationKey, config.getDomain(), this.getPeerAddress(), this.getPeerBean().getKeyPair().getPublic(), config.getAttachement());
        int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
        FutureChannelCreator futureChannelCreator = this.getConnectionBean().getReservation().reserve(conn);
        FutureTracker futureTracker = this.getTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate(), bloomFilter, futureChannelCreator, this.getConnectionBean().getReservation());
        if (this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() > 0) {
            tmp = this.scheduleAddTracker(locationKey, config, futureTracker);
            this.setupCancel(futureTracker, tmp);
        }
        if (config.getWaitBeforeNextSendSeconds() > 0) {
            tmp = this.schedulePeerExchange(locationKey, config, futureTracker);
            this.setupCancel(futureTracker, tmp);
        }
        return futureTracker;
    }

    private void setupCancel(FutureCleanup futureTracker, final ScheduledFuture<?> tmp) {
        this.scheduledFutures.add(tmp);
        futureTracker.addCleanup(new Cancellable(){

            @Override
            public void cancel() {
                tmp.cancel(true);
                Peer.this.scheduledFutures.remove(tmp);
            }
        });
    }

    private ScheduledFuture<?> scheduleAddTracker(final Number160 locationKey, final ConfigurationTrackerStore config, final FutureTracker futureTracker) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                SimpleBloomFilter<Number160> bloomFilter = new SimpleBloomFilter<Number160>(1024, 1024);
                int conn = Math.max(config.getRoutingConfiguration().getParallel(), config.getTrackerConfiguration().getParallel());
                FutureChannelCreator futureChannelCreator = Peer.this.getConnectionBean().getReservation().reserve(conn);
                FutureTracker futureTracker2 = Peer.this.getTracker().addToTracker(locationKey, config.getDomain(), config.getAttachement(), config.getRoutingConfiguration(), config.getTrackerConfiguration(), config.isSignMessage(), config.getFutureCreate(), bloomFilter, futureChannelCreator, Peer.this.getConnectionBean().getReservation());
                futureTracker.repeated(futureTracker2);
            }
        };
        int refresh = this.getPeerBean().getTrackerStorage().getTrackerTimoutSeconds() * 3 / 4;
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, refresh, refresh, TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    private ScheduledFuture<?> schedulePeerExchange(final Number160 locationKey, final ConfigurationTrackerStore config, final FutureTracker futureTracker) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                FutureChannelCreator futureChannelCreator = Peer.this.getConnectionBean().getReservation().reserve(35);
                FutureLateJoin<FutureResponse> futureLateJoin = Peer.this.getTracker().startPeerExchange(locationKey, config.getDomain(), futureChannelCreator, Peer.this.getConnectionBean().getReservation());
                futureTracker.repeated(futureLateJoin);
            }
        };
        int refresh = config.getWaitBeforeNextSendSeconds();
        ScheduledFuture<?> tmp = this.scheduledExecutorServiceReplication.scheduleAtFixedRate(runner, refresh, refresh, TimeUnit.SECONDS);
        this.scheduledFutures.add(tmp);
        return tmp;
    }

    public ConnectionConfigurationBean getConnectionConfiguration() {
        return this.connectionConfiguration;
    }

    public P2PConfiguration getP2PConfiguration() {
        return this.peerConfiguration;
    }

    public static RequestP2PConfiguration adjustConfiguration(RequestP2PConfiguration p2pConfiguration, PeerMap peerMap) {
        int requested;
        int size = peerMap.size() + 1;
        if (size >= (requested = p2pConfiguration.getMinimumResults())) {
            return p2pConfiguration;
        }
        return new RequestP2PConfiguration(size, p2pConfiguration.getMaxFailure(), p2pConfiguration.getParallelDiff());
    }

    public FutureChannelCreator reserve(ConfigurationBaseDHT configurationBaseDHT, String name) {
        return this.reserve(configurationBaseDHT.getRoutingConfiguration(), configurationBaseDHT.getRequestP2PConfiguration(), name);
    }

    public FutureChannelCreator reserve(ConfigurationBaseDHT configurationBaseDHT) {
        return this.reserve(configurationBaseDHT, "default");
    }

    public FutureChannelCreator reserve(RoutingConfiguration routingConfiguration, RequestP2PConfiguration requestP2PConfiguration, String name) {
        int conn = Math.max(routingConfiguration.getParallel(), requestP2PConfiguration.getParallel());
        return this.getConnectionBean().getReservation().reserve(conn, name);
    }

    public void release(ChannelCreator channelCreator) {
        this.getConnectionBean().getReservation().release(channelCreator);
    }

    private class Maintenance2
    implements Runnable {
        final int max;
        final Map<PeerAddress, FutureResponse> result = new HashMap<PeerAddress, FutureResponse>();
        private final PeerMap peerMap;
        private final HandshakeRPC handshakeRPC;

        public Maintenance2(PeerMap peerMap, HandshakeRPC handshakeRPC, P2PConfiguration config) {
            this.peerMap = peerMap;
            this.handshakeRPC = handshakeRPC;
            this.max = config.getMaintenanceThreads();
        }

        @Override
        public void run() {
            Collection<PeerAddress> nas = this.peerMap.peersForMaintenance();
            if (logger.isDebugEnabled()) {
                logger.debug("numbe of peers for maintenance: " + nas.size());
            }
            for (PeerAddress na : nas) {
                FutureChannelCreator fcc = Peer.this.getConnectionBean().getReservation().reserve(1);
                fcc.awaitUninterruptibly();
                ChannelCreator cc = fcc.getChannelCreator();
                FutureResponse futureResponse = this.handshakeRPC.pingUDP(na, cc);
                Utils.addReleaseListener(futureResponse, Peer.this.getConnectionBean().getReservation(), cc, 1);
                this.result.put(na, futureResponse);
                if (this.result.size() >= this.max && !this.waitFor()) {
                    this.cleanUp();
                    return;
                }
                if (!Thread.interrupted()) continue;
                this.cleanUp();
                return;
            }
            if (!this.waitFor()) {
                this.cleanUp();
                return;
            }
        }

        private void cleanUp() {
            for (FutureResponse futureResponse : this.result.values()) {
                futureResponse.cancel();
            }
        }

        private boolean waitFor() {
            try {
                for (Map.Entry<PeerAddress, FutureResponse> entry : this.result.entrySet()) {
                    entry.getValue().await();
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("Maintenance: peer " + entry.getKey() + " online=" + entry.getValue());
                }
                this.result.clear();
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                return false;
            }
            return true;
        }
    }
}

