/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.natpmp.Gateway;
import net.tomp2p.natpmp.MapRequestMessage;
import net.tomp2p.natpmp.NatPmpDevice;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.natpmp.ResultCode;
import net.tomp2p.upnp.InternetGatewayDevice;
import net.tomp2p.upnp.UPNPResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NATUtils {
    private static final Logger logger = LoggerFactory.getLogger(NATUtils.class);
    private final Map<InternetGatewayDevice, Integer> internetGatewayDevicesUDP = new HashMap<InternetGatewayDevice, Integer>();
    private final Map<InternetGatewayDevice, Integer> internetGatewayDevicesTCP = new HashMap<InternetGatewayDevice, Integer>();
    private NatPmpDevice pmpDevice;
    private final Object shutdownLock = new Object();
    private boolean runOnce = false;

    public NATUtils() {
        this.setShutdownHookEnabled();
    }

    public boolean mapPMP(int internalPortUDP, int internalPortTCP, int externalPortUDP, int externalPortTCP) throws NatPmpException {
        InetAddress gateway = Gateway.getIP();
        this.pmpDevice = new NatPmpDevice(gateway);
        MapRequestMessage mapTCP = new MapRequestMessage(true, internalPortTCP, externalPortTCP, Integer.MAX_VALUE, null);
        MapRequestMessage mapUDP = new MapRequestMessage(false, internalPortUDP, externalPortUDP, Integer.MAX_VALUE, null);
        this.pmpDevice.enqueueMessage(mapTCP);
        this.pmpDevice.enqueueMessage(mapUDP);
        this.pmpDevice.waitUntilQueueEmpty();
        return mapTCP.getResultCode() == ResultCode.Success;
    }

    public boolean mapUPNP(String internalHost, int internalPortUDP, int internalPortTCP, int externalPortUDP, int externalPortTCP) throws IOException {
        Collection<InternetGatewayDevice> IGDs = InternetGatewayDevice.getDevices(-1);
        if (IGDs == null) {
            return false;
        }
        boolean once = false;
        for (InternetGatewayDevice igd : IGDs) {
            block9: {
                block8: {
                    logger.info("Found device " + igd);
                    try {
                        boolean mappedUDP;
                        if (externalPortUDP == -1 || !(mappedUDP = igd.addPortMapping("TomP2P mapping UDP", "UDP", internalHost, externalPortUDP, internalPortUDP))) break block8;
                        this.internetGatewayDevicesUDP.put(igd, externalPortUDP);
                    }
                    catch (IOException e) {
                        logger.warn("error in mapping UPD UPNP " + e);
                        continue;
                    }
                    catch (UPNPResponseException e) {
                        logger.warn("error in mapping UDP UPNP " + e);
                        continue;
                    }
                }
                try {
                    boolean mappedTCP;
                    if (externalPortTCP == -1 || !(mappedTCP = igd.addPortMapping("TomP2P mapping TCP", "TCP", internalHost, externalPortTCP, internalPortTCP))) break block9;
                    this.internetGatewayDevicesTCP.put(igd, externalPortTCP);
                }
                catch (IOException e) {
                    logger.warn("error in mapping TCP UPNP " + e);
                    continue;
                }
                catch (UPNPResponseException e) {
                    logger.warn("error in mapping TCP UPNP " + e);
                    continue;
                }
            }
            once = true;
        }
        return once;
    }

    private void unmapUPNP() {
        for (Map.Entry<InternetGatewayDevice, Integer> entry : this.internetGatewayDevicesTCP.entrySet()) {
            try {
                entry.getKey().deletePortMapping(null, entry.getValue(), "TCP");
            }
            catch (IOException e) {
                logger.warn("not removed TCP mapping " + entry.toString() + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("not removed TCP mapping " + entry.toString() + e);
            }
            logger.info("removed TCP mapping " + entry.toString());
        }
        for (Map.Entry<InternetGatewayDevice, Integer> entry : this.internetGatewayDevicesUDP.entrySet()) {
            try {
                entry.getKey().deletePortMapping(null, entry.getValue(), "UDP");
            }
            catch (IOException e) {
                logger.warn("not removed UDP mapping " + entry.toString() + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("not removed UDP mapping " + entry.toString() + e);
            }
            logger.info("removed UDP mapping " + entry.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setShutdownHookEnabled() {
        Object object = this.shutdownLock;
        synchronized (object) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    NATUtils.this.shutdown();
                }
            }, "TomP2P:NATUtils:ShutdownHook");
            Runtime.getRuntime().addShutdownHook(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.runOnce) {
                return;
            }
            this.runOnce = true;
            this.unmapUPNP();
            if (this.pmpDevice != null) {
                this.pmpDevice.shutdown();
            }
        }
    }
}

