/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionConfigurationBean;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.Scheduler;
import net.tomp2p.futures.FutureChannelCreator;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.p2p.Statistics;
import net.tomp2p.utils.Utils;
import org.jboss.netty.channel.ChannelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionReservation {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionReservation.class);
    private final Semaphore semaphoreCreating;
    private final Semaphore semaphoreOpen;
    private final ChannelFactory tcpClientChannelFactory;
    private final ChannelFactory udpChannelFactory;
    private final MessageLogger messageLoggerFilter;
    private final int maxPermitsCreating;
    private final int maxPermitsOpen;
    private final Statistics statistics;
    private final Map<ChannelCreator, Semaphore> activeChannelCreators = new ConcurrentHashMap<ChannelCreator, Semaphore>();
    private final Map<Long, Boolean> threads = new ConcurrentHashMap<Long, Boolean>();
    private final AtomicInteger counter = new AtomicInteger(0);
    private final Scheduler scheduler;
    private volatile boolean shutdown = false;

    public ConnectionReservation(ChannelFactory tcpClientChannelFactory, ChannelFactory udpChannelFactory, ConnectionConfigurationBean configuration, MessageLogger messageLoggerFilter, Statistics statistics, Scheduler scheduler) {
        this.tcpClientChannelFactory = tcpClientChannelFactory;
        this.udpChannelFactory = udpChannelFactory;
        this.maxPermitsCreating = configuration.getMaxCreating();
        this.maxPermitsOpen = configuration.getMaxOpenConnection();
        this.semaphoreCreating = new Semaphore(this.maxPermitsCreating);
        this.semaphoreOpen = new Semaphore(this.maxPermitsOpen);
        this.messageLoggerFilter = messageLoggerFilter;
        this.statistics = statistics;
        this.scheduler = scheduler;
    }

    public FutureChannelCreator reserve(int permits) {
        return this.reserve(permits, false, "default");
    }

    public FutureChannelCreator reserve(int permits, String name) {
        return this.reserve(permits, false, name);
    }

    public FutureChannelCreator reserve(int permits, boolean keepAliveAndReuse) {
        return this.reserve(permits, keepAliveAndReuse, "default");
    }

    public FutureChannelCreator reserve(final int permits, final boolean keepAliveAndReuse, final String name) {
        final FutureChannelCreator futureChannelCreator = new FutureChannelCreator();
        if (Thread.currentThread().getName().startsWith("Netty thread (non-blocking)/ ") || this.threads.containsKey(Thread.currentThread().getId())) {
            this.scheduler.addQueue(new FutureRunnable(){

                @Override
                public void run() {
                    ChannelCreator channelCreator = ConnectionReservation.this.reserve0(permits, keepAliveAndReuse, name, false);
                    if (channelCreator != null) {
                        futureChannelCreator.reserved(channelCreator);
                    } else {
                        futureChannelCreator.setFailed("could not reserve connection, most likely we shutdown");
                    }
                }

                @Override
                public void failed(String reason) {
                    futureChannelCreator.setFailed(reason);
                }
            });
        } else {
            ChannelCreator channelCreator = this.reserve0(permits, keepAliveAndReuse, name, true);
            if (channelCreator != null) {
                futureChannelCreator.reserved(channelCreator);
            } else {
                futureChannelCreator.setFailed("could not reserve connection, most likely we shutdown");
            }
        }
        return futureChannelCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelCreator reserve0(int permits, boolean keepAliveAndReuse, String name, boolean checkDeadlock) {
        if (this.counter.incrementAndGet() < 0) {
            logger.warn("Cannot acquire " + permits + " connections, shutting down");
            return null;
        }
        try {
            boolean acquired = this.acquire(keepAliveAndReuse ? this.semaphoreOpen : this.semaphoreCreating, permits);
            if (acquired) {
                ChannelCreator channelCreator = new ChannelCreator(permits, this.statistics, this.messageLoggerFilter, this.tcpClientChannelFactory, this.udpChannelFactory, keepAliveAndReuse, name, Thread.currentThread().getId());
                if (logger.isDebugEnabled()) {
                    logger.debug("created channels for Thread " + Thread.currentThread().getName() + "/" + Thread.currentThread().getId());
                }
                if (checkDeadlock) {
                    this.threads.put(Thread.currentThread().getId(), Boolean.TRUE);
                }
                this.activeChannelCreators.put(channelCreator, keepAliveAndReuse ? this.semaphoreOpen : this.semaphoreCreating);
                ChannelCreator channelCreator2 = channelCreator;
                return channelCreator2;
            }
            logger.warn("Cannot acquire " + permits + " connections");
            ChannelCreator channelCreator = null;
            return channelCreator;
        }
        finally {
            this.counter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquire(Semaphore semaphore, int permits) {
        boolean acquired = false;
        while (!acquired && !this.shutdown) {
            try {
                acquired = semaphore.tryAcquire(permits);
                if (!acquired) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("cannot acquire " + permits + ", in total we have " + this.maxPermitsCreating + "/" + this.maxPermitsOpen + ", but now we have " + semaphore.availablePermits());
                    }
                    Semaphore semaphore2 = semaphore;
                    synchronized (semaphore2) {
                        semaphore.wait(250L);
                        continue;
                    }
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("acquired " + permits + ", in total we have " + this.maxPermitsCreating + "/" + this.maxPermitsOpen + ", but now we have " + semaphore.availablePermits());
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return acquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(ChannelCreator channelCreator, int permits) {
        channelCreator.release(permits);
        Semaphore semaphore = this.activeChannelCreators.get(channelCreator);
        semaphore.release(permits);
        if (channelCreator.hasNoPermits()) {
            this.activeChannelCreators.remove(channelCreator);
            this.threads.remove(channelCreator.getCreatorThread());
            if (logger.isDebugEnabled()) {
                logger.debug("full release (" + permits + "), we can remove the channelcreator from the list " + semaphore.availablePermits() + ", which was created from thread: " + channelCreator.getCreatorThread());
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug("partial release (" + permits + "), we cannot remove the channelcreator from the list " + semaphore.availablePermits() + ", which was created from thread: " + channelCreator.getCreatorThread());
        }
        if (logger.isDebugEnabled()) {
            logger.debug("released " + channelCreator.getPermits() + ", in total we have " + this.maxPermitsCreating + "/" + this.maxPermitsOpen + ", now we have " + semaphore.availablePermits());
        }
        Semaphore semaphore2 = semaphore;
        synchronized (semaphore2) {
            semaphore.notifyAll();
        }
    }

    public void release(ChannelCreator channelCreator) {
        this.release(channelCreator, channelCreator.getPermits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object;
        this.scheduler.shutdown();
        if (logger.isDebugEnabled()) {
            logger.debug("Shutdown");
        }
        this.shutdown = true;
        while (this.counter.compareAndSet(0, Integer.MIN_VALUE)) {
            object = this.semaphoreCreating;
            synchronized (object) {
                this.semaphoreCreating.notifyAll();
            }
            object = this.semaphoreOpen;
            synchronized (object) {
                this.semaphoreOpen.notifyAll();
            }
        }
        object = this.activeChannelCreators;
        synchronized (object) {
            for (ChannelCreator channelCreator : this.activeChannelCreators.keySet()) {
                channelCreator.shutdown();
            }
            while (this.activeChannelCreators.size() != 0) {
                Utils.sleep(500L);
            }
        }
        this.semaphoreCreating.acquireUninterruptibly(this.maxPermitsCreating);
        this.semaphoreOpen.acquireUninterruptibly(this.maxPermitsOpen);
    }
}

