/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.utils;

import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.utils.TrafficCounter;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelState;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.logging.InternalLogger;
import org.jboss.netty.logging.InternalLoggerFactory;
import org.jboss.netty.util.DefaultObjectSizeEstimator;
import org.jboss.netty.util.ExternalResourceReleasable;
import org.jboss.netty.util.ObjectSizeEstimator;
import org.jboss.netty.util.internal.ExecutorUtil;

public abstract class AbstractTrafficShapingHandler
extends SimpleChannelHandler
implements ExternalResourceReleasable {
    static InternalLogger logger = InternalLoggerFactory.getInstance(AbstractTrafficShapingHandler.class);
    public static final long DEFAULT_CHECK_INTERVAL = 1000L;
    private static final long MINIMAL_WAIT = 10L;
    protected TrafficCounter trafficCounter = null;
    private ObjectSizeEstimator objectSizeEstimator = null;
    protected Executor executor = null;
    private long writeLimit = 0L;
    private long readLimit = 0L;
    protected long checkInterval = 1000L;
    private AtomicBoolean release = new AtomicBoolean(false);

    private void init(ObjectSizeEstimator newObjectSizeEstimator, Executor newExecutor, long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.objectSizeEstimator = newObjectSizeEstimator;
        this.executor = newExecutor;
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        this.checkInterval = newCheckInterval;
    }

    void setTrafficCounter(TrafficCounter newTrafficCounter) {
        this.trafficCounter = newTrafficCounter;
    }

    public AbstractTrafficShapingHandler(Executor executor, long writeLimit, long readLimit, long checkInterval) {
        this.init((ObjectSizeEstimator)new DefaultObjectSizeEstimator(), executor, writeLimit, readLimit, checkInterval);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Executor executor, long writeLimit, long readLimit, long checkInterval) {
        this.init(objectSizeEstimator, executor, writeLimit, readLimit, checkInterval);
    }

    public AbstractTrafficShapingHandler(Executor executor, long writeLimit, long readLimit) {
        this.init((ObjectSizeEstimator)new DefaultObjectSizeEstimator(), executor, writeLimit, readLimit, 1000L);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Executor executor, long writeLimit, long readLimit) {
        this.init(objectSizeEstimator, executor, writeLimit, readLimit, 1000L);
    }

    public AbstractTrafficShapingHandler(Executor executor) {
        this.init((ObjectSizeEstimator)new DefaultObjectSizeEstimator(), executor, 0L, 0L, 1000L);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Executor executor) {
        this.init(objectSizeEstimator, executor, 0L, 0L, 1000L);
    }

    public AbstractTrafficShapingHandler(Executor executor, long checkInterval) {
        this.init((ObjectSizeEstimator)new DefaultObjectSizeEstimator(), executor, 0L, 0L, checkInterval);
    }

    public AbstractTrafficShapingHandler(ObjectSizeEstimator objectSizeEstimator, Executor executor, long checkInterval) {
        this.init(objectSizeEstimator, executor, 0L, 0L, checkInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit, long newCheckInterval) {
        this.configure(newWriteLimit, newReadLimit);
        this.configure(newCheckInterval);
    }

    public void configure(long newWriteLimit, long newReadLimit) {
        this.writeLimit = newWriteLimit;
        this.readLimit = newReadLimit;
        if (this.trafficCounter != null) {
            this.trafficCounter.resetAccounting(System.currentTimeMillis() + 1L);
        }
    }

    public void configure(long newCheckInterval) {
        this.checkInterval = newCheckInterval;
        if (this.trafficCounter != null) {
            this.trafficCounter.configure(this.checkInterval);
        }
    }

    protected void doAccounting(TrafficCounter counter) {
    }

    private long getTimeToWait(long limit, long bytes, long lastTime, long curtime) {
        long interval = curtime - lastTime;
        if (interval == 0L) {
            return 0L;
        }
        long wait = bytes * 1000L / limit - interval;
        return wait;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageReceived(ChannelHandlerContext arg0, MessageEvent arg1) throws Exception {
        try {
            long curtime = System.currentTimeMillis();
            long size = this.objectSizeEstimator.estimateSize(arg1.getMessage());
            if (this.trafficCounter != null) {
                this.trafficCounter.bytesRecvFlowControl(arg0, size);
                if (this.readLimit == 0L) {
                    return;
                }
                long wait = this.getTimeToWait(this.readLimit, this.trafficCounter.getCurrentReadBytes(), this.trafficCounter.getLastTime(), curtime);
                if (wait > 10L) {
                    Channel channel = arg0.getChannel();
                    if (channel != null && channel.isConnected()) {
                        if (this.executor == null) {
                            if (this.release.get()) {
                                return;
                            }
                            Thread.sleep(wait);
                            return;
                        }
                        if (arg0.getAttachment() == null) {
                            arg0.setAttachment((Object)Boolean.TRUE);
                            channel.setReadable(false);
                            this.executor.execute(new ReopenRead(arg0, wait));
                        } else {
                            if (this.release.get()) {
                                return;
                            }
                            Thread.sleep(wait);
                        }
                    } else {
                        if (this.release.get()) {
                            return;
                        }
                        Thread.sleep(wait);
                    }
                }
            }
        }
        finally {
            super.messageReceived(arg0, arg1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequested(ChannelHandlerContext arg0, MessageEvent arg1) throws Exception {
        try {
            long curtime = System.currentTimeMillis();
            long size = this.objectSizeEstimator.estimateSize(arg1.getMessage());
            if (this.trafficCounter != null) {
                this.trafficCounter.bytesWriteFlowControl(size);
                if (this.writeLimit == 0L) {
                    return;
                }
                long wait = this.getTimeToWait(this.writeLimit, this.trafficCounter.getCurrentWrittenBytes(), this.trafficCounter.getLastTime(), curtime);
                if (wait > 10L) {
                    if (this.release.get()) {
                        return;
                    }
                    Thread.sleep(wait);
                }
            }
        }
        finally {
            super.writeRequested(arg0, arg1);
        }
    }

    public void handleDownstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        ChannelStateEvent cse;
        if (e instanceof ChannelStateEvent && (cse = (ChannelStateEvent)e).getState() == ChannelState.INTEREST_OPS && ((Integer)cse.getValue() & 1) != 0) {
            boolean readSuspended;
            boolean bl = readSuspended = ctx.getAttachment() != null;
            if (readSuspended) {
                e.getFuture().setSuccess();
                return;
            }
        }
        super.handleDownstream(ctx, e);
    }

    public TrafficCounter getTrafficCounter() {
        return this.trafficCounter;
    }

    public void releaseExternalResources() {
        if (this.trafficCounter != null) {
            this.trafficCounter.stop();
        }
        this.release.set(true);
        ExecutorUtil.terminate((Executor[])new Executor[]{this.executor});
    }

    public String toString() {
        return "TrafficShaping with Write Limit: " + this.writeLimit + " Read Limit: " + this.readLimit + " and Counter: " + (this.trafficCounter != null ? this.trafficCounter.toString() : "none");
    }

    public boolean hasLimit() {
        return this.readLimit != 0L || this.writeLimit != 0L;
    }

    private class ReopenRead
    implements Runnable {
        private ChannelHandlerContext ctx = null;
        private long timeToWait = 0L;

        protected ReopenRead(ChannelHandlerContext ctx, long timeToWait) {
            this.ctx = ctx;
            this.timeToWait = timeToWait;
        }

        @Override
        public void run() {
            try {
                if (AbstractTrafficShapingHandler.this.release.get()) {
                    return;
                }
                Thread.sleep(this.timeToWait);
            }
            catch (InterruptedException e) {
                return;
            }
            if (this.ctx != null && this.ctx.getChannel() != null && this.ctx.getChannel().isConnected()) {
                this.ctx.setAttachment(null);
                this.ctx.getChannel().setReadable(true);
            }
        }
    }
}

