/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PeerException;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.peers.PeerMap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultExceptionEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandlerTCP
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandlerTCP.class);
    private final FutureResponse futureResponse;
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private final Message message;
    private final MessageID sendMessageID;
    private final AtomicBoolean reported = new AtomicBoolean(false);

    public RequestHandlerTCP(FutureResponse futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
        this.futureResponse = futureResponse;
        this.message = message;
        this.sendMessageID = new MessageID(message);
    }

    public FutureResponse getFutureResponse() {
        return this.futureResponse;
    }

    public FutureResponse sendTCP(ChannelCreator channelCreator) {
        return this.sendTCP(channelCreator, this.connectionBean.getConfiguration().getIdleTCPMillis());
    }

    public FutureResponse sendTCP(ChannelCreator channelCreator, int idleTCPMillis) {
        this.connectionBean.getSender().sendTCP(this, this.futureResponse, this.message, channelCreator, idleTCPMillis);
        return this.futureResponse;
    }

    public FutureResponse fireAndForgetTCP(ChannelCreator channelCreator) {
        this.connectionBean.getSender().sendTCP(null, this.futureResponse, this.message, channelCreator, this.connectionBean.getConfiguration().getIdleTCPMillis());
        return this.futureResponse;
    }

    protected PeerMap getPeerMap() {
        return this.peerBean.getPeerMap();
    }

    public void setKeepAlive(boolean isKeepAlive) {
        this.message.setKeepAlive(isKeepAlive);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug("Error originating from: " + this.futureResponse.getRequest());
            e.getCause().printStackTrace();
        }
        if (this.futureResponse.isCompleted()) {
            logger.warn("Got exception, but ignored (future response completed): " + this.futureResponse.getFailedReason());
            if (logger.isDebugEnabled()) {
                e.getCause().printStackTrace();
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("exception caugth, but handled properly: " + e.toString());
            }
            this.reportFail(e.toString(), ctx.getChannel(), this.futureResponse);
            if (e.getCause() instanceof PeerException) {
                PeerException pe = (PeerException)e.getCause();
                if (pe.getAbortCause() != PeerException.AbortCause.USER_ABORT) {
                    boolean force = pe.getAbortCause() != PeerException.AbortCause.TIMEOUT;
                    boolean added = this.getPeerMap().peerOffline(this.futureResponse.getRequest().getRecipient(), force);
                    if (added) {
                        logger.warn("removed from map, cause: " + pe.toString() + " msg: " + this.message);
                    } else if (logger.isDebugEnabled()) {
                        logger.debug(pe.toString() + " msg: " + this.message);
                    }
                } else if (logger.isWarnEnabled()) {
                    logger.warn("error in request " + e.toString());
                    if (logger.isDebugEnabled()) {
                        e.getCause().printStackTrace();
                    }
                }
            } else {
                this.getPeerMap().peerOffline(this.futureResponse.getRequest().getRecipient(), true);
            }
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        if (!(e.getMessage() instanceof Message)) {
            String msg = "Message received, but not of type Message: " + e.getMessage();
            this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
            return;
        }
        Message responseMessage = (Message)e.getMessage();
        MessageID recvMessageID = new MessageID(responseMessage);
        if (responseMessage.getType() == Message.Type.UNKNOWN_ID) {
            String msg = "Message was not delivered successfully: " + this.message;
            this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
            return;
        }
        if (responseMessage.getType() == Message.Type.EXCEPTION) {
            String msg = "Message caused an exception on the other side, handle as peer_abort: " + this.message;
            this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
            return;
        }
        if (!this.sendMessageID.equals(recvMessageID)) {
            String msg = "Message [" + responseMessage + "] sent to the node is not the same as we expect (UDP). We sent [" + this.message + "]";
            if (logger.isWarnEnabled()) {
                logger.warn(msg);
            }
            this.exceptionCaught(ctx, (ExceptionEvent)new DefaultExceptionEvent(ctx.getChannel(), (Throwable)new PeerException(PeerException.AbortCause.PEER_ABORT, msg)));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("perfect: " + responseMessage);
        }
        if (responseMessage.isOk() || responseMessage.isNotOk()) {
            this.getPeerMap().peerFound(responseMessage.getSender(), null);
        }
        this.reportResult(ctx.getChannel(), this.futureResponse, responseMessage);
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        if (!this.reported.compareAndSet(false, true)) {
            return;
        }
        ctx.getChannel().getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                RequestHandlerTCP.this.futureResponse.setFailed("Channel closed event");
            }
        });
        ctx.sendUpstream((ChannelEvent)e);
    }

    private void reportFail(final String cause, Channel channel, final FutureResponse futureResponse) {
        if (!this.reported.compareAndSet(false, true)) {
            return;
        }
        channel.close().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                futureResponse.setFailed(cause);
            }
        });
    }

    private void reportResult(Channel channel, final FutureResponse futureResponse, final Message responseMessage) {
        if (!this.reported.compareAndSet(false, true)) {
            return;
        }
        if (this.message.isKeepAlive()) {
            futureResponse.setResponse(responseMessage);
        } else {
            channel.getCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture arg0) throws Exception {
                    futureResponse.setResponse(responseMessage);
                }
            });
        }
    }
}

