/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.concurrent.atomic.AtomicLong;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PerformanceFilter
extends SimpleChannelHandler {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceFilter.class);
    private static AtomicLong startSend = new AtomicLong(System.currentTimeMillis());
    private static AtomicLong startReceive = new AtomicLong(System.currentTimeMillis());
    private static AtomicLong messagesCountReceive = new AtomicLong(0L);
    private static AtomicLong messagesCountSend = new AtomicLong(0L);

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) {
        messagesCountReceive.incrementAndGet();
        long time = System.currentTimeMillis() - startReceive.get();
        if (time > 1000L) {
            double throughput = messagesCountReceive.doubleValue() / ((double)time / 1000.0);
            if (throughput > 1.0 && logger.isDebugEnabled()) {
                logger.debug("Incoming throughput=" + throughput + "msg/s");
            }
            startReceive.set(System.currentTimeMillis());
            messagesCountReceive.set(0L);
        }
        ctx.sendUpstream((ChannelEvent)e);
    }

    public void writeRequested(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        messagesCountSend.incrementAndGet();
        long time = System.currentTimeMillis() - startSend.get();
        if (time > 1000L) {
            double throughput = messagesCountSend.doubleValue() / ((double)time / 1000.0);
            if (throughput > 1.0 && logger.isDebugEnabled()) {
                logger.debug("[Outgoing throughput=" + throughput + "msg/s");
            }
            startSend.set(System.currentTimeMillis());
            messagesCountSend.set(0L);
        }
        ctx.sendDownstream((ChannelEvent)e);
    }
}

