/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.GZIPOutputStream;
import net.tomp2p.message.Message;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class MessageLogger
implements ChannelUpstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(MessageLogger.class);
    private final PrintWriter pw;
    private final GZIPOutputStream gz;
    private boolean open = false;

    public MessageLogger(File outputFile) throws FileNotFoundException, IOException {
        this.gz = new GZIPOutputStream(new FileOutputStream(outputFile));
        this.pw = new PrintWriter(this.gz);
        this.open = true;
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent e) throws Exception {
        if (e instanceof MessageEvent) {
            this.messageReceived((MessageEvent)e);
        }
        ctx.sendUpstream(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customMessage(String customMessage) {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            if (this.open) {
                this.pw.println("C:".concat(customMessage));
                this.pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageReceived(MessageEvent e) {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            if (this.open && e.getMessage() instanceof Message) {
                this.pw.println("R:".concat(e.getMessage().toString()));
                this.pw.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        PrintWriter printWriter = this.pw;
        synchronized (printWriter) {
            this.pw.flush();
            try {
                this.gz.finish();
                this.gz.close();
            }
            catch (IOException e) {
                logger.error(e.toString());
                e.printStackTrace();
            }
            this.pw.close();
            this.open = false;
        }
    }
}

