/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.ArrayList;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HandshakeRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(HandshakeRPC.class);
    private final boolean enable;
    private final boolean wait;

    public HandshakeRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        this(peerBean, connectionBean, true, true, false);
    }

    HandshakeRPC(PeerBean peerBean, ConnectionBean connectionBean, boolean enable, boolean register, boolean wait) {
        super(peerBean, connectionBean);
        this.enable = enable;
        this.wait = wait;
        if (register) {
            this.registerIoHandler(Message.Command.PING);
        }
    }

    public FutureResponse pingBroadcastUDP(PeerAddress remoteNode, ChannelCreator channelCreator) {
        return this.createHandlerUDP(remoteNode, Message.Type.REQUEST_1).sendBroadcastUDP(channelCreator);
    }

    public FutureResponse pingUDP(PeerAddress remoteNode, ChannelCreator channelCreator) {
        return this.createHandlerUDP(remoteNode, Message.Type.REQUEST_1).sendUDP(channelCreator);
    }

    public FutureResponse pingTCP(PeerAddress remoteNode, ChannelCreator channelCreator) {
        return this.createHandlerTCP(remoteNode, Message.Type.REQUEST_1).sendTCP(channelCreator);
    }

    public FutureResponse fireUDP(PeerAddress remoteNode, ChannelCreator channelCreator) {
        return this.createHandlerUDP(remoteNode, Message.Type.REQUEST_FF_1).fireAndForgetUDP(channelCreator);
    }

    public FutureResponse fireTCP(PeerAddress remoteNode, ChannelCreator channelCreator) {
        return this.createHandlerTCP(remoteNode, Message.Type.REQUEST_FF_1).fireAndForgetTCP(channelCreator);
    }

    private RequestHandlerUDP createHandlerUDP(PeerAddress remoteNode, Message.Type type) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, type);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerUDP(futureResponse, this.peerBean, this.connectionBean, message);
    }

    private RequestHandlerTCP createHandlerTCP(PeerAddress remoteNode, Message.Type type) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, type);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerTCP(futureResponse, this.peerBean, this.connectionBean, message);
    }

    public FutureResponse pingUDPDiscover(PeerAddress remoteNode, ChannelCreator channelCreator) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_2);
        ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
        self.add(this.peerBean.getServerPeerAddress());
        message.setNeighbors(self);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerUDP(futureResponse, this.peerBean, this.connectionBean, message).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPDiscover(PeerAddress remoteNode, ChannelCreator channelCreator) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_2);
        ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
        self.add(this.peerBean.getServerPeerAddress());
        message.setNeighbors(self);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerTCP(futureResponse, this.peerBean, this.connectionBean, message).sendTCP(channelCreator);
    }

    public FutureResponse pingUDPProbe(PeerAddress remoteNode, ChannelCreator channelCreator) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerUDP(futureResponse, this.peerBean, this.connectionBean, message).sendUDP(channelCreator);
    }

    public FutureResponse pingTCPProbe(PeerAddress remoteNode, ChannelCreator channelCreator) {
        Message message = this.createMessage(remoteNode, Message.Command.PING, Message.Type.REQUEST_3);
        FutureResponse futureResponse = new FutureResponse(message);
        return new RequestHandlerTCP(futureResponse, this.peerBean, this.connectionBean, message).sendTCP(channelCreator);
    }

    @Override
    public boolean checkMessage(Message message) {
        return (message.getType() == Message.Type.REQUEST_FF_1 || message.getType() == Message.Type.REQUEST_1 || message.getType() == Message.Type.REQUEST_2 || message.getType() == Message.Type.REQUEST_3) && message.getCommand() == Message.Command.PING;
    }

    @Override
    public Message handleResponse(final Message message, boolean sign) throws Exception {
        if (message.getType() == Message.Type.REQUEST_3) {
            logger.debug("reply to probing, fire message to " + message.getSender());
            Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
            if (sign) {
                responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
            }
            responseMessage.setMessageId(message.getMessageId());
            if (message.isUDP()) {
                FutureRunnable runner = new FutureRunnable(){

                    @Override
                    public void run() {
                        ChannelCreator cc = HandshakeRPC.this.connectionBean.getReservation().reserve(1);
                        FutureResponse fr = HandshakeRPC.this.fireUDP(message.getSender(), cc);
                        Utils.addReleaseListenerAll(fr, HandshakeRPC.this.connectionBean.getReservation(), cc);
                    }

                    @Override
                    public void failed(String reason) {
                        logger.warn("handleResponse for REQUEST_3 failed (UDP) " + reason);
                    }
                };
                this.connectionBean.getScheduler().callLater(runner);
            } else {
                FutureRunnable runner = new FutureRunnable(){

                    @Override
                    public void run() {
                        ChannelCreator cc = HandshakeRPC.this.connectionBean.getReservation().reserve(1);
                        FutureResponse fr = HandshakeRPC.this.fireTCP(message.getSender(), cc);
                        Utils.addReleaseListenerAll(fr, HandshakeRPC.this.connectionBean.getReservation(), cc);
                    }

                    @Override
                    public void failed(String reason) {
                        logger.warn("handleResponse for REQUEST_3 failed (TCP) " + reason);
                    }
                };
                this.connectionBean.getScheduler().callLater(runner);
            }
            return responseMessage;
        }
        if (message.getType() == Message.Type.REQUEST_2) {
            if (logger.isDebugEnabled()) {
                logger.debug("reply to discover, found " + message.getSender());
            }
            Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
            if (sign) {
                responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
            }
            responseMessage.setMessageId(message.getMessageId());
            ArrayList<PeerAddress> self = new ArrayList<PeerAddress>();
            self.add(message.getSender());
            responseMessage.setNeighbors(self);
            return responseMessage;
        }
        if (message.getType() == Message.Type.REQUEST_1) {
            if (message.getSender().getID().equals(this.peerBean.getServerPeerAddress().getID()) && message.getRecipient().getID().equals(Number160.ZERO)) {
                return message;
            }
            if (this.enable) {
                Message responseMessage = this.createMessage(message.getSender(), Message.Command.PING, Message.Type.OK);
                if (sign) {
                    responseMessage.setPublicKeyAndSign(this.peerBean.getKeyPair());
                }
                responseMessage.setMessageId(message.getMessageId());
                if (this.wait) {
                    Utils.sleep(10000L);
                }
                return responseMessage;
            }
            logger.debug("do not reply");
            if (this.wait) {
                Utils.sleep(10000L);
            }
            return null;
        }
        return message;
    }
}

