/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.security.PublicKey;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureListener;
import net.tomp2p.futures.FutureCreate;
import net.tomp2p.futures.FutureDHT;
import net.tomp2p.futures.FutureData;
import net.tomp2p.futures.FutureForkJoin;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRouting;
import net.tomp2p.message.Message;
import net.tomp2p.p2p.DistributedRouting;
import net.tomp2p.p2p.EvaluatingSchemeDHT;
import net.tomp2p.p2p.RequestP2PConfiguration;
import net.tomp2p.p2p.RoutingConfiguration;
import net.tomp2p.p2p.VotingSchemeDHT;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.DigestInfo;
import net.tomp2p.rpc.DirectDataRPC;
import net.tomp2p.rpc.StorageRPC;
import net.tomp2p.storage.Data;
import net.tomp2p.utils.Utils;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedHashHashMap {
    private static final Logger logger = LoggerFactory.getLogger(DistributedHashHashMap.class);
    private final DistributedRouting routing;
    private final StorageRPC storeRCP;
    private final DirectDataRPC directDataRPC;

    public DistributedHashHashMap(DistributedRouting routing, StorageRPC storeRCP, DirectDataRPC directDataRPC) {
        this.routing = routing;
        this.storeRCP = storeRCP;
        this.directDataRPC = directDataRPC;
    }

    public FutureDHT add(final Number160 locationKey, final Number160 domainKey, final Collection<Data> dataSet, RoutingConfiguration routingConfiguration, final RequestP2PConfiguration p2pConfiguration, final boolean protectDomain, final boolean signMessage, FutureCreate<FutureDHT> futureCreate, final ChannelCreator cc) {
        FutureRouting futureRouting = this.createRouting(locationKey, domainKey, null, routingConfiguration, p2pConfiguration, Message.Command.NEIGHBORS_STORAGE, false, cc);
        final FutureDHT futureDHT = new FutureDHT(p2pConfiguration.getMinimumResults(), new VotingSchemeDHT(), futureCreate, futureRouting);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting futureRouting) throws Exception {
                if (futureRouting.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("adding lkey=" + locationKey + " on " + futureRouting.getPotentialHits());
                    }
                    DistributedHashHashMap.this.loop(p2pConfiguration, futureRouting.getPotentialHits(), futureDHT, false, new Operation(){
                        Map<PeerAddress, Collection<Number160>> rawData = new HashMap<PeerAddress, Collection<Number160>>();

                        @Override
                        public FutureResponse create(PeerAddress address) {
                            return DistributedHashHashMap.this.storeRCP.add(address, locationKey, domainKey, dataSet, protectDomain, signMessage, cc);
                        }

                        @Override
                        public void response(FutureDHT futureDHT) {
                            futureDHT.setStoredKeys(this.rawData, false);
                        }

                        @Override
                        public void interMediateResponse(FutureResponse future) {
                            this.rawData.put(future.getRequest().getRecipient(), future.getResponse().getKeys());
                        }
                    });
                } else {
                    futureDHT.setFailed("routing failed");
                }
            }
        });
        return futureDHT;
    }

    public FutureDHT direct(final Number160 locationKey, final ChannelBuffer buffer, final boolean raw, RoutingConfiguration routingConfiguration, final RequestP2PConfiguration p2pConfiguration, FutureCreate<FutureDHT> futureCreate, final boolean cancelOnFinish, final ChannelCreator cc) {
        FutureRouting futureRouting = this.createRouting(locationKey, null, null, routingConfiguration, p2pConfiguration, Message.Command.NEIGHBORS_STORAGE, false, cc);
        final FutureDHT futureDHT = new FutureDHT(p2pConfiguration.getMinimumResults(), new VotingSchemeDHT(), futureCreate, futureRouting);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting futureRouting) throws Exception {
                if (futureRouting.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("storing lkey=" + locationKey + " on " + futureRouting.getPotentialHits());
                    }
                    DistributedHashHashMap.this.loop(p2pConfiguration, futureRouting.getPotentialHits(), futureDHT, cancelOnFinish, new Operation(){
                        Map<PeerAddress, ChannelBuffer> rawChannels = new HashMap<PeerAddress, ChannelBuffer>();
                        Map<PeerAddress, Object> rawObjects = new HashMap<PeerAddress, Object>();

                        @Override
                        public FutureResponse create(PeerAddress address) {
                            return DistributedHashHashMap.this.directDataRPC.send(address, buffer, raw, cc);
                        }

                        @Override
                        public void response(FutureDHT futureDHT) {
                            if (raw) {
                                futureDHT.setDirectData1(this.rawChannels);
                            } else {
                                futureDHT.setDirectData2(this.rawObjects);
                            }
                        }

                        @Override
                        public void interMediateResponse(FutureResponse future) {
                            FutureData futureData = (FutureData)future;
                            if (raw) {
                                this.rawChannels.put(future.getRequest().getRecipient(), futureData.getBuffer());
                            } else {
                                this.rawObjects.put(future.getRequest().getRecipient(), futureData.getObject());
                            }
                        }
                    });
                } else {
                    futureDHT.setFailed("routing failed");
                }
            }
        });
        return futureDHT;
    }

    public FutureDHT put(final Number160 locationKey, final Number160 domainKey, final Map<Number160, Data> dataMap, RoutingConfiguration routingConfiguration, final RequestP2PConfiguration p2pConfiguration, final boolean putIfAbsent, final boolean protectDomain, final boolean signMessage, FutureCreate<FutureDHT> futureCreate, final ChannelCreator cc) {
        FutureRouting futureRouting = this.createRouting(locationKey, domainKey, null, routingConfiguration, p2pConfiguration, Message.Command.NEIGHBORS_STORAGE, false, cc);
        final FutureDHT futureDHT = new FutureDHT(p2pConfiguration.getMinimumResults(), new VotingSchemeDHT(), futureCreate, futureRouting);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting futureRouting) throws Exception {
                if (futureRouting.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("storing lkey=" + locationKey + " on " + futureRouting.getPotentialHits());
                    }
                    DistributedHashHashMap.this.loop(p2pConfiguration, futureRouting.getPotentialHits(), futureDHT, false, new Operation(){
                        Map<PeerAddress, Collection<Number160>> rawData = new HashMap<PeerAddress, Collection<Number160>>();

                        @Override
                        public FutureResponse create(PeerAddress address) {
                            boolean protectEntry = Utils.checkEntryProtection(dataMap);
                            return putIfAbsent ? DistributedHashHashMap.this.storeRCP.putIfAbsent(address, locationKey, domainKey, dataMap, protectDomain, protectEntry, signMessage, cc) : DistributedHashHashMap.this.storeRCP.put(address, locationKey, domainKey, dataMap, protectDomain, protectEntry, signMessage, cc);
                        }

                        @Override
                        public void response(FutureDHT futureDHT) {
                            futureDHT.setStoredKeys(this.rawData, putIfAbsent);
                        }

                        @Override
                        public void interMediateResponse(FutureResponse future) {
                            this.rawData.put(future.getRequest().getRecipient(), future.getResponse().getKeys());
                        }
                    });
                } else {
                    futureDHT.setFailed("routing failed");
                }
            }
        });
        return futureDHT;
    }

    public FutureDHT get(final Number160 locationKey, final Number160 domainKey, final Set<Number160> contentKeys, final PublicKey publicKey, RoutingConfiguration routingConfiguration, final RequestP2PConfiguration p2pConfiguration, EvaluatingSchemeDHT evaluationScheme, final boolean signMessage, final boolean digest, final ChannelCreator cc) {
        FutureRouting futureRouting = this.createRouting(locationKey, domainKey, contentKeys, routingConfiguration, p2pConfiguration, Message.Command.NEIGHBORS_STORAGE, true, cc);
        final FutureDHT futureDHT = new FutureDHT(p2pConfiguration.getMinimumResults(), evaluationScheme, null, futureRouting);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting futureRouting) throws Exception {
                if (futureRouting.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("found direct hits for get: " + futureRouting.getDirectHits());
                    }
                    DistributedHashHashMap.this.loop(DistributedHashHashMap.adjustConfiguration(p2pConfiguration, futureRouting.getDirectHitsDigest()), futureRouting.getDirectHits(), futureDHT, true, new Operation(){
                        Map<PeerAddress, Map<Number160, Data>> rawData = new HashMap<PeerAddress, Map<Number160, Data>>();
                        Map<PeerAddress, Collection<Number160>> rawDigest = new HashMap<PeerAddress, Collection<Number160>>();

                        @Override
                        public FutureResponse create(PeerAddress address) {
                            return DistributedHashHashMap.this.storeRCP.get(address, locationKey, domainKey, contentKeys, publicKey, signMessage, digest, cc);
                        }

                        @Override
                        public void response(FutureDHT futureDHT) {
                            if (digest) {
                                futureDHT.setReceivedDigest(this.rawDigest);
                            } else {
                                futureDHT.setReceivedData(this.rawData);
                            }
                        }

                        @Override
                        public void interMediateResponse(FutureResponse future) {
                            if (digest) {
                                this.rawDigest.put(future.getRequest().getRecipient(), future.getResponse().getKeys());
                            } else {
                                this.rawData.put(future.getRequest().getRecipient(), future.getResponse().getDataMap());
                            }
                        }
                    });
                } else {
                    futureDHT.setFailed("routing failed");
                }
            }
        });
        return futureDHT;
    }

    public FutureDHT remove(final Number160 locationKey, final Number160 domainKey, final Set<Number160> contentKeys, RoutingConfiguration routingConfiguration, final RequestP2PConfiguration p2pConfiguration, final boolean returnResults, final boolean signMessage, FutureCreate<FutureDHT> futureCreate, final ChannelCreator cc) {
        FutureRouting futureRouting = this.createRouting(locationKey, domainKey, contentKeys, routingConfiguration, p2pConfiguration, Message.Command.NEIGHBORS_STORAGE, true, cc);
        final FutureDHT futureDHT = new FutureDHT(p2pConfiguration.getMinimumResults(), new VotingSchemeDHT(), futureCreate, futureRouting);
        futureRouting.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureRouting>(){

            @Override
            public void operationComplete(FutureRouting futureRouting) throws Exception {
                if (futureRouting.isSuccess()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("found direct hits for remove: " + futureRouting.getDirectHits());
                    }
                    DistributedHashHashMap.this.loop(p2pConfiguration, futureRouting.getDirectHits(), futureDHT, false, new Operation(){
                        Map<PeerAddress, Map<Number160, Data>> rawDataResult = new HashMap<PeerAddress, Map<Number160, Data>>();
                        Map<PeerAddress, Collection<Number160>> rawDataNoResult = new HashMap<PeerAddress, Collection<Number160>>();

                        @Override
                        public FutureResponse create(PeerAddress address) {
                            return DistributedHashHashMap.this.storeRCP.remove(address, locationKey, domainKey, contentKeys, returnResults, signMessage, cc);
                        }

                        @Override
                        public void response(FutureDHT futureDHT) {
                            if (returnResults) {
                                futureDHT.setReceivedData(this.rawDataResult);
                            } else {
                                futureDHT.setRemovedKeys(this.rawDataNoResult);
                            }
                        }

                        @Override
                        public void interMediateResponse(FutureResponse future) {
                            if (returnResults) {
                                this.rawDataResult.put(future.getRequest().getRecipient(), future.getResponse().getDataMap());
                            } else {
                                this.rawDataNoResult.put(future.getRequest().getRecipient(), future.getResponse().getKeys());
                            }
                        }
                    });
                } else {
                    futureDHT.setFailed("routing failed");
                }
            }
        });
        return futureDHT;
    }

    private void loop(RequestP2PConfiguration p2pConfiguration, SortedSet<PeerAddress> queue, FutureDHT futureDHT, boolean cancleOnFinish, Operation operation) {
        if (p2pConfiguration.getMinimumResults() == 0) {
            operation.response(futureDHT);
            return;
        }
        FutureResponse[] futures = new FutureResponse[p2pConfiguration.getParallel()];
        this.loopRec(queue, p2pConfiguration.getMinimumResults(), new AtomicInteger(0), p2pConfiguration.getMaxFailure(), p2pConfiguration.getParallelDiff(), futures, futureDHT, cancleOnFinish, operation);
    }

    private void loopRec(final SortedSet<PeerAddress> queue, final int min, final AtomicInteger nrFailure, final int maxFailure, final int parallelDiff, final FutureResponse[] futures, final FutureDHT futureDHT, final boolean cancelOnFinish, final Operation operation) {
        int active = 0;
        for (int i = 0; i < min + parallelDiff; ++i) {
            if (futures[i] == null) {
                PeerAddress next = Utils.pollFirst(queue);
                if (next == null) continue;
                ++active;
                futures[i] = operation.create(next);
                futureDHT.addRequests(futures[i]);
                continue;
            }
            ++active;
        }
        if (active == 0) {
            operation.response(futureDHT);
            DistributedRouting.cancel(cancelOnFinish, min + parallelDiff, futures);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("fork/join status: " + min + "/" + active + " (" + parallelDiff + ")");
        }
        FutureForkJoin fp = new FutureForkJoin(Math.min(min, active), false, (BaseFuture[])futures);
        fp.addListener((BaseFutureListener<? extends BaseFuture>)new BaseFutureAdapter<FutureForkJoin<FutureResponse>>(){

            @Override
            public void operationComplete(FutureForkJoin<FutureResponse> future) throws Exception {
                for (FutureResponse futureResponse : future.getCompleted()) {
                    if (!futureResponse.isSuccess()) continue;
                    operation.interMediateResponse(futureResponse);
                }
                if (future.isSuccess() || nrFailure.incrementAndGet() > maxFailure) {
                    if (cancelOnFinish) {
                        DistributedRouting.cancel(cancelOnFinish, min + parallelDiff, futures);
                    }
                    operation.response(futureDHT);
                } else {
                    DistributedHashHashMap.this.loopRec(queue, min - future.getSuccessCounter(), nrFailure, maxFailure, parallelDiff, futures, futureDHT, cancelOnFinish, operation);
                }
            }
        });
    }

    private FutureRouting createRouting(Number160 locationKey, Number160 domainKey, Set<Number160> contentKeys, RoutingConfiguration routingConfiguration, RequestP2PConfiguration p2pConfiguration, Message.Command command, boolean isDirect, ChannelCreator cc) {
        return this.routing.route(locationKey, domainKey, contentKeys, command, routingConfiguration.getDirectHits(), routingConfiguration.getMaxNoNewInfo(p2pConfiguration.getMinimumResults()), routingConfiguration.getMaxFailures(), routingConfiguration.getMaxSuccess(), routingConfiguration.getParallel(), isDirect, routingConfiguration.isForceSocket(), cc);
    }

    public static RequestP2PConfiguration adjustConfiguration(RequestP2PConfiguration p2pConfiguration, SortedMap<PeerAddress, DigestInfo> directHitsDigest) {
        int requested;
        HashSet<DigestInfo> tmp = new HashSet<DigestInfo>();
        for (DigestInfo digestBean : directHitsDigest.values()) {
            if (digestBean.isEmpty()) continue;
            tmp.add(digestBean);
        }
        int unique = tmp.size();
        if (unique >= (requested = p2pConfiguration.getMinimumResults())) {
            return p2pConfiguration;
        }
        return new RequestP2PConfiguration(unique, p2pConfiguration.getMaxFailure(), p2pConfiguration.getParallelDiff());
    }

    public static interface Operation {
        public FutureResponse create(PeerAddress var1);

        public void response(FutureDHT var1);

        public void interMediateResponse(FutureResponse var1);
    }
}

