/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.tomp2p.connection.Bindings;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.ConnectionConfigurationBean;
import net.tomp2p.connection.ConnectionReservation;
import net.tomp2p.connection.DiscoverNetworks;
import net.tomp2p.connection.DispatcherReply;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.NATUtils;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.connection.PerformanceFilter;
import net.tomp2p.connection.Sender;
import net.tomp2p.message.TomP2PDecoderTCP;
import net.tomp2p.message.TomP2PDecoderUDP;
import net.tomp2p.message.TomP2PEncoderTCP;
import net.tomp2p.message.TomP2PEncoderUDP;
import net.tomp2p.p2p.P2PConfiguration;
import net.tomp2p.p2p.PeerListener;
import net.tomp2p.p2p.Scheduler;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerMap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioClientSocketChannelFactory;
import org.jboss.netty.channel.socket.nio.NioDatagramChannelFactory;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.HashedWheelTimer;
import org.jboss.netty.util.ThreadNameDeterminer;
import org.jboss.netty.util.ThreadRenamingRunnable;
import org.jboss.netty.util.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler {
    public static final String THREAD_NAME = "Netty thread (non-blocking)/ ";
    private static final Logger logger;
    private final ConnectionBean connectionBean;
    private final PeerBean peerBean;
    private final NATUtils natUtils;
    public static final int UDP_LIMIT = 1400;
    private static final PerformanceFilter performanceFilter;
    private final MessageLogger messageLoggerFilter;
    private final List<ConnectionHandler> childConnections = new ArrayList<ConnectionHandler>();
    private final Timer timer;
    private final boolean master;
    private final ChannelFactory udpChannelFactory;
    private final ChannelFactory tcpServerChannelFactory;
    private final ChannelFactory tcpClientChannelFactory;

    public ConnectionHandler(int udpPort, int tcpPort, Number160 id, Bindings bindings, int p2pID, ConnectionConfigurationBean configuration, File messageLogger, KeyPair keyPair, PeerMap peerMap, List<PeerListener> listeners, P2PConfiguration peerConfiguration) throws Exception {
        PeerAddress self;
        this.timer = new HashedWheelTimer();
        this.udpChannelFactory = new NioDatagramChannelFactory((Executor)Executors.newCachedThreadPool());
        this.tcpServerChannelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        this.tcpClientChannelFactory = new NioClientSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
        boolean listenAll = bindings.isListenAll();
        String status = DiscoverNetworks.discoverInterfaces(bindings);
        logger.info("Status of interface search: " + status);
        InetAddress outsideAddress = bindings.getExternalAddress();
        if (outsideAddress == null) {
            if (bindings.getAddresses0().size() == 0) {
                throw new IOException("Not listening to anything. Maybe your binding information is wrong.");
            }
            outsideAddress = bindings.getAddresses0().get(0);
            self = new PeerAddress(id, outsideAddress, tcpPort, udpPort, peerConfiguration.isBehindFirewall(), peerConfiguration.isBehindFirewall());
        } else {
            self = new PeerAddress(id, outsideAddress, bindings.getOutsideTCPPort(), bindings.getOutsideUDPPort(), peerConfiguration.isBehindFirewall(), peerConfiguration.isBehindFirewall());
        }
        this.peerBean = new PeerBean(keyPair);
        this.peerBean.setServerPeerAddress(self);
        this.peerBean.setPeerMap(peerMap);
        logger.info("Visible address to other peers: " + self);
        this.messageLoggerFilter = messageLogger == null ? null : new MessageLogger(messageLogger);
        ConnectionReservation reservation = new ConnectionReservation(this.tcpClientChannelFactory, this.udpChannelFactory, configuration, this.messageLoggerFilter, peerMap.getStatistics());
        DefaultChannelGroup channelGroup = new DefaultChannelGroup("TomP2P ConnectionHandler");
        DispatcherReply dispatcherRequest = new DispatcherReply(p2pID, this.peerBean, configuration.getIdleUDPMillis(), configuration.getIdleTCPMillis(), (ChannelGroup)channelGroup, peerMap, listeners);
        Scheduler scheduledPeer = new Scheduler();
        Sender sender = new Sender(configuration, this.timer);
        this.connectionBean = new ConnectionBean(p2pID, dispatcherRequest, sender, (ChannelGroup)channelGroup, scheduledPeer, reservation, configuration);
        if (listenAll) {
            logger.info("Listening for broadcasts on port udp: " + udpPort + " and tcp:" + tcpPort);
            if (!this.startupTCP(new InetSocketAddress(tcpPort), dispatcherRequest, configuration.getMaxMessageSize()) || !this.startupUDP(new InetSocketAddress(udpPort), dispatcherRequest)) {
                throw new IOException("cannot bind TCP or UDP");
            }
        } else {
            for (InetAddress addr : bindings.getAddresses()) {
                logger.info("Listening on address: " + addr + " on port udp: " + udpPort + " and tcp:" + tcpPort);
                if (this.startupTCP(new InetSocketAddress(addr, tcpPort), dispatcherRequest, configuration.getMaxMessageSize()) && this.startupUDP(new InetSocketAddress(addr, udpPort), dispatcherRequest)) continue;
                throw new IOException("cannot bind TCP or UDP");
            }
        }
        this.natUtils = new NATUtils();
        this.master = true;
    }

    public ConnectionHandler(ConnectionHandler parent, Number160 id, KeyPair keyPair, PeerMap peerMap) {
        parent.childConnections.add(this);
        this.connectionBean = parent.connectionBean;
        PeerAddress self = parent.getPeerBean().getServerPeerAddress().changePeerId(id);
        this.peerBean = new PeerBean(keyPair);
        this.peerBean.setServerPeerAddress(self);
        this.peerBean.setPeerMap(peerMap);
        this.messageLoggerFilter = parent.messageLoggerFilter;
        this.udpChannelFactory = parent.udpChannelFactory;
        this.tcpServerChannelFactory = parent.tcpServerChannelFactory;
        this.tcpClientChannelFactory = parent.tcpClientChannelFactory;
        this.timer = parent.timer;
        this.natUtils = parent.natUtils;
        this.master = false;
    }

    public ConnectionBean getConnectionBean() {
        return this.connectionBean;
    }

    public PeerBean getPeerBean() {
        return this.peerBean;
    }

    public NATUtils getNATUtils() {
        return this.natUtils;
    }

    public boolean startupUDP(InetSocketAddress listenAddressesUDP, final DispatcherReply dispatcher) {
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap(this.udpChannelFactory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipe = Channels.pipeline();
                pipe.addLast("encoder", (ChannelHandler)new TomP2PEncoderUDP());
                pipe.addLast("decoder", (ChannelHandler)new TomP2PDecoderUDP());
                if (ConnectionHandler.this.messageLoggerFilter != null) {
                    pipe.addLast("loggerUpstream", (ChannelHandler)ConnectionHandler.this.messageLoggerFilter);
                }
                pipe.addLast("performance", (ChannelHandler)performanceFilter);
                pipe.addLast("handler", (ChannelHandler)dispatcher);
                return pipe;
            }
        });
        bootstrap.setOption("broadcast", (Object)"false");
        bootstrap.setOption("receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1400));
        Channel channel = bootstrap.bind((SocketAddress)listenAddressesUDP);
        logger.info("Listening on UDP socket: " + listenAddressesUDP);
        this.connectionBean.getChannelGroup().add((Object)channel);
        return channel.isBound();
    }

    public boolean startupTCP(InetSocketAddress listenAddressesTCP, final DispatcherReply dispatcher, int maxMessageSize) {
        ServerBootstrap bootstrap = new ServerBootstrap(this.tcpServerChannelFactory);
        bootstrap.setPipelineFactory(new ChannelPipelineFactory(){

            public ChannelPipeline getPipeline() throws Exception {
                ChannelPipeline pipe = Channels.pipeline();
                pipe.addLast("streamer", (ChannelHandler)new ChunkedWriteHandler());
                pipe.addLast("encoder", (ChannelHandler)new TomP2PEncoderTCP());
                pipe.addLast("decoder", (ChannelHandler)new TomP2PDecoderTCP());
                if (ConnectionHandler.this.messageLoggerFilter != null) {
                    pipe.addLast("loggerUpstream", (ChannelHandler)ConnectionHandler.this.messageLoggerFilter);
                }
                pipe.addLast("performance", (ChannelHandler)performanceFilter);
                pipe.addLast("handler", (ChannelHandler)dispatcher);
                return pipe;
            }
        });
        bootstrap.setOption("backlog", (Object)1000);
        Channel channel = bootstrap.bind((SocketAddress)listenAddressesTCP);
        this.connectionBean.getChannelGroup().add((Object)channel);
        logger.info("Listening on TCP socket: " + listenAddressesTCP);
        return channel.isBound();
    }

    public void customLoggerMessage(String customMessage) {
        if (this.messageLoggerFilter != null) {
            this.messageLoggerFilter.customMessage(customMessage);
        } else {
            logger.error("cannot write to log, as no file was provided");
        }
    }

    public void shutdown() {
        if (this.master && logger.isDebugEnabled()) {
            logger.debug("shutdown in progress..." + System.nanoTime());
        }
        this.connectionBean.getDispatcherRequest().removeIoHandler(this.getPeerBean().getServerPeerAddress().getID());
        for (ConnectionHandler handler : this.childConnections) {
            handler.shutdown();
        }
        if (this.master) {
            this.natUtils.shutdown();
            this.timer.stop();
            if (this.messageLoggerFilter != null) {
                this.messageLoggerFilter.shutdown();
            }
            this.connectionBean.getScheduler().shutdownAndWait();
            this.connectionBean.getReservation().shutdown();
            this.connectionBean.getChannelGroup().close().awaitUninterruptibly();
            this.udpChannelFactory.releaseExternalResources();
            this.tcpServerChannelFactory.releaseExternalResources();
            this.tcpClientChannelFactory.releaseExternalResources();
            if (logger.isDebugEnabled()) {
                logger.debug("shutdown complete");
            }
        }
    }

    public boolean isListening() {
        return !this.getConnectionBean().getChannelGroup().isEmpty();
    }

    static {
        ThreadRenamingRunnable.setThreadNameDeterminer((ThreadNameDeterminer)new ThreadNameDeterminer(){

            public String determineThreadName(String currentThreadName, String proposedThreadName) throws Exception {
                return ConnectionHandler.THREAD_NAME + currentThreadName;
            }
        });
        logger = LoggerFactory.getLogger(ConnectionHandler.class);
        performanceFilter = new PerformanceFilter();
    }
}

