/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.message;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Signature;
import net.tomp2p.message.DecoderException;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageCodec;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.MessageEvent;

@ChannelHandler.Sharable
public class TomP2PDecoderUDP
implements ChannelUpstreamHandler {
    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent evt) throws Exception {
        if (!(evt instanceof MessageEvent)) {
            ctx.sendUpstream(evt);
            return;
        }
        MessageEvent e = (MessageEvent)evt;
        Object originalMessage = e.getMessage();
        if (!(originalMessage instanceof ChannelBuffer)) {
            ctx.sendUpstream(evt);
            return;
        }
        Message message = this.decode(ctx, e.getChannel(), (ChannelBuffer)originalMessage, e.getRemoteAddress());
        if (message != null) {
            Channels.fireMessageReceived((ChannelHandlerContext)ctx, (Object)message, (SocketAddress)e.getRemoteAddress());
        }
    }

    protected Message decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer, SocketAddress socketAddress) throws Exception {
        if (buffer.readableBytes() < 56) {
            Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DecoderException("did not get all the data expected (1), got " + buffer.readableBytes()));
            return null;
        }
        int readerIndex = buffer.readerIndex();
        InetSocketAddress localSocket = (InetSocketAddress)channel.getLocalAddress();
        Message message = MessageCodec.decodeHeader(buffer, localSocket, (InetSocketAddress)socketAddress);
        message.setUDP();
        message.finished();
        if (message.hasContent()) {
            if (!MessageCodec.decodePayload(message.getContentType1(), buffer, message)) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DecoderException("did not get all the data expected (2), got " + buffer.readableBytes()));
                return null;
            }
            if (!MessageCodec.decodePayload(message.getContentType2(), buffer, message)) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DecoderException("did not get all the data expected (3), got " + buffer.readableBytes()));
                return null;
            }
            if (!MessageCodec.decodePayload(message.getContentType3(), buffer, message)) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DecoderException("did not get all the data expected (4), got " + buffer.readableBytes()));
                return null;
            }
            if (!MessageCodec.decodePayload(message.getContentType4(), buffer, message)) {
                Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DecoderException("did not get all the data expected (5), got " + buffer.readableBytes()));
                return null;
            }
            if (message.isHintSign()) {
                Signature signature = Signature.getInstance("SHA1withDSA");
                signature.initVerify(message.getPublicKey());
                int read = buffer.readerIndex() - readerIndex;
                signature.update(buffer.array(), buffer.arrayOffset() + readerIndex, read);
                if (!MessageCodec.decodeSignature(signature, message, buffer)) {
                    Channels.fireExceptionCaught((ChannelHandlerContext)ctx, (Throwable)new DecoderException("did not get all the data expected (6), got " + buffer.readableBytes()));
                    return null;
                }
            }
        }
        return message;
    }
}

