/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.futures;

import java.util.ArrayList;
import java.util.List;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.BaseFutureAdapter;
import net.tomp2p.futures.BaseFutureImpl;

public class FutureLateJoin<K extends BaseFuture>
extends BaseFutureImpl
implements BaseFuture {
    private final int nrMaxFutures;
    private final int minSuccess;
    private final List<K> futuresDone;
    private int successCount = 0;

    public FutureLateJoin(int nrMaxFutures) {
        this(nrMaxFutures, nrMaxFutures);
    }

    public FutureLateJoin(int nrMaxFutures, int minSuccess) {
        this.nrMaxFutures = nrMaxFutures;
        this.minSuccess = minSuccess;
        this.futuresDone = new ArrayList<K>(nrMaxFutures);
    }

    public void add(K future) {
        future.addListener(new BaseFutureAdapter<K>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void operationComplete(K future) throws Exception {
                boolean done;
                Object object = FutureLateJoin.this.lock;
                synchronized (object) {
                    if (future.isSuccess()) {
                        FutureLateJoin.this.successCount++;
                    }
                    done = FutureLateJoin.this.checkDone(future);
                }
                if (done) {
                    FutureLateJoin.this.notifyListerenrs();
                }
            }
        });
    }

    private boolean checkDone(K future) {
        boolean done = false;
        if (!this.completed) {
            this.futuresDone.add(future);
            if (this.futuresDone.size() == this.nrMaxFutures) {
                done = this.setCompletedAndNotify();
                boolean isSuccess = this.successCount >= this.minSuccess;
                this.type = isSuccess ? BaseFuture.FutureType.OK : BaseFuture.FutureType.FAILED;
                this.reason = isSuccess ? "All Futures Ok" : "At least one future failed";
            }
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<K> getFuturesDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.futuresDone;
        }
    }
}

