/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import net.tomp2p.connection.ConnectionReservation;
import net.tomp2p.connection.MessageLogger;
import net.tomp2p.connection.ReplyTimeoutHandler;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.TomP2PDecoderTCP;
import net.tomp2p.message.TomP2PDecoderUDP;
import net.tomp2p.message.TomP2PEncoderTCP;
import net.tomp2p.message.TomP2PEncoderUDP;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.RequestHandlerTCP;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.utils.CacheMap;
import org.jboss.netty.bootstrap.Bootstrap;
import org.jboss.netty.bootstrap.ClientBootstrap;
import org.jboss.netty.bootstrap.ConnectionlessBootstrap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelDownstreamHandler;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.FixedReceiveBufferSizePredictor;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;

public class ChannelCreator {
    private final Semaphore semaphoreOpenConnections;
    private final int permits;
    private final ChannelGroup channelsTCP;
    private final ChannelGroup channelsUDP;
    private final MessageLogger messageLoggerFilter;
    private final ChannelFactory tcpClientChannelFactory;
    private final ChannelFactory udpChannelFactory;
    private final AtomicBoolean shutdown;
    private final ConnectionReservation connectionReservation;
    private final boolean keepAliveAndReuse;
    private final Map<String, ChannelFuture> cacheMap = Collections.synchronizedMap(new CacheMap(100));
    private static AtomicLong statConnectionsCreatedTCP = new AtomicLong();
    private static AtomicLong statConnectionsCreatedUDP = new AtomicLong();

    public ChannelCreator(ChannelGroup channelsTCP, ChannelGroup channelsUDP, int permits, MessageLogger messageLoggerFilter, ChannelFactory tcpClientChannelFactory, ChannelFactory udpClientChannelFactory, AtomicBoolean shutdown, ConnectionReservation connectionReservation, boolean keepAliveAndReuse) {
        this.permits = permits;
        this.channelsTCP = channelsTCP;
        this.channelsUDP = channelsUDP;
        this.semaphoreOpenConnections = new Semaphore(permits);
        this.messageLoggerFilter = messageLoggerFilter;
        this.tcpClientChannelFactory = tcpClientChannelFactory;
        this.udpChannelFactory = udpClientChannelFactory;
        this.shutdown = shutdown;
        this.connectionReservation = connectionReservation;
        this.keepAliveAndReuse = keepAliveAndReuse;
    }

    public Channel createUDPChannel(ReplyTimeoutHandler timeoutHandler, RequestHandlerUDP requestHandler, FutureResponse futureResponse, boolean broadcast) {
        Channel channel;
        if (this.shutdown.get()) {
            throw new RuntimeException("Cannot create channel if already shutdown");
        }
        if (!this.semaphoreOpenConnections.tryAcquire()) {
            throw new RuntimeException("you ran out of permits. You had " + this.permits + " available, but now its down to 0");
        }
        try {
            channel = this.createChannelUDP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, broadcast);
        }
        catch (Exception e) {
            futureResponse.setFailed("Cannot create channel " + e);
            this.semaphoreOpenConnections.release();
            return null;
        }
        this.channelsUDP.add((Object)channel);
        channel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                ChannelCreator.this.semaphoreOpenConnections.release();
            }
        });
        return channel;
    }

    public ChannelFuture createTCPChannel(ReplyTimeoutHandler timeoutHandler, FutureResponse futureResponse, int connectTimeoutMillis, int idleTCPMillis, Message message, RequestHandlerTCP requestHandler) {
        ChannelFuture channelFuture;
        if (this.shutdown.get()) {
            throw new RuntimeException("Cannot create channel if already shutdown");
        }
        final InetSocketAddress recipient = message.getRecipient().createSocketTCP();
        boolean newConnection = true;
        if (this.keepAliveAndReuse) {
            channelFuture = this.cacheMap.get(recipient.toString());
            if (channelFuture == null) {
                if (!this.semaphoreOpenConnections.tryAcquire()) {
                    throw new RuntimeException("you ran out of permits. You had " + this.permits + " available, but now its down to 0");
                }
                channelFuture = this.createChannelTCP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, recipient, new InetSocketAddress(0), connectTimeoutMillis);
                this.cacheMap.put(recipient.toString(), channelFuture);
            } else {
                newConnection = false;
                ReplyTimeoutHandler oldTimoutHandler = (ReplyTimeoutHandler)channelFuture.getChannel().getPipeline().replace("timeout", "timeout", (ChannelHandler)timeoutHandler);
                oldTimoutHandler.abort();
                channelFuture.getChannel().getPipeline().replace("request", "request", (ChannelHandler)requestHandler);
            }
        } else {
            if (!this.semaphoreOpenConnections.tryAcquire()) {
                throw new RuntimeException("you ran out of permits. You had " + this.permits + " available, but now its down to 0");
            }
            try {
                channelFuture = this.createChannelTCP((ChannelHandler)timeoutHandler, (ChannelHandler)requestHandler, recipient, new InetSocketAddress(0), connectTimeoutMillis);
            }
            catch (Exception e) {
                futureResponse.setFailed("Cannot create channel " + e);
                this.semaphoreOpenConnections.release();
                return null;
            }
        }
        Channel channel = channelFuture.getChannel();
        this.channelsTCP.add((Object)channel);
        if (newConnection) {
            channel.getCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    ChannelCreator.this.semaphoreOpenConnections.release();
                    if (ChannelCreator.this.keepAliveAndReuse) {
                        ChannelCreator.this.cacheMap.remove(recipient.toString());
                    }
                }
            });
        }
        return channelFuture;
    }

    public void release() {
        this.connectionReservation.release(this.permits);
    }

    public void release(int nr) {
        this.connectionReservation.release(nr);
    }

    public void releaseCreating() {
        this.connectionReservation.releaseCreating(this.permits);
    }

    public void releaseOpen() {
        this.connectionReservation.releaseOpen(this.permits);
    }

    private ChannelFuture createChannelTCP(ChannelHandler timeoutHandler, ChannelHandler requestHandler, SocketAddress remoteAddress, SocketAddress localAddress, int connectionTimoutMillis) {
        statConnectionsCreatedTCP.incrementAndGet();
        ClientBootstrap bootstrap = new ClientBootstrap(this.tcpClientChannelFactory);
        bootstrap.setOption("connectTimeoutMillis", (Object)connectionTimoutMillis);
        bootstrap.setOption("tcpNoDelay", (Object)true);
        bootstrap.setOption("soLinger", (Object)0);
        bootstrap.setOption("reuseAddress", (Object)true);
        bootstrap.setOption("keepAlive", (Object)true);
        ChannelCreator.setupBootstrapTCP((Bootstrap)bootstrap, timeoutHandler, requestHandler, (ChannelUpstreamHandler)new TomP2PDecoderTCP(), new TomP2PEncoderTCP(), new ChunkedWriteHandler(), (ChannelHandler)this.messageLoggerFilter);
        ChannelFuture channelFuture = bootstrap.connect(remoteAddress);
        return channelFuture;
    }

    private Channel createChannelUDP(ChannelHandler timeoutHandler, ChannelHandler replyHandler, boolean allowBroadcast) {
        statConnectionsCreatedUDP.incrementAndGet();
        ConnectionlessBootstrap bootstrap = new ConnectionlessBootstrap(this.udpChannelFactory);
        ChannelCreator.setupBootstrapUDP((Bootstrap)bootstrap, timeoutHandler, replyHandler, new TomP2PDecoderUDP(), new TomP2PEncoderUDP(), null);
        bootstrap.setOption("broadcast", (Object)(allowBroadcast ? 1 : 0));
        bootstrap.setOption("receiveBufferSizePredictor", (Object)new FixedReceiveBufferSizePredictor(1400));
        Channel c = bootstrap.bind((SocketAddress)new InetSocketAddress(0));
        return c;
    }

    static void setupBootstrapTCP(Bootstrap bootstrap, ChannelHandler timeoutHandler, ChannelHandler requestHandler, ChannelUpstreamHandler decoder, ChannelDownstreamHandler encoder, ChunkedWriteHandler streamer, ChannelHandler messageLoggerFilter) {
        ChannelPipeline pipe = bootstrap.getPipeline();
        if (timeoutHandler != null) {
            pipe.addLast("timeout", timeoutHandler);
        }
        pipe.addLast("streamer", (ChannelHandler)streamer);
        pipe.addLast("encoder", (ChannelHandler)encoder);
        pipe.addLast("decoder", (ChannelHandler)decoder);
        if (messageLoggerFilter != null) {
            pipe.addLast("loggerUpstream", messageLoggerFilter);
        }
        if (requestHandler != null) {
            pipe.addLast("request", requestHandler);
        }
    }

    static void setupBootstrapUDP(Bootstrap bootstrap, ChannelHandler timeoutHandler, ChannelHandler requestHandler, ChannelUpstreamHandler decoder, ChannelDownstreamHandler encoder, ChannelHandler messageLoggerFilter) {
        ChannelPipeline pipe = bootstrap.getPipeline();
        if (timeoutHandler != null) {
            pipe.addLast("timeout", timeoutHandler);
        }
        pipe.addLast("encoder", (ChannelHandler)encoder);
        pipe.addLast("decoder", (ChannelHandler)decoder);
        if (messageLoggerFilter != null) {
            pipe.addLast("loggerUpstream", messageLoggerFilter);
        }
        if (requestHandler != null) {
            pipe.addLast("request", requestHandler);
        }
    }

    public void tryClose(PeerAddress destination) {
        ChannelFuture channelFuture = this.cacheMap.get(destination);
        if (channelFuture != null) {
            channelFuture.getChannel().close();
        }
    }

    public static void resetStat() {
        statConnectionsCreatedTCP.set(0L);
        statConnectionsCreatedUDP.set(0L);
    }

    public static long getStatConnectionsCreatedTCP() {
        return statConnectionsCreatedTCP.get();
    }

    public static long getStatConnectionsCreatedUDP() {
        return statConnectionsCreatedUDP.get();
    }
}

