/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.tomp2p.upnp.Device;
import net.tomp2p.upnp.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class RootDevice
extends Device {
    private final int specVersionMajor;
    private final int specVersionMinor;
    private long validityTime;
    private long creationTime;
    private final URL deviceDefLoc;
    private String deviceDefLocData;
    private final String vendorFirmware;
    private final String discoveryUSN;
    private final String discoveryUDN;
    private final InetAddress localIP;

    public static RootDevice build(URL deviceDef, String maxAge, String vendorFirmware, String discoveryUSN, String discoveryUDN, InetAddress localIP) {
        Document xml = XMLUtil.getXML(deviceDef);
        URL baseURL = null;
        try {
            String base = XMLUtil.xpath.evaluate("/root/URLBase", xml);
            try {
                if (base != null && base.trim().length() > 0) {
                    baseURL = new URL(base);
                }
            }
            catch (MalformedURLException malformedEx) {
                malformedEx.printStackTrace();
            }
            if (baseURL == null) {
                int lastSlash;
                String URL2 = deviceDef.getProtocol() + "://" + deviceDef.getHost() + ":" + deviceDef.getPort();
                String path = deviceDef.getPath();
                if (path != null && (lastSlash = path.lastIndexOf(47)) != -1) {
                    URL2 = URL2 + path.substring(0, lastSlash);
                }
                try {
                    baseURL = new URL(URL2);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
            }
            return new RootDevice(xml, baseURL, maxAge, deviceDef, vendorFirmware, discoveryUSN, discoveryUDN, localIP);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RootDevice(Document doc, URL urlBase, String maxAge, URL deviceDefinition, String vendorFirmware, String discoveryUSN, String discoveryUDN, InetAddress localIP) throws IllegalStateException, XPathExpressionException {
        super((Node)XMLUtil.xpath.evaluate("root/device", doc, XPathConstants.NODE), null, urlBase);
        this.deviceDefLoc = deviceDefinition;
        this.validityTime = Integer.parseInt(maxAge) * 1000;
        this.creationTime = System.currentTimeMillis();
        this.vendorFirmware = vendorFirmware;
        this.discoveryUSN = discoveryUSN;
        this.discoveryUDN = discoveryUDN;
        this.localIP = localIP;
        int svmaj = 0;
        int svmin = 0;
        try {
            svmaj = Integer.parseInt(XMLUtil.xpath.evaluate("root/specVersion/major", doc));
            svmin = Integer.parseInt(XMLUtil.xpath.evaluate("root/specVersion/minor", doc));
            if (svmaj != 1 || svmin != 0) {
                throw new IllegalStateException("Unsupported device version (" + svmaj + "." + svmin + ")");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.specVersionMajor = svmaj;
        this.specVersionMinor = svmin;
    }

    public long getValidityTime() {
        long elapsed = System.currentTimeMillis() - this.creationTime;
        return this.validityTime - elapsed;
    }

    public void resetValidityTime(String newMaxAge) {
        this.validityTime = Integer.parseInt(newMaxAge) * 1000;
        this.creationTime = System.currentTimeMillis();
    }

    public String getDeviceDefinitionXML() {
        if (this.deviceDefLocData == null) {
            try {
                InputStream in = this.deviceDefLoc.openConnection().getInputStream();
                int readen = 0;
                byte[] buff = new byte[512];
                StringBuilder strBuff = new StringBuilder();
                while ((readen = in.read(buff)) != -1) {
                    strBuff.append(new String(buff, 0, readen));
                }
                in.close();
                this.deviceDefLocData = strBuff.toString();
            }
            catch (IOException ioEx) {
                return null;
            }
        }
        return this.deviceDefLocData;
    }

    public int getSpecVersionMajor() {
        return this.specVersionMajor;
    }

    public int getSpecVersionMinor() {
        return this.specVersionMinor;
    }

    public String getVendorFirmware() {
        return this.vendorFirmware;
    }

    public String getDiscoveryUSN() {
        return this.discoveryUSN;
    }

    public String getDiscoveryUDN() {
        return this.discoveryUDN;
    }

    public InetAddress getLocalIP() {
        return this.localIP;
    }
}

