/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.message.MessageID;
import net.tomp2p.peers.PeerMap;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelUpstreamHandler;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestHandlerTCP
implements ChannelUpstreamHandler {
    private static final Logger logger = LoggerFactory.getLogger(RequestHandlerTCP.class);
    private final FutureResponse futureResponse;
    private final PeerBean peerBean;
    private final ConnectionBean connectionBean;
    private final Message message;
    private final AtomicBoolean handlingMessage = new AtomicBoolean(false);
    private final MessageID sendMessageID;

    public RequestHandlerTCP(FutureResponse futureResponse, PeerBean peerBean, ConnectionBean connectionBean, Message message) {
        this.peerBean = peerBean;
        this.connectionBean = connectionBean;
        this.futureResponse = futureResponse;
        this.message = message;
        this.sendMessageID = new MessageID(message);
    }

    public FutureResponse getFutureResponse() {
        return this.futureResponse;
    }

    public FutureResponse sendTCP(ChannelCreator channelCreator) {
        return this.sendTCP(channelCreator, this.connectionBean.getConfiguration().getIdleTCPMillis());
    }

    public FutureResponse sendTCP(ChannelCreator channelCreator, int idleTCPMillis) {
        this.connectionBean.getSender().sendTCP(this, this.futureResponse, this.message, channelCreator, idleTCPMillis);
        return this.futureResponse;
    }

    public FutureResponse fireAndForgetTCP(ChannelCreator channelCreator) {
        this.connectionBean.getSender().sendTCP(null, this.futureResponse, this.message, channelCreator, this.connectionBean.getConfiguration().getIdleTCPMillis());
        return this.futureResponse;
    }

    protected PeerMap getPeerMap() {
        return this.peerBean.getPeerMap();
    }

    public void setKeepAlive(boolean isKeepAlive) {
        this.message.setKeepAlive(isKeepAlive);
    }

    public void handleUpstream(ChannelHandlerContext ctx, ChannelEvent ce) throws Exception {
        if (!(ce instanceof MessageEvent)) {
            if (ce instanceof ExceptionEvent) {
                String msg = "Exception received: " + ((ExceptionEvent)ce).getCause();
                this.reportFail(msg, ctx.getChannel(), this.futureResponse);
                return;
            }
            ctx.sendUpstream(ce);
            return;
        }
        MessageEvent e = (MessageEvent)ce;
        if (!(e.getMessage() instanceof Message)) {
            String msg = "Message received, but not of type Message: " + e.getMessage();
            this.reportFail(msg, ctx.getChannel(), this.futureResponse);
            return;
        }
        Message responseMessage = (Message)e.getMessage();
        if (this.handlingMessage.compareAndSet(false, true)) {
            this.futureResponse.cancelTimeout();
        }
        MessageID recvMessageID = new MessageID(responseMessage);
        if (responseMessage.getType() == Message.Type.UNKNOWN_ID) {
            String msg = "Message was not delivered successfully: " + this.message;
            this.getPeerMap().peerOffline(this.futureResponse.getRequest().getRecipient(), true);
            this.reportFail(msg, ctx.getChannel(), this.futureResponse);
        } else if (responseMessage.getType() == Message.Type.EXCEPTION) {
            String msg = "Message caused an exception on the other side, handle as peer_abort: " + this.message;
            this.reportFail(msg, ctx.getChannel(), this.futureResponse);
        } else if (!this.sendMessageID.equals(recvMessageID)) {
            String msg = "Message [" + responseMessage + "] sent to the node is not the same as we expect (TCP). We sent [" + this.message + "]";
            this.reportFail(msg, ctx.getChannel(), this.futureResponse);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("perfect: " + responseMessage);
            }
            if (responseMessage.isOk() || responseMessage.isNotOk()) {
                this.getPeerMap().peerFound(responseMessage.getSender(), null);
            }
            this.reportResult(ctx.getChannel(), this.futureResponse, responseMessage);
        }
    }

    private void reportFail(final String cause, Channel channel, final FutureResponse futureResponse) {
        if (logger.isDebugEnabled()) {
            logger.debug(cause);
        }
        channel.close();
        channel.getCloseFuture().addListener(new ChannelFutureListener(){

            public void operationComplete(ChannelFuture arg0) throws Exception {
                futureResponse.setFailed(cause);
            }
        });
    }

    private void reportResult(Channel channel, final FutureResponse futureResponse, final Message responseMessage) {
        if (this.message.isKeepAlive()) {
            futureResponse.setResponse(responseMessage);
        } else {
            channel.getCloseFuture().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture arg0) throws Exception {
                    futureResponse.setResponse(responseMessage);
                }
            });
        }
    }
}

