/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.replication;

import java.util.Map;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.futures.BaseFuture;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.futures.FutureRunnable;
import net.tomp2p.p2p.Peer;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.replication.ResponsibilityListener;
import net.tomp2p.rpc.PeerExchangeRPC;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackerStorageReplication
implements ResponsibilityListener {
    private static final Logger logger = LoggerFactory.getLogger(TrackerStorageReplication.class);
    private final PeerExchangeRPC peerExchangeRPC;
    private final Map<BaseFuture, Long> pendingFutures;
    private final TrackerStorage trackerStorage;
    private final Peer peer;

    public TrackerStorageReplication(Peer peer, PeerExchangeRPC peerExchangeRPC, Map<BaseFuture, Long> pendingFutures, TrackerStorage trackerStorage) {
        this.peer = peer;
        this.peerExchangeRPC = peerExchangeRPC;
        this.pendingFutures = pendingFutures;
        this.trackerStorage = trackerStorage;
    }

    @Override
    public void meResponsible(Number160 locationKey) {
    }

    @Override
    public void otherResponsible(final Number160 locationKey, final PeerAddress other) {
        if (logger.isDebugEnabled()) {
            logger.debug("other peer became responsibel and we thought we were responsible, so move the data to this peer");
        }
        for (final Number160 domainKey : this.trackerStorage.responsibleDomains(locationKey)) {
            FutureRunnable runner = new FutureRunnable(){
                private volatile FutureResponse futureResponse;

                @Override
                public void run() {
                    ChannelCreator cc = TrackerStorageReplication.this.peer.getConnectionBean().getReservation().reserve(1);
                    this.futureResponse = TrackerStorageReplication.this.peerExchangeRPC.peerExchange(other, locationKey, domainKey, true, cc);
                    Utils.addReleaseListener(this.futureResponse, cc, 1);
                    TrackerStorageReplication.this.pendingFutures.put(this.futureResponse, System.currentTimeMillis());
                }

                @Override
                public void failed(String reason) {
                    if (this.futureResponse != null) {
                        this.futureResponse.setFailed(reason);
                    }
                }
            };
            this.peer.getConnectionBean().getScheduler().callLater(runner);
        }
    }
}

