/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.peers.PeerAddress;

public class PeerConnection {
    private final PeerAddress destination;
    private final ChannelCreator channelCreator;
    private final int idleTCPMillis;
    private final Semaphore oneConnection = new Semaphore(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private volatile Runnable closeRunner;

    public PeerConnection(PeerAddress destination, ChannelCreator channelCreator, int idleTCPMillis) {
        this.destination = destination;
        this.channelCreator = channelCreator;
        this.idleTCPMillis = idleTCPMillis;
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.channelCreator.tryClose(this.getDestination());
            this.channelCreator.releaseOpen();
            this.closeRunner.run();
        }
    }

    public PeerAddress getDestination() {
        return this.destination;
    }

    public ChannelCreator getChannelCreator() {
        if (this.closed.get()) {
            throw new RuntimeException("cannot used a closed channel");
        }
        return this.channelCreator;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public int getIdleTCPMillis() {
        return this.idleTCPMillis;
    }

    public void aquireSingleConnection() throws InterruptedException {
        this.oneConnection.acquire();
    }

    public void releaseSingleConnection() {
        this.oneConnection.release();
    }

    public void setCloseRunner(Runnable closeRunner) {
        this.closeRunner = closeRunner;
    }
}

