/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.tomp2p.natpmp.Gateway;
import net.tomp2p.natpmp.MapRequestMessage;
import net.tomp2p.natpmp.NatPmpDevice;
import net.tomp2p.natpmp.NatPmpException;
import net.tomp2p.natpmp.ResultCode;
import net.tomp2p.upnp.InternetGatewayDevice;
import net.tomp2p.upnp.UPNPResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NATUtils {
    private static final Logger logger = LoggerFactory.getLogger(NATUtils.class);
    private final Map<InternetGatewayDevice, Integer> internetGatewayDevicesUDP = new HashMap<InternetGatewayDevice, Integer>();
    private final Map<InternetGatewayDevice, Integer> internetGatewayDevicesTCP = new HashMap<InternetGatewayDevice, Integer>();
    private NatPmpDevice pmpDevice;
    private Thread shutdownHookThread = null;
    private final Object shutdownLock = new Object();

    public NATUtils() {
        this.setShutdownHookEnabled(true);
    }

    public boolean mapPMP(int internalPortUDP, int internalPortTCP, int externalPortUDP, int externalPortTCP) throws NatPmpException {
        InetAddress gateway = Gateway.getIP();
        this.pmpDevice = new NatPmpDevice(gateway);
        MapRequestMessage mapTCP = new MapRequestMessage(true, internalPortTCP, externalPortTCP, Integer.MAX_VALUE, null);
        MapRequestMessage mapUDP = new MapRequestMessage(false, internalPortUDP, externalPortUDP, Integer.MAX_VALUE, null);
        this.pmpDevice.enqueueMessage(mapTCP);
        this.pmpDevice.enqueueMessage(mapUDP);
        this.pmpDevice.waitUntilQueueEmpty();
        return mapTCP.getResultCode() == ResultCode.Success;
    }

    public void mapUPNP(String internalHost, int internalPortUDP, int internalPortTCP, int externalPortUDP, int externalPortTCP) throws IOException {
        Collection<InternetGatewayDevice> IGDs = InternetGatewayDevice.getDevices(-1);
        if (IGDs == null) {
            return;
        }
        for (InternetGatewayDevice igd : IGDs) {
            logger.info("Found device " + igd);
            try {
                boolean mappedUDP;
                if (externalPortUDP != -1 && (mappedUDP = igd.addPortMapping("TomP2P mapping UDP", "UDP", internalHost, externalPortUDP, internalPortUDP))) {
                    this.internetGatewayDevicesUDP.put(igd, externalPortUDP);
                }
            }
            catch (IOException e) {
                logger.warn("error in mapping UPD UPNP " + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("error in mapping UDP UPNP " + e);
            }
            try {
                boolean mappedTCP;
                if (externalPortUDP == -1 || !(mappedTCP = igd.addPortMapping("TomP2P mapping TCP", "TCP", internalHost, externalPortTCP, internalPortTCP))) continue;
                this.internetGatewayDevicesTCP.put(igd, externalPortTCP);
            }
            catch (IOException e) {
                logger.warn("error in mapping TCP UPNP " + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("error in mapping TCP UPNP " + e);
            }
        }
    }

    private void unmapUPNP() {
        for (Map.Entry<InternetGatewayDevice, Integer> entry : this.internetGatewayDevicesTCP.entrySet()) {
            try {
                entry.getKey().deletePortMapping(null, entry.getValue(), "TCP");
            }
            catch (IOException e) {
                logger.warn("not removed TCP mapping " + entry.toString() + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("not removed TCP mapping " + entry.toString() + e);
            }
            logger.info("removed TCP mapping " + entry.toString());
        }
        for (Map.Entry<InternetGatewayDevice, Integer> entry : this.internetGatewayDevicesUDP.entrySet()) {
            try {
                entry.getKey().deletePortMapping(null, entry.getValue(), "UDP");
            }
            catch (IOException e) {
                logger.warn("not removed UDP mapping " + entry.toString() + e);
            }
            catch (UPNPResponseException e) {
                logger.warn("not removed UDP mapping " + entry.toString() + e);
            }
            logger.info("removed UDP mapping " + entry.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setShutdownHookEnabled(boolean enabled) {
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.isShutdownHookEnabled()) {
                if (!enabled) {
                    Runtime.getRuntime().removeShutdownHook(this.shutdownHookThread);
                    this.shutdownHookThread = null;
                }
            } else if (enabled) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        NATUtils.this.shutdown();
                    }
                }, "TomP2P:NATUtils:ShutdownHook");
                Runtime.getRuntime().addShutdownHook(t);
                this.shutdownHookThread = t;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.shutdownLock;
        synchronized (object) {
            this.setShutdownHookEnabled(false);
            this.unmapUPNP();
            if (this.pmpDevice != null) {
                this.pmpDevice.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isShutdownHookEnabled() {
        Object object = this.shutdownLock;
        synchronized (object) {
            return this.shutdownHookThread != null;
        }
    }
}

