/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.connection;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import net.tomp2p.connection.DiscoverNetwork;

public class Bindings {
    private final List<InetAddress> listenAddresses4 = new ArrayList<InetAddress>(1);
    private final List<InetAddress> listenAddresses6 = new ArrayList<InetAddress>(1);
    private final List<InetAddress> broadcastAddresses = new ArrayList<InetAddress>(1);
    private final List<String> listenInterfaceHints = new ArrayList<String>(1);
    private final List<Protocol> listenProtocolHints = new ArrayList<Protocol>(0);
    private final boolean listenBroadcast;
    private InetAddress externalAddress = null;
    private int externalTCPPort = 0;
    private int externalUDPPort = 0;

    public Bindings() {
        this(true);
    }

    public Bindings(InetAddress bind) {
        this.addAddress(bind);
        this.listenBroadcast = true;
    }

    public Bindings(boolean listenBroadcast) {
        this.listenBroadcast = listenBroadcast;
    }

    public Bindings(Protocol protocol) {
        this.addProtocol(protocol);
        this.listenBroadcast = true;
    }

    public Bindings(String iface) {
        this.addInterface(iface);
        this.listenBroadcast = true;
    }

    public Bindings(Protocol protocol, String iface) {
        this.addInterface(iface);
        this.addProtocol(protocol);
        this.listenBroadcast = true;
    }

    public Bindings(Protocol protocol, String iface, InetAddress externalAddress, int externalTCPPort, int externalUDPPort, boolean listenBroadcast) {
        this.addInterface(iface);
        this.addProtocol(protocol);
        this.externalAddress = externalAddress;
        this.externalTCPPort = externalTCPPort;
        this.externalUDPPort = externalUDPPort;
        this.listenBroadcast = listenBroadcast;
    }

    public void addAddress(InetAddress address) {
        if (address == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        if (address instanceof Inet4Address) {
            this.listenAddresses4.add(address);
        } else {
            this.listenAddresses6.add(address);
        }
    }

    public void addBroadcastAddress(InetAddress broadcastAddress) {
        if (broadcastAddress == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.broadcastAddresses.add(broadcastAddress);
    }

    public List<InetAddress> getAddresses() {
        ArrayList<InetAddress> listenAddresses = new ArrayList<InetAddress>();
        listenAddresses.addAll(this.listenAddresses4);
        listenAddresses.addAll(this.listenAddresses6);
        return listenAddresses;
    }

    public List<InetAddress> getBroadcastAddresses() {
        return this.broadcastAddresses;
    }

    public void addInterface(String interfaceHint) {
        if (interfaceHint == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.listenInterfaceHints.add(interfaceHint);
    }

    public List<String> getInterfaces() {
        return this.listenInterfaceHints;
    }

    public void addProtocol(Protocol protocol) {
        if (protocol == null) {
            throw new IllegalArgumentException("Cannot add null");
        }
        this.listenProtocolHints.add(protocol);
    }

    public List<Protocol> getProtocols() {
        return this.listenProtocolHints;
    }

    public void setAllInterfaces() {
        this.listenInterfaceHints.clear();
    }

    public boolean useAllInterfaces() {
        return this.listenInterfaceHints.size() == 0;
    }

    public void setAllProtocols() {
        this.listenProtocolHints.clear();
    }

    public boolean useAllProtocols() {
        return this.listenProtocolHints.size() == 0;
    }

    public boolean useIPv4() {
        return this.useAllProtocols() || this.listenProtocolHints.contains((Object)Protocol.IPv4);
    }

    public boolean useIPv6() {
        return this.useAllProtocols() || this.listenProtocolHints.contains((Object)Protocol.IPv6);
    }

    private StringBuilder discoverNetwork(NetworkInterface networkInterface) throws Exception {
        Class<?> dn = System.getProperty("java.vm.name").equals("Dalvik") || System.getProperty("java.version").startsWith("1.5") ? Class.forName("net.tomp2p.connection.DiscoverNetwork5") : Class.forName("net.tomp2p.connection.DiscoverNetwork6");
        DiscoverNetwork discoverNetwork = (DiscoverNetwork)dn.newInstance();
        discoverNetwork.init(this);
        return discoverNetwork.discoverNetwork(networkInterface);
    }

    public String discoverLocalInterfaces() throws Exception {
        StringBuilder sb = new StringBuilder("Status: ");
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface networkInterface = e.nextElement();
            if (this.useAllInterfaces()) {
                sb.append(" +").append(networkInterface.getName());
                sb.append((CharSequence)this.discoverNetwork(networkInterface)).append(",");
                continue;
            }
            if (this.getInterfaces().contains(networkInterface.getName())) {
                sb.append(" +").append(networkInterface.getName());
                sb.append((CharSequence)this.discoverNetwork(networkInterface)).append(",");
                continue;
            }
            sb.append(" -").append(networkInterface.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean isListenBroadcast() {
        return this.listenBroadcast;
    }

    public void setExternalAddress(InetAddress externalAddress, int externalTCPPort, int externalUDPPort) {
        if (externalAddress == null) {
            throw new IllegalArgumentException("address cannot be null");
        }
        if (externalTCPPort <= 0 || externalUDPPort <= 0) {
            throw new IllegalArgumentException("port needs to be > 0");
        }
        this.externalAddress = externalAddress;
        this.externalTCPPort = externalTCPPort;
        this.externalUDPPort = externalUDPPort;
    }

    public InetAddress getExternalAddress() {
        return this.externalAddress;
    }

    public int getOutsideTCPPort() {
        return this.externalTCPPort;
    }

    public int getOutsideUDPPort() {
        return this.externalUDPPort;
    }

    public boolean isOutsideAddressSet() {
        return this.externalAddress != null;
    }

    public void setOutsidePortUDP(int externalUDPPort) {
        this.externalUDPPort = externalUDPPort;
    }

    public void setOutsidePortTCP(int externalTCPPort) {
        this.externalTCPPort = externalTCPPort;
    }

    public static enum Protocol {
        IPv4,
        IPv6;

    }
}

