/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.upnp;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashSet;
import net.tomp2p.upnp.Action;
import net.tomp2p.upnp.ActionMessage;
import net.tomp2p.upnp.ActionResponse;
import net.tomp2p.upnp.Device;
import net.tomp2p.upnp.Discovery;
import net.tomp2p.upnp.RootDevice;
import net.tomp2p.upnp.Service;
import net.tomp2p.upnp.StateVariable;
import net.tomp2p.upnp.StateVariableMessage;
import net.tomp2p.upnp.StateVariableResponse;
import net.tomp2p.upnp.UPNPMessageFactory;
import net.tomp2p.upnp.UPNPResponseException;

public class InternetGatewayDevice {
    private RootDevice igd;
    private UPNPMessageFactory msgFactory;

    private InternetGatewayDevice(RootDevice igd, boolean WANIPConnection, boolean WANPPPConnection) throws UnsupportedOperationException {
        this.igd = igd;
        Device myIGDWANConnDevice = igd.getChildDevice("urn:schemas-upnp-org:device:WANConnectionDevice:1");
        if (myIGDWANConnDevice == null) {
            throw new UnsupportedOperationException("device urn:schemas-upnp-org:device:WANConnectionDevice:1 not supported by IGD device " + igd.modelName);
        }
        Service wanIPSrv = myIGDWANConnDevice.getService("urn:schemas-upnp-org:service:WANIPConnection:1");
        Service wanPPPSrv = myIGDWANConnDevice.getService("urn:schemas-upnp-org:service:WANPPPConnection:1");
        if (WANIPConnection && WANPPPConnection && wanIPSrv == null && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 or urn:schemas-upnp-org:service:WANPPPConnection:1 service");
        }
        if (WANIPConnection && !WANPPPConnection && wanIPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 service");
        }
        if (!WANIPConnection && WANPPPConnection && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANPPPConnection:1 service");
        }
        if (wanIPSrv != null && wanPPPSrv == null) {
            this.msgFactory = new UPNPMessageFactory(wanIPSrv);
        } else if (wanPPPSrv != null && wanIPSrv == null) {
            this.msgFactory = new UPNPMessageFactory(wanPPPSrv);
        } else {
            Device wanDevice = igd.getChildDevice("urn:schemas-upnp-org:device:WANDevice:1");
            Service configService = wanDevice.getService("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1");
            if (configService != null) {
                Action act = configService.getUPNPServiceAction("GetActiveConnection");
                if (act != null) {
                    UPNPMessageFactory msg = new UPNPMessageFactory(configService);
                    String deviceContainer = null;
                    String serviceID = null;
                    try {
                        ActionResponse resp = msg.getMessage("GetActiveConnection").setInputParameter("NewActiveConnectionIndex", 0).service();
                        deviceContainer = resp.getOutActionArgumentValue("NewActiveConnDeviceContainer");
                        serviceID = resp.getOutActionArgumentValue("NewActiveConnectionServiceID");
                    }
                    catch (IOException ex) {
                    }
                    catch (UPNPResponseException respEx) {
                        // empty catch block
                    }
                    if (deviceContainer != null && deviceContainer.trim().length() > 0 && serviceID != null && serviceID.trim().length() > 0) {
                        for (Device dv : igd.getChildDevices()) {
                            if (!deviceContainer.startsWith(dv.UDN) || dv.deviceType.indexOf(":WANConnectionDevice:") == -1) continue;
                            myIGDWANConnDevice = dv;
                            break;
                        }
                        this.msgFactory = new UPNPMessageFactory(myIGDWANConnDevice.getServiceByID(serviceID));
                    }
                } else {
                    StateVariable wat = configService.getUPNPServiceStateVariable("WANAccessType");
                    assert (wat != null) : "bugged upnp implementation";
                    try {
                        String accessType = wat.getValue();
                        System.out.println(accessType);
                        if (accessType.equals("DSL") || accessType.equals("POTS")) {
                            this.msgFactory = new UPNPMessageFactory(wanPPPSrv);
                        } else if (accessType.equals("Cable") || accessType.equals("Ethernet")) {
                            this.msgFactory = new UPNPMessageFactory(wanIPSrv);
                        } else assert (false) : "Illegal access type : " + accessType;
                    }
                    catch (UPNPResponseException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.msgFactory == null) {
                if (this.testWANInterface(wanIPSrv)) {
                    this.msgFactory = new UPNPMessageFactory(wanIPSrv);
                } else if (this.testWANInterface(wanPPPSrv)) {
                    this.msgFactory = new UPNPMessageFactory(wanPPPSrv);
                }
            }
            if (this.msgFactory == null) {
                this.msgFactory = new UPNPMessageFactory(wanIPSrv);
            }
        }
    }

    private boolean testWANInterface(Service srv) {
        UPNPMessageFactory tmp = new UPNPMessageFactory(srv);
        ActionMessage msg = tmp.getMessage("GetExternalIPAddress");
        String ipToParse = null;
        try {
            ipToParse = msg.service().getOutActionArgumentValue("NewExternalIPAddress");
        }
        catch (UPNPResponseException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (ipToParse != null && ipToParse.length() > 0 && !ipToParse.equals("0.0.0.0")) {
            try {
                return InetAddress.getByName(ipToParse) != null;
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        return false;
    }

    public RootDevice getIGDRootDevice() {
        return this.igd;
    }

    public static Collection<InternetGatewayDevice> getDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, 4, 3, true, true, null);
    }

    public static Collection<InternetGatewayDevice> getDevices(int timeout, int ttl, int mx, NetworkInterface ni) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, ttl, mx, true, true, ni);
    }

    private static Collection<InternetGatewayDevice> lookupDeviceDevices(int timeout, int ttl, int mx, boolean WANIPConnection, boolean WANPPPConnection, NetworkInterface ni) throws IOException {
        Collection<RootDevice> devices = Discovery.discover(timeout == -1 ? 1500 : timeout, ttl, mx, "urn:schemas-upnp-org:device:InternetGatewayDevice:1", ni);
        if (devices == null) {
            return null;
        }
        HashSet<InternetGatewayDevice> valid = new HashSet<InternetGatewayDevice>();
        for (RootDevice device : devices) {
            try {
                valid.add(new InternetGatewayDevice(device, WANIPConnection, WANPPPConnection));
            }
            catch (UnsupportedOperationException ex) {}
        }
        if (valid.size() == 0) {
            return null;
        }
        return valid;
    }

    public String getExternalIPAddress() throws UPNPResponseException, IOException {
        ActionMessage msg = this.msgFactory.getMessage("GetExternalIPAddress");
        return msg.service().getOutActionArgumentValue("NewExternalIPAddress");
    }

    public ActionResponse getGenericPortMappingEntry(int newPortMappingIndex) throws IOException, UPNPResponseException {
        ActionMessage msg = this.msgFactory.getMessage("GetGenericPortMappingEntry");
        msg.setInputParameter("NewPortMappingIndex", newPortMappingIndex);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public ActionResponse getSpecificPortMappingEntry(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("GetSpecificPortMappingEntry");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public boolean addPortMapping(String description, String protocol, String internalHost, int externalPort, int internalPort) throws IOException, UPNPResponseException {
        return this.addPortMapping(description, protocol, null, externalPort, internalHost, internalPort, 0);
    }

    public boolean addPortMapping(String description, String protocol, String remoteHost, int externalPort, String internalClient, int internalPort, int leaseDuration) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        if (externalPort != 0) {
            this.checkPortRange(externalPort);
        }
        this.checkPortRange(internalPort);
        String string = description = description == null ? "" : description;
        if (leaseDuration < 0) {
            throw new IllegalArgumentException("Invalid leaseDuration (" + leaseDuration + ") value");
        }
        ActionMessage msg = this.msgFactory.getMessage("AddPortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol).setInputParameter("NewInternalPort", internalPort).setInputParameter("NewInternalClient", internalClient).setInputParameter("NewEnabled", true).setInputParameter("NewPortMappingDescription", description).setInputParameter("NewLeaseDuration", leaseDuration);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 718) {
                return false;
            }
            throw ex;
        }
    }

    public boolean deletePortMapping(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("DeletePortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return false;
            }
            throw ex;
        }
    }

    public Integer getNatMappingsCount() throws IOException, UPNPResponseException {
        Integer rtrval;
        block2: {
            rtrval = null;
            StateVariableMessage natTableSize = this.msgFactory.getStateVariableMessage("PortMappingNumberOfEntries");
            try {
                StateVariableResponse resp = natTableSize.service();
                rtrval = new Integer(resp.getStateVariableValue());
            }
            catch (UPNPResponseException ex) {
                if (ex.getDetailErrorCode() == 404) break block2;
                throw ex;
            }
        }
        return rtrval;
    }

    private void checkPortMappingProtocol(String prot) throws IllegalArgumentException {
        if (prot == null || !prot.equals("TCP") && !prot.equals("UDP")) {
            throw new IllegalArgumentException("PortMappingProtocol must be either TCP or UDP");
        }
    }

    private void checkPortRange(int port) throws IllegalArgumentException {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port range must be between 1 and 65535");
        }
    }
}

