/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.rpc;

import com.google.common.collect.MapMaker;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.tomp2p.connection.ChannelCreator;
import net.tomp2p.connection.ConnectionBean;
import net.tomp2p.connection.PeerBean;
import net.tomp2p.futures.FutureResponse;
import net.tomp2p.message.Message;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.rpc.ReplyHandler;
import net.tomp2p.rpc.RequestHandlerUDP;
import net.tomp2p.storage.TrackerData;
import net.tomp2p.storage.TrackerStorage;
import net.tomp2p.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerExchangeRPC
extends ReplyHandler {
    private static final Logger logger = LoggerFactory.getLogger(PeerExchangeRPC.class);
    private final Map<Number160, Set<Number160>> sentPeers;

    public PeerExchangeRPC(PeerBean peerBean, ConnectionBean connectionBean) {
        super(peerBean, connectionBean);
        this.registerIoHandler(Message.Command.PEX);
        this.sentPeers = new MapMaker().concurrencyLevel(1).expireAfterAccess(1L, TimeUnit.DAYS).makeMap();
    }

    public FutureResponse peerExchange(PeerAddress remoteNode, Number160 locationKey, Number160 domainKey, boolean isReplication, ChannelCreator channelCreator) {
        Map<Number160, TrackerData> peers;
        Message message = this.createMessage(remoteNode, Message.Command.PEX, isReplication ? Message.Type.REQUEST_FF_2 : Message.Type.REQUEST_FF_1);
        Set<Number160> tmp1 = this.sentPeers.get(remoteNode.getID());
        if (tmp1 == null) {
            tmp1 = new HashSet<Number160>();
            this.sentPeers.put(remoteNode.getID(), tmp1);
        }
        if (isReplication) {
            peers = this.peerBean.getTrackerStorage().meshPeers(locationKey, domainKey);
            if (logger.isDebugEnabled()) {
                logger.debug("we got stored meshPeers size:" + peers.size());
            }
        } else {
            peers = this.peerBean.getTrackerStorage().activePeers(locationKey, domainKey);
            if (logger.isDebugEnabled()) {
                logger.debug("we got stored activePeers size:" + peers.size());
            }
        }
        peers = Utils.subtract(peers, tmp1);
        peers = Utils.limit(peers, 35);
        tmp1.addAll(peers.keySet());
        message.setKeyKey(locationKey, domainKey);
        if (peers.size() > 0) {
            message.setTrackerData(peers.values());
        }
        if (peers.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug("sent (" + message.getSender().getID() + ") to " + remoteNode.getID() + " / " + peers.size());
            }
            FutureResponse futureResponse = new FutureResponse(message);
            RequestHandlerUDP requestHandler = new RequestHandlerUDP(futureResponse, this.peerBean, this.connectionBean, message);
            return requestHandler.fireAndForgetUDP(channelCreator);
        }
        FutureResponse futureResponse = new FutureResponse(message);
        futureResponse.setResponse();
        return futureResponse;
    }

    @Override
    public boolean checkMessage(Message message) {
        return (message.getType() == Message.Type.REQUEST_FF_1 || message.getType() == Message.Type.REQUEST_FF_2) && message.getCommand() == Message.Command.PEX;
    }

    @Override
    public Message handleResponse(Message message, boolean sign) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug("Received Peer Exchange Message " + message);
        }
        Collection<TrackerData> tmp = message.getTrackerData();
        Number160 locationKey = message.getKeyKey1();
        Number160 domainKey = message.getKeyKey2();
        Collection<Number160> removedKeys = message.getKeys();
        if (tmp != null && tmp.size() > 0 && locationKey != null && domainKey != null) {
            PeerAddress referrer = message.getSender();
            for (TrackerData data : tmp) {
                PeerAddress trackerEntry = data.getPeerAddress();
                this.peerBean.getTrackerStorage().putReferred(locationKey, domainKey, trackerEntry, referrer, data.getAttachement(), data.getOffset(), data.getLength(), message.getType() == Message.Type.REQUEST_FF_1 ? TrackerStorage.ReferrerType.ACTIVE : TrackerStorage.ReferrerType.MESH);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Adding " + data.getPeerAddress() + " to the map. I'm " + message.getRecipient());
            }
            if (removedKeys != null) {
                for (Number160 key : removedKeys) {
                    this.peerBean.getTrackerStorage().removeReferred(locationKey, domainKey, key, referrer);
                }
            }
        }
        return message;
    }
}

