/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.peers;

import java.io.UnsupportedEncodingException;
import net.tomp2p.peers.Number160;

public final class ShortString
implements Comparable<ShortString> {
    private final String s1;
    private final Number160 number160;

    public ShortString(String s1) {
        byte[] me;
        try {
            me = s1.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (me.length > 19) {
            throw new IllegalArgumentException("String too large. Max size is 19 in UTF-8");
        }
        byte[] me2 = new byte[me.length + 1];
        me2[0] = (byte)me.length;
        System.arraycopy(me, 0, me2, 1, me.length);
        this.s1 = s1;
        this.number160 = new Number160(me2);
    }

    public ShortString(Number160 number160) throws UnsupportedEncodingException {
        byte[] tmp = number160.toByteArray();
        byte len = tmp[0];
        this.s1 = new String(tmp, 1, (int)len);
        this.number160 = number160;
    }

    public Number160 toNumber160() {
        return this.number160;
    }

    public String toString() {
        return this.s1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ShortString) {
            return this.s1.equals(((ShortString)obj).s1);
        }
        return false;
    }

    @Override
    public int compareTo(ShortString o) {
        return this.s1.compareTo(o.s1);
    }
}

