/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.security.PublicKey;
import java.util.concurrent.ConcurrentHashMap;
import net.tomp2p.peers.Number160;
import net.tomp2p.peers.PeerAddress;
import net.tomp2p.peers.PeerStatusListener;

public class IdentityManagement
implements PeerStatusListener {
    private final ConcurrentHashMap<Number160, PublicKey> peerIdentity = new ConcurrentHashMap();
    private final PeerAddress self;

    public IdentityManagement(PeerAddress self) {
        this.self = self;
    }

    public boolean checkIdentity(Number160 peerId, PublicKey publicKey) {
        PublicKey storedIdentity = this.peerIdentity.get(peerId);
        if (storedIdentity != null) {
            return storedIdentity.equals(publicKey);
        }
        if (publicKey != null) {
            if (this.peerIdentity.putIfAbsent(peerId, publicKey) != null) {
                return this.checkIdentity(peerId, publicKey);
            }
            return true;
        }
        return true;
    }

    @Override
    public void peerOffline(PeerAddress peerAddress, PeerStatusListener.Reason reason) {
    }

    @Override
    public void peerFail(PeerAddress peerAddress) {
    }

    @Override
    public void peerOnline(PeerAddress peerAddress) {
    }

    public Number160 getSelf() {
        return this.self.getID();
    }

    public PeerAddress getPeerAddress() {
        return this.self;
    }
}

