/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.tomp2p.futures.FutureRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Scheduler {
    private static final Logger logger = LoggerFactory.getLogger(Scheduler.class);
    private static final String THREAD_NAME2 = "Peer-call-later-thread";
    private final BlockingQueue<FutureRunnable> invokeLater2 = new LinkedBlockingQueue<FutureRunnable>();
    private final Thread laterThread2 = this.createThread("Peer-call-later-thread", this.invokeLater2);
    private volatile boolean running = true;

    private Thread createThread(String name, final BlockingQueue<FutureRunnable> invokeLater) {
        Thread laterThread = new Thread(new Runnable(){

            @Override
            public void run() {
                FutureRunnable runner = null;
                while (Scheduler.this.running) {
                    try {
                        runner = (FutureRunnable)invokeLater.take();
                        runner.run();
                    }
                    catch (InterruptedException ie) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("interrupted, check if we need to exit this thread");
                    }
                    catch (Exception e) {
                        logger.error("Exception in runner: " + e.toString());
                        e.printStackTrace();
                    }
                }
                while ((runner = (FutureRunnable)invokeLater.poll()) != null) {
                    runner.failed("Shutting down...");
                }
            }
        });
        laterThread.start();
        return laterThread;
    }

    public void callLater(FutureRunnable runner) {
        if (Thread.currentThread().getName().equals(THREAD_NAME2)) {
            throw new RuntimeException("This is not a good idea to call callLater() here, since we are already coming from a call later. Typically, you will reserve a connection, which blocks and will block this thread.");
        }
        if (!this.running) {
            runner.failed("Shutting down...");
            return;
        }
        this.invokeLater2.offer(runner);
    }

    public void shutdownAndWait() {
        this.running = false;
        this.laterThread2.interrupt();
    }
}

