/*
 * Decompiled with CFR 0.152.
 */
package net.tomp2p.p2p;

public class RoutingConfiguration {
    private final int directHits;
    private final int maxNoNewInfoDiff;
    private final int maxFailures;
    private final int maxSuccess;
    private final int parallel;

    public RoutingConfiguration(int maxNoNewInfoDiff, int maxFailures, int parallel) {
        this(Integer.MAX_VALUE, maxNoNewInfoDiff, maxFailures, 20, parallel);
    }

    public RoutingConfiguration(int maxNoNewInfoDiff, int maxFailures, int maxSuccess, int parallel) {
        this(Integer.MAX_VALUE, maxNoNewInfoDiff, maxFailures, maxSuccess, parallel);
    }

    public RoutingConfiguration(int directHits, int maxNoNewInfoDiff, int maxFailures, int maxSuccess, int parallel) {
        if (directHits < 0 || maxNoNewInfoDiff < 0 || maxFailures < 0 || parallel < 0) {
            throw new IllegalArgumentException("need to be larger or equals zero");
        }
        this.directHits = directHits;
        this.maxNoNewInfoDiff = maxNoNewInfoDiff;
        this.maxFailures = maxFailures;
        this.maxSuccess = maxSuccess;
        this.parallel = parallel;
    }

    public int getDirectHits() {
        return this.directHits;
    }

    public int getMaxNoNewInfoDiff() {
        return this.maxNoNewInfoDiff;
    }

    public int getMaxNoNewInfo(int minimumResults) {
        return this.maxNoNewInfoDiff + minimumResults;
    }

    public int getMaxFailures() {
        return this.maxFailures;
    }

    public int getMaxSuccess() {
        return this.maxSuccess;
    }

    public int getParallel() {
        return this.parallel;
    }
}

